/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;

public class BaseCodecSerializer<T>
implements INBTSerializer<T> {
    protected final Codec<T> codec;
    protected final Supplier<T> defaultValue;

    public BaseCodecSerializer(Codec<T> codec, Supplier<T> defaultValue) {
        this.codec = codec;
        this.defaultValue = defaultValue;
    }

    @Override
    public void serialize(CompoundTag nbt, String key, @NotNull T value) {
        this.codec.encodeStart((DynamicOps)NbtOps.f_128958_, value).result().ifPresent(tag -> nbt.m_128365_(key, tag));
    }

    @Override
    public T deserialize(CompoundTag nbt, String key) {
        Tag tag = nbt.m_128423_(key);
        if (tag != null) {
            return (T)this.codec.decode((DynamicOps)NbtOps.f_128958_, (Object)tag).result().map(Pair::getFirst).orElseGet(this.defaultValue);
        }
        return this.defaultValue.get();
    }
}

