/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientWithCount(Ingredient input, int count) {
    public static final IngredientWithCount EMPTY = new IngredientWithCount(Ingredient.f_43901_, 0);

    public void toNetwork(FriendlyByteBuf buf) {
        this.input.m_43923_(buf);
        buf.m_130130_(this.count);
    }

    public boolean isEmpty() {
        return this.input.m_43947_() || this.count <= 0;
    }

    public NonNullList<Ingredient> applyCount() {
        return NonNullList.m_122780_((int)this.count, (Object)this.input);
    }

    public static IngredientWithCount fromJson(JsonElement obj) {
        Ingredient input = Ingredient.m_43917_((JsonElement)obj);
        int count = GsonHelper.m_13824_((JsonObject)obj.getAsJsonObject(), (String)"count", (int)1);
        return new IngredientWithCount(input, count);
    }

    public static IngredientWithCount fromNetwork(FriendlyByteBuf buf) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int count = buf.m_130242_();
        return new IngredientWithCount(input, count);
    }

    public boolean test(ItemStack item) {
        return this.input.test(item) && item.m_41613_() >= this.count;
    }
}

