/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.ApiStatus;
import org.zeith.hammerlib.mixins.LootTableAccessor;

public class LootTableAdapter {
    private static final Map<ResourceLocation, UnaryOperator<LootTable>> TABLE_ALTERATORS = new ConcurrentHashMap<ResourceLocation, UnaryOperator<LootTable>>();
    private static final List<BiConsumer<ResourceLocation, LootTable>> TABLE_HOOKS = new ArrayList<BiConsumer<ResourceLocation, LootTable>>();

    public static List<LootPool> getPools(LootTable table) {
        return ((LootTableAccessor)table).getPools();
    }

    public static void alterTable(ResourceLocation id, UnaryOperator<LootTable> alterator) {
        UnaryOperator<LootTable> prev = TABLE_ALTERATORS.get(id);
        if (prev != null) {
            alterator = prev.andThen(alterator)::apply;
        }
        TABLE_ALTERATORS.put(id, alterator);
    }

    public static void addLoadHook(BiConsumer<ResourceLocation, LootTable> hook) {
        TABLE_HOOKS.add(hook);
    }

    @ApiStatus.Internal
    public static LootTable alter(LootTable table) {
        ResourceLocation id = table.getLootTableId();
        LootTable t1 = (LootTable)TABLE_ALTERATORS.getOrDefault(id, UnaryOperator.identity()).apply(table);
        TABLE_HOOKS.forEach(c -> c.accept(id, t1));
        return t1;
    }
}

