/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hex_ars_link.config;

import io.yukkuric.hex_ars_link.config.LinkConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class LinkConfigForge
implements LinkConfig.API {
    public ForgeConfigSpec.DoubleValue cfgRatioLv1;
    public ForgeConfigSpec.DoubleValue cfgRatioLv2;
    public ForgeConfigSpec.DoubleValue cfgRatioLv3;
    public ForgeConfigSpec.DoubleValue cfgRatioExtraMediaCasting;
    public ForgeConfigSpec.DoubleValue cfgCostRatePatternMana;
    public ForgeConfigSpec.IntValue cfgMaxCallbackRecursionDepth;
    public ForgeConfigSpec.IntValue cfgExtraOpsConsumedForCallbacks;
    private static final Pair<LinkConfigForge, ForgeConfigSpec> CFG_REGISTRY = new ForgeConfigSpec.Builder().configure(LinkConfigForge::new);

    @Override
    public double ratioLv1() {
        return (Double)this.cfgRatioLv1.get();
    }

    @Override
    public double ratioLv2() {
        return (Double)this.cfgRatioLv2.get();
    }

    @Override
    public double ratioLv3() {
        return (Double)this.cfgRatioLv3.get();
    }

    @Override
    public double ratioExtraMediaCasting() {
        return (Double)this.cfgRatioExtraMediaCasting.get();
    }

    @Override
    public double costRatePatternMana() {
        return (Double)this.cfgCostRatePatternMana.get();
    }

    @Override
    public int maxCallbackRecursionDepth() {
        return (Integer)this.cfgMaxCallbackRecursionDepth.get();
    }

    @Override
    public int extraOpsConsumedForCallbacks() {
        return (Integer)this.cfgExtraOpsConsumedForCallbacks.get();
    }

    public LinkConfigForge(ForgeConfigSpec.Builder builder) {
        this.cfgRatioLv1 = builder.comment("convert ratio for lesser linker").defineInRange("ratioLv1", 10.0, 0.0, 1.0E10);
        this.cfgRatioLv2 = builder.comment("convert ratio for advanced linker").defineInRange("ratioLv2", 200.0, 0.0, 1.0E10);
        this.cfgRatioLv3 = builder.comment("convert ratio for great linker").defineInRange("ratioLv3", 500.0, 0.0, 1.0E10);
        this.cfgRatioExtraMediaCasting = builder.comment("ADDITIONAL media cost ratio for mana used in casting patterns (total media cost = base pattern cost + <ratio> * ORIGINAL spell mana cost); 0 by default.").defineInRange("ratioExtraMediaCasting", 0.0, 0.0, 1.0E10);
        this.cfgCostRatePatternMana = builder.comment("mana discount (or penalty) rate for pattern casters (final mana cost = <ratio> * ORIGINAL spell mana cost); 1 by default.").defineInRange("costRatePatternMana", 1.0, 0.0, 1.0E10);
        this.cfgMaxCallbackRecursionDepth = builder.comment("max depth nested callback could be triggered; spells deeper than this loses all ambit.").defineInRange("maxCallbackRecursionDepth", 10, 1, 114514);
        this.cfgExtraOpsConsumedForCallbacks = builder.comment("how many extra ops consumed initially for a callback spell.").defineInRange("extraOpsConsumedForCallbacks", 50000, 0, Integer.MAX_VALUE);
    }

    public static void register(ModLoadingContext ctx) {
        LinkConfig.bind((LinkConfig.API)CFG_REGISTRY.getKey());
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CFG_REGISTRY.getValue());
    }
}

