/*
 * Decompiled with CFR 0.152.
 */
package io.yukkuric.hex_ars_link.items;

import at.petrak.hexcasting.api.utils.NBTHelper;
import com.hollingsworth.arsnouveau.api.nbt.ItemstackData;
import io.yukkuric.hex_ars_link.HexArsLink;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface OwnerBinder {
    @Nullable
    default public Player getOwner(ItemStack stack) {
        return new OwnerData(stack).getOwner();
    }

    default public void setOwner(ItemStack stack, Player player) {
        new OwnerData(stack).setOwner(player);
    }

    default public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_6144_()) {
            this.setOwner(stack, null);
        } else {
            this.setOwner(stack, player);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    default public void appendOwnerTooltip(ItemStack stack, List<Component> tooltips) {
        String playerName = NBTHelper.getString((ItemStack)stack, (String)"name");
        if (playerName == null || playerName.isEmpty()) {
            tooltips.add((Component)Component.m_237115_((String)"hex_ars_link.tooltip.owner.null"));
        } else {
            MutableComponent nameComp = Component.m_237113_((String)playerName).m_130940_(ChatFormatting.GOLD);
            tooltips.add((Component)Component.m_237110_((String)"hex_ars_link.tooltip.owner", (Object[])new Object[]{nameComp}));
        }
    }

    public static class OwnerData
    extends ItemstackData {
        private UUID ownerUUID;

        public OwnerData(ItemStack stack) {
            super(stack);
            CompoundTag tag = this.getItemTag(stack);
            try {
                this.ownerUUID = tag.m_128342_("owner");
            }
            catch (Exception e) {
                this.ownerUUID = new UUID(114L, 514L);
                this.writeItem();
            }
        }

        public String getTagString() {
            return "hex_staff";
        }

        public void writeToNBT(CompoundTag tag) {
            tag.m_128362_("owner", this.ownerUUID);
        }

        public ServerPlayer getOwner() {
            if (HexArsLink.SERVER == null) {
                return null;
            }
            return HexArsLink.SERVER.m_6846_().m_11259_(this.ownerUUID);
        }

        public void setOwner(@Nullable Player player) {
            this.ownerUUID = player == null ? new UUID(1919L, 810L) : player.m_20148_();
            this.writeItem();
        }
    }
}

