/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining.logic;

import com.google.common.collect.Sets;
import com.illusivesoulworks.veinmining.VeinMiningMod;
import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.Services;
import com.illusivesoulworks.veinmining.common.veinmining.logic.BlockProcessor;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class VeinMiningLogic {
    private static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};

    public static void veinMine(ServerPlayer playerEntity, BlockPos pos, BlockState sourceState) {
        boolean tooSlow;
        ServerLevel world = playerEntity.m_284548_();
        ItemStack stack = playerEntity.m_21205_();
        Block source = sourceState.m_60734_();
        boolean notCorrect = (Boolean)VeinMiningConfig.SERVER.requireCorrectTool.get() != false && !Services.PLATFORM.canHarvestDrops(playerEntity, sourceState);
        float destroySpeed = stack.m_41691_(sourceState);
        boolean bl = tooSlow = destroySpeed > 0.0f && (double)destroySpeed < (Double)VeinMiningConfig.SERVER.requiredDestroySpeed.get();
        if (notCorrect || tooSlow) {
            return;
        }
        int veiningLevels = EnchantmentHelper.m_44843_((Enchantment)VeinMiningMod.ENCHANTMENT, (ItemStack)stack);
        int maxBlocks = (Integer)VeinMiningConfig.SERVER.maxBlocksBase.get() + (Integer)VeinMiningConfig.SERVER.maxBlocksPerLevel.get() * veiningLevels;
        int maxDistance = 200;
        if (maxBlocks <= 0) {
            return;
        }
        int blocks = 1;
        HashSet visited = Sets.newHashSet((Object[])new BlockPos[]{pos});
        LinkedList<Tuple<BlockPos, Integer>> candidates = new LinkedList<Tuple<BlockPos, Integer>>();
        VeinMiningLogic.addValidNeighbors(candidates, pos, 1);
        while (!candidates.isEmpty() && blocks < maxBlocks) {
            Tuple<BlockPos, Integer> candidate = candidates.poll();
            BlockPos blockPos = (BlockPos)candidate.m_14418_();
            int blockDistance = (Integer)candidate.m_14419_();
            if (VeinMiningLogic.stopVeining(stack)) {
                return;
            }
            BlockState blockState = world.m_8055_(blockPos);
            if (!visited.add(blockPos) || !BlockProcessor.isValidTarget(blockState, source) || !Services.PLATFORM.harvest(playerEntity, blockPos, pos)) continue;
            if (blockDistance < maxDistance) {
                VeinMiningLogic.addValidNeighbors(candidates, blockPos, blockDistance + 1);
            }
            ++blocks;
        }
    }

    private static boolean stopVeining(ItemStack stack) {
        return stack.m_41763_() && (Boolean)VeinMiningConfig.SERVER.limitedByDurability.get() != false && (stack.m_41773_() == stack.m_41776_() || (Boolean)VeinMiningConfig.SERVER.preventToolDestruction.get() != false && stack.m_41773_() == stack.m_41776_() - 1);
    }

    private static void addValidNeighbors(LinkedList<Tuple<BlockPos, Integer>> candidates, BlockPos source, int distance) {
        if (((Boolean)VeinMiningConfig.SERVER.diagonalMining.get()).booleanValue()) {
            BlockPos[] blockPositions;
            BlockPos up = source.m_7494_();
            BlockPos down = source.m_7495_();
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)up, (Object)distance));
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)down, (Object)distance));
            for (BlockPos blockPos : blockPositions = new BlockPos[]{up, down, source}) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_122024_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_122029_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_122012_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_122019_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_122012_().m_122024_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_122012_().m_122029_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_122019_().m_122024_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_122019_().m_122029_(), (Object)distance));
            }
        } else {
            for (Direction direction : CARDINAL_DIRECTIONS) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)source.m_121945_(direction), (Object)distance));
            }
        }
    }
}

