/*
 * Decompiled with CFR 0.152.
 */
package net.redfox.tleveling.leveling;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.redfox.tleveling.TinkersLeveling;
import net.redfox.tleveling.config.TinkersLevelingCommonConfigs;
import net.redfox.tleveling.leveling.Modifier;
import net.redfox.tleveling.leveling.ToolLevel;
import net.redfox.tleveling.sound.ModSounds;
import net.redfox.tleveling.util.MathHandler;
import net.redfox.tleveling.util.ModTags;
import org.apache.commons.lang3.ArrayUtils;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ToolLeveling {
    private final Player player;
    private final ItemStack stack;
    private double currentExp;
    private final int requiredExp;
    private final ToolLevel level;
    private float damageAmount;
    private Entity entity;
    private BlockState state;

    public ToolLeveling(Player IPlayer) {
        this.player = IPlayer;
        this.stack = this.player.m_21205_();
        this.currentExp = this.stack.m_41784_().m_128459_("toolExp");
        this.level = ToolLevel.TOOL_LEVELS[this.stack.m_41784_().m_128451_("toolLevel")];
        this.requiredExp = MathHandler.getRequiredExp(this.level.getLevel());
        this.toolLevelUp(this.levelUpModifier());
    }

    public ToolLeveling(Player IPlayer, BlockState IState) {
        this.player = IPlayer;
        this.stack = this.player.m_21205_();
        if (!this.stack.m_204117_(ModTags.Items.TINKERS_MINING)) {
            this.entity = null;
            this.level = null;
            this.requiredExp = 0;
            return;
        }
        this.state = IState;
        this.currentExp = this.stack.m_41784_().m_128459_("toolExp");
        this.level = ToolLevel.TOOL_LEVELS[this.stack.m_41784_().m_128451_("toolLevel")];
        this.requiredExp = MathHandler.getRequiredExp(this.level.getLevel());
        this.handleMiningEvent();
    }

    public ToolLeveling(Player IPlayer, Entity IEntity) {
        this.player = IPlayer;
        this.stack = this.player.m_21205_();
        if (!this.stack.m_204117_(ModTags.Items.TINKERS_WEAPONS)) {
            this.entity = null;
            this.level = null;
            this.requiredExp = 0;
            return;
        }
        this.entity = IEntity;
        this.currentExp = this.stack.m_41784_().m_128459_("toolExp");
        this.level = ToolLevel.TOOL_LEVELS[this.stack.m_41784_().m_128451_("toolLevel")];
        this.requiredExp = MathHandler.getRequiredExp(this.level.getLevel());
        this.handleAttackEvent();
    }

    public ToolLeveling(Player IPlayer, float IAmount, ItemStack IStack) {
        if (!IStack.m_204117_(ModTags.Items.TINKERS_ARMOR) || IPlayer.m_21224_() || IAmount >= 100000.0f) {
            this.player = null;
            this.stack = null;
            this.level = null;
            this.requiredExp = 0;
            return;
        }
        this.player = IPlayer;
        this.stack = IStack;
        this.damageAmount = IAmount * 3.0f;
        this.currentExp = this.stack.m_41784_().m_128459_("toolExp");
        this.level = ToolLevel.TOOL_LEVELS[this.stack.m_41784_().m_128451_("toolLevel")];
        this.requiredExp = MathHandler.getRequiredExp(this.level.getLevel());
        this.handleSpecificArmorEvent();
    }

    public Modifier levelUpModifier() {
        Modifier modifier;
        if (this.stack.m_204117_(ModTags.Items.TINKERS_MINING)) {
            modifier = this.chooseModifier(Modifier.PICKAXE_MODIFIERS.toArray(new Modifier[0]));
        } else if (this.stack.m_204117_(ModTags.Items.TINKERS_MELEE)) {
            modifier = this.chooseModifier((Modifier[])ArrayUtils.addAll((Object[])Modifier.MELEE_MODIFIERS.toArray(new Modifier[0]), (Object[])Modifier.BONUS_DAMAGE_MODIFIERS.toArray(new Modifier[0])));
        } else if (this.stack.m_204117_(ModTags.Items.TINKERS_RANGED)) {
            modifier = this.stack.m_204117_(ModTags.Items.TINKERS_CROSSBOW) ? this.chooseModifier((Modifier[])ArrayUtils.addAll((Object[])Modifier.RANGED_MODIFIERS.toArray(new Modifier[0]), (Object[])((Modifier[])ArrayUtils.addAll((Object[])Modifier.BONUS_DAMAGE_MODIFIERS.toArray(new Modifier[0]), (Object[])Modifier.CROSSBOW_MODIFIERS.toArray(new Modifier[0]))))) : this.chooseModifier((Modifier[])ArrayUtils.addAll((Object[])Modifier.RANGED_MODIFIERS.toArray(new Modifier[0]), (Object[])((Modifier[])ArrayUtils.addAll((Object[])Modifier.BONUS_DAMAGE_MODIFIERS.toArray(new Modifier[0]), (Object[])new Modifier[0]))));
        } else if (this.stack.m_204117_(ModTags.Items.TINKERS_ARMOR)) {
            modifier = this.stack.m_204117_(ModTags.Items.TINKERS_HELMET) ? this.chooseModifier((Modifier[])ArrayUtils.addAll((Object[])Modifier.ARMOR_MODIFIERS.toArray(new Modifier[0]), (Object[])Modifier.HELMET_MODIFIERS.toArray(new Modifier[0]))) : (this.stack.m_204117_(ModTags.Items.TINKERS_CHESTPLATE) ? this.chooseModifier((Modifier[])ArrayUtils.addAll((Object[])Modifier.ARMOR_MODIFIERS.toArray(new Modifier[0]), (Object[])Modifier.CHESTPLATE_MODIFIERS.toArray(new Modifier[0]))) : (this.stack.m_204117_(ModTags.Items.TINKERS_LEGGINGS) ? this.chooseModifier((Modifier[])ArrayUtils.addAll((Object[])Modifier.ARMOR_MODIFIERS.toArray(new Modifier[0]), (Object[])Modifier.LEGGINGS_MODIFIERS.toArray(new Modifier[0]))) : (this.stack.m_204117_(ModTags.Items.TINKERS_BOOTS) ? this.chooseModifier((Modifier[])ArrayUtils.addAll((Object[])Modifier.ARMOR_MODIFIERS.toArray(new Modifier[0]), (Object[])Modifier.BOOTS_MODIFIERS.toArray(new Modifier[0]))) : this.chooseModifier(new Modifier[0]))));
        } else {
            modifier = this.chooseModifier(new Modifier[0]);
            TinkersLeveling.warnLog("A tool isn't in any tag! " + this.stack.m_41611_().getString());
        }
        if (modifier == null) {
            return null;
        }
        this.upgradeModifier(this.stack, modifier);
        return modifier;
    }

    public void setBonusModifiers(ItemStack stack, int input) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        tool.getPersistentData().setSlots(SlotType.UPGRADE, input);
    }

    public int getBonusModifiers(ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        return tool.getPersistentData().getSlots(SlotType.UPGRADE);
    }

    private Modifier chooseModifier(Modifier[] specificModifiers) {
        Modifier[] modifiers = (Modifier[])ArrayUtils.addAll((Object[])specificModifiers, (Object[])Modifier.GLOBAL_MODIFIERS.toArray(new Modifier[0]));
        Random random = new Random();
        if (modifiers.length == 0) {
            return null;
        }
        return modifiers[random.nextInt(modifiers.length)];
    }

    private void upgradeModifier(ItemStack stack, Modifier modifier) {
        ListTag ticUpgrades;
        CompoundTag nbt = stack.m_41784_();
        ListTag listTag = ticUpgrades = nbt.m_128425_("tic_upgrades", 9) ? nbt.m_128437_("tic_upgrades", 10) : new ListTag();
        if (this.hasPreviousModifier(stack, modifier)) {
            for (int i = 0; i < ticUpgrades.size(); ++i) {
                CompoundTag entry = ticUpgrades.m_128728_(i);
                if (!entry.m_128461_("name").equals("tconstruct:" + modifier.getName())) continue;
                int level = entry.m_128451_("level");
                if (level == modifier.getMax()) {
                    this.levelUpModifier();
                    continue;
                }
                entry.m_128405_("level", level + 1);
                ticUpgrades.set(i, (Tag)entry);
                nbt.m_128365_("tic_upgrades", (Tag)ticUpgrades);
                stack.m_41751_(nbt);
            }
        } else {
            CompoundTag modifierUpgrade = this.getModifierUpgrade(modifier, 1);
            ticUpgrades.add((Object)modifierUpgrade);
            nbt.m_128365_("tic_upgrades", (Tag)ticUpgrades);
            stack.m_41751_(nbt);
        }
    }

    private boolean hasPreviousModifier(ItemStack stack, Modifier modifier) {
        boolean contains = false;
        for (int i = 1; i <= modifier.getMax() && !(contains = stack.m_41784_().m_128437_("tic_upgrades", 10).contains((Object)this.getModifierUpgrade(modifier, i))); ++i) {
        }
        return contains;
    }

    private CompoundTag getModifierUpgrade(Modifier modifier, int level) {
        CompoundTag modifierUpgrade = new CompoundTag();
        modifierUpgrade.m_128359_("name", "tconstruct:" + modifier.getName());
        modifierUpgrade.m_128405_("level", level);
        return modifierUpgrade;
    }

    public void toolLevelUp(Modifier modifier) {
        this.stack.m_41784_().m_128347_("toolExp", this.currentExp - (double)this.requiredExp);
        this.stack.m_41784_().m_128405_("toolLevel", this.level.getLevel() + 1);
        int levelGap = (Integer)TinkersLevelingCommonConfigs.LEVEL_BONUS_MODIFIER.get();
        if (levelGap > 0 && levelGap <= 11) {
            if ((this.level.getLevel() + levelGap) % levelGap == 0) {
                this.setBonusModifiers(this.stack, this.getBonusModifiers(this.stack) + 1);
                this.player.m_213846_(this.level.getMessage(this.stack.m_41611_(), true));
            } else {
                this.player.m_213846_(this.level.getMessage(this.stack.m_41611_(), false));
            }
        }
        this.player.m_213846_(modifier.getMessage());
        this.player.m_9236_().m_6263_(null, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), (SoundEvent)ModSounds.LEVEL_CHIME.get(), SoundSource.MASTER, 1.0f, 1.0f);
        if (this.currentExp - (double)this.requiredExp > (double)MathHandler.getRequiredExp(this.level.getLevel() + 1)) {
            new ToolLeveling(this.player);
        }
    }

    public void handleMiningEvent() {
        this.currentExp = this.getExpFromBlockState(this.state) + this.currentExp;
        this.stack.m_41784_().m_128347_("toolExp", this.currentExp);
        if (this.currentExp >= (double)this.requiredExp && !this.level.isMaxLevel()) {
            new ToolLeveling(this.player);
        }
    }

    public void handleAttackEvent() {
        this.currentExp = this.getExpFromEntity(this.entity) + this.currentExp;
        this.stack.m_41784_().m_128347_("toolExp", this.currentExp);
        if (this.currentExp >= (double)this.requiredExp && !this.level.isMaxLevel()) {
            new ToolLeveling(this.player);
        }
    }

    private void handleSpecificArmorEvent() {
        this.currentExp = this.getRandomBonus(this.damageAmount) + this.currentExp;
        this.stack.m_41784_().m_128347_("toolExp", this.currentExp);
        if (this.currentExp >= (double)this.requiredExp && !this.level.isMaxLevel()) {
            this.toolLevelUp(this.levelUpModifier());
        }
    }

    public double getExpFromBlockState(BlockState state) {
        double exp;
        if (state.m_204336_(ModTags.Blocks.EXP_PICKAXE_NOR_FIVE)) {
            exp = 0.5;
        } else if (state.m_204336_(ModTags.Blocks.EXP_PICKAXE_TWO)) {
            exp = 2.0;
        } else if (state.m_204336_(ModTags.Blocks.EXP_PICKAXE_FIVE)) {
            exp = 5.0;
        } else if (state.m_204336_(ModTags.Blocks.EXP_PICKAXE_ADMIN)) {
            if (((Boolean)TinkersLevelingCommonConfigs.ADMIN_MINING_EXP.get()).booleanValue()) {
                exp = 100000.0;
                TinkersLeveling.warnLog("Admin only mining exp was granted. Was this intentional?");
            } else {
                exp = 1.0;
            }
        } else {
            exp = state.m_204336_(ModTags.Blocks.EXCLUDED_BLOCKS) ? 0.0 : 1.0;
        }
        exp = this.getRandomBonus(exp);
        return exp * 2.0 * (Double)TinkersLevelingCommonConfigs.PICKAXE_EXP_MULTIPLIER.get();
    }

    public double getExpFromEntity(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0;
        }
        LivingEntity e = (LivingEntity)entity;
        float maxHealth = e.m_21233_();
        return this.getRandomBonus(maxHealth) * (Double)TinkersLevelingCommonConfigs.KILL_EXP_MULTIPLIER.get();
    }

    public double getRandomBonus(double amount) {
        if (amount == 0.0) {
            return 0.0;
        }
        Random random = new Random();
        return amount + (double)random.nextInt(Math.abs(MathHandler.round(amount * 100.0))) / 100.0;
    }
}

