/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.untitledduckmod.common.config.UntitledConfig;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import net.untitledduckmod.common.entity.ai.goal.common.EatGoal;
import net.untitledduckmod.common.entity.ai.goal.common.SwimGoal;
import net.untitledduckmod.common.entity.ai.goal.common.WFollowOwnerGoal;
import net.untitledduckmod.common.entity.ai.goal.common.WFollowParentGoal;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModItems;
import net.untitledduckmod.common.init.ModSoundEvents;
import net.untitledduckmod.common.init.ModTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GooseEntity
extends WaterfowlEntity
implements NeutralMob,
AnimationController.ParticleKeyframeHandler<GooseEntity> {
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.m_135353_(GooseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ANGER_TIME_RANGE = UniformInt.m_146622_((int)20, (int)39);
    private UUID targetUuid;
    public static final byte ANIMATION_BITE = 2;
    public static final int ANIMATION_BITE_LEN = 22;
    public static final byte ANIMATION_INTIMIDATE = 6;
    private static final RawAnimation INTIMIDATE_ANIM = RawAnimation.begin().thenPlay("intimidate");
    private static final RawAnimation HONK_ANIM = RawAnimation.begin().thenPlay("honk");
    private static final RawAnimation BITE_ANIM = RawAnimation.begin().thenPlay("bite");
    private static final RawAnimation CHARGE_ANIM = RawAnimation.begin().thenPlay("charge");
    public static final Ingredient FOOD = Ingredient.m_204132_(ModTags.ItemTags.GOOSE_FOOD);
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.m_204132_(ModTags.ItemTags.GOOSE_BREEDING_FOOD);
    private static final Ingredient TAMING_INGREDIENT = Ingredient.m_204132_(ModTags.ItemTags.GOOSE_TAMING_FOOD);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean wasSongPlaying = false;
    private int animationTimer = 0;

    public GooseEntity(EntityType<? extends WaterfowlEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21553_(true);
    }

    public static boolean checkGooseSpawnRules(EntityType<GooseEntity> goose, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        boolean isValidSurface;
        BlockState downState = world.m_8055_(pos.m_7495_());
        boolean bl = isValidSurface = downState.m_204336_(ModTags.BlockTags.GEESE_SPAWNABLE_ON) || downState.m_60819_().m_205070_(FluidTags.f_13131_) || downState.m_60713_(Blocks.f_50126_) || downState.m_60713_(Blocks.f_50449_);
        boolean hasEnoughSpace = downState.m_60713_(Blocks.f_50126_) || downState.m_60713_(Blocks.f_50449_) ? world.m_8055_(pos).m_60795_() && world.m_8055_(pos.m_7494_()).m_60795_() : world.m_8055_(pos).m_60795_();
        return isValidSurface && hasEnoughSpace;
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_(2.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_TIME, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_147285_(this.m_9236_(), tag);
    }

    public void m_6818_(BlockPos songPosition, boolean playing) {
        if (playing && !this.wasSongPlaying) {
            this.setAnimation((byte)3);
            this.wasSongPlaying = true;
        } else if (!playing && this.wasSongPlaying) {
            this.setAnimation((byte)0);
            this.wasSongPlaying = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte status) {
        if (status == 100) {
            SimpleParticleType particleEffect = ParticleTypes.f_123748_;
            for (int i = 0; i < 7; ++i) {
                double d = this.f_19796_.m_188583_() * 0.02;
                double e = this.f_19796_.m_188583_() * 0.02;
                double f = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)particleEffect, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
            }
        }
        super.m_7822_(status);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SwimGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new GooseEscapeDangerGoal(this, 1.7));
        this.f_21345_.m_25352_(2, (Goal)new IntimidateMobsGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new EatGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new StealItemGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new PickupFoodGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new GooseMeleeAttackGoal(this, 1.5, true));
        this.f_21345_.m_25352_(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, BREEDING_INGREDIENT, false));
        this.f_21345_.m_25352_(8, (Goal)new WFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(9, (Goal)new WFollowOwnerGoal(this, 1.6, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(9, (Goal)new CleanGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new GooseRevengeGoal(this).m_26044_(new Class[0]));
    }

    public boolean m_6898_(ItemStack stack) {
        return !this.isAngry() && BREEDING_INGREDIENT.test(stack);
    }

    public void m_238392_(EquipmentSlot slot, ItemStack oldStack, ItemStack newStack) {
        ItemEntity ie;
        UUID thrower;
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity holder = newStack.m_41609_();
        if (holder != null && this.isAngry() && holder instanceof ItemEntity && (thrower = this.getThrower(ie = (ItemEntity)holder)) != null) {
            this.m_21662_();
        }
        super.m_238392_(slot, oldStack, newStack);
    }

    private UUID getThrower(ItemEntity ie) {
        CompoundTag nbt = new CompoundTag();
        ie.m_7380_(nbt);
        if (nbt.m_128403_("Thrower")) {
            return nbt.m_128342_("Thrower");
        }
        return null;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.animationTimer > 0) {
            --this.animationTimer;
            if (this.animationTimer == 0) {
                this.setAnimation((byte)0);
            }
        }
    }

    @Override
    protected void handlePanicAnimation() {
        if (!this.panicked && (this.m_21223_() < this.m_21233_() / 2.0f || this.m_6162_()) && (this.m_21188_() != null || this.m_6060_())) {
            this.setAnimation((byte)4);
            this.panicked = true;
        } else if (this.panicked && this.m_21188_() == null && !this.m_6060_()) {
            this.setAnimation((byte)0);
            this.panicked = false;
        }
    }

    @Override
    protected boolean tryTaming(Player player, ItemStack stack) {
        if (this.isAngry()) {
            if (FOOD.test(stack)) {
                ItemStack newStack = stack.m_41777_();
                newStack.m_41764_(1);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (!this.m_255207_(newStack).m_41619_()) {
                    this.m_21662_();
                }
            }
            return false;
        }
        return super.tryTaming(player, stack);
    }

    @Override
    protected boolean isTamableItem(ItemStack stack) {
        return TAMING_INGREDIENT.test(stack);
    }

    @Override
    protected boolean isTamable(Player player, ItemStack stack) {
        return super.isTamable(player, stack) && !this.m_21660_();
    }

    public boolean isAngry() {
        return this.m_5448_() != null;
    }

    public void m_21662_() {
        this.m_6703_(null);
        this.m_6925_(null);
        this.m_6710_(null);
        this.m_7870_(0);
        this.m_9236_().m_7605_((Entity)this, (byte)100);
    }

    public ItemStack m_255207_(ItemStack equipment) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        ItemStack itemStack = this.m_21205_();
        if (FOOD.test(equipment) || this.m_7252_(equipment)) {
            ItemEntity itemEntity;
            if (!itemStack.m_41619_() && (itemEntity = this.m_19983_(itemStack)) != null) {
                itemEntity.m_32010_(40);
            }
            this.m_21468_(equipmentSlot, equipment);
            return equipment;
        }
        return ItemStack.f_41583_;
    }

    private boolean isWeapon(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_271388_) || stack.m_204117_(ItemTags.f_271207_);
    }

    protected void m_7581_(ItemEntity item) {
        if (this.getThrower(item) == this.m_20148_()) {
            return;
        }
        if (this.m_21824_()) {
            Player player;
            Entity entity = item.m_19749_();
            if (entity instanceof Player && this.m_21830_((LivingEntity)(player = (Player)entity))) {
                super.m_7581_(item);
            }
            return;
        }
        super.m_7581_(item);
    }

    public boolean m_7252_(ItemStack stack) {
        ItemStack mainHandStack = this.m_21205_();
        if (this.isWeapon(stack)) {
            return this.m_21824_() && this.m_269323_() != null && this.m_21223_() == this.m_21233_();
        }
        if (!FOOD.test(mainHandStack) && FOOD.test(stack)) {
            return true;
        }
        if (mainHandStack.m_41619_()) {
            return !stack.m_150930_(ModItems.GOOSE_EGG.get());
        }
        return false;
    }

    public boolean m_21531_() {
        if (this.m_6162_()) {
            return false;
        }
        return super.m_21531_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        GooseEntity gooseEntity = (GooseEntity)ModEntityTypes.getGoose().m_20615_((Level)world);
        if (gooseEntity != null && entity instanceof GooseEntity) {
            GooseEntity goose = (GooseEntity)entity;
            if (this.f_19796_.m_188499_()) {
                gooseEntity.setVariant(this.getVariant());
            } else {
                gooseEntity.setVariant(goose.getVariant());
            }
            if (this.m_21824_()) {
                gooseEntity.m_21816_(this.m_21805_());
                gooseEntity.m_7105_(true);
            }
        }
        return gooseEntity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate);
        controller.setParticleKeyframeHandler((AnimationController.ParticleKeyframeHandler)this);
        controllerRegistrar.add(new AnimationController[]{controller});
    }

    @Override
    protected SoundEvent getLayEggSound() {
        return ModSoundEvents.GOOSE_LAY_EGG.get();
    }

    @Override
    public Item getEggItem() {
        return ModItems.GOOSE_EGG.get();
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.m_20069_();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            controller.setAnimation(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 2: {
                controller.setAnimation(BITE_ANIM);
                this.animationTimer = 22;
                break;
            }
            case 6: {
                controller.setAnimation(INTIMIDATE_ANIM);
                break;
            }
            case 5: {
                controller.setAnimation(EAT_ANIM);
                break;
            }
            case 1: {
                controller.setAnimation(inWater ? SWIM_ANIM : CLEAN_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(HONK_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                if (this.m_5912_()) {
                    controller.setAnimation(CHARGE_ANIM);
                    return PlayState.CONTINUE;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8032_() {
        if (this.m_6162_()) {
            this.m_5496_(ModSoundEvents.GOSLING_AMBIENT.get(), 0.3f, this.m_6100_());
            return;
        }
        if (this.m_21660_()) {
            this.m_5496_(ModSoundEvents.GOOSE_HONK.get(), 0.6f, this.m_6100_());
        }
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack stack, float yOffset) {
        ItemEntity droppedStack = super.m_5552_(stack, yOffset);
        if (droppedStack == null) {
            return null;
        }
        droppedStack.m_32052_(this.m_20148_());
        return droppedStack;
    }

    protected void m_6677_(DamageSource source) {
        if (this.m_6162_()) {
            this.m_5496_(ModSoundEvents.GOSLING_HURT.get(), 0.3f, this.m_6100_() + 0.25f);
            return;
        }
        this.m_5496_(ModSoundEvents.GOOSE_HONK.get(), 0.7f, this.m_6100_());
    }

    @Nullable
    protected SoundEvent m_5592_() {
        if (this.m_6162_()) {
            return ModSoundEvents.GOSLING_DEATH.get();
        }
        return ModSoundEvents.GOOSE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(ModSoundEvents.DUCK_STEP.get(), 0.15f, 1.0f);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(ANGER_TIME);
    }

    public void m_7870_(int ticks) {
        this.f_19804_.m_135381_(ANGER_TIME, (Object)ticks);
    }

    @Nullable
    public UUID m_6120_() {
        return this.targetUuid;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    public void handle(ParticleKeyframeEvent particleKeyframeEvent) {
        ItemStack stack = this.m_21205_();
        if (stack == ItemStack.f_41583_) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Vec3 vel = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vel = vel.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vel = vel.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            Vec3 rotationVec = Vec3.m_82498_((float)0.0f, (float)this.f_20883_);
            Vec3 pos = new Vec3(this.m_20185_() + rotationVec.f_82479_ / 2.0, this.m_20188_() - 0.2, this.m_20189_() + rotationVec.f_82481_ / 2.0);
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_, vel.f_82480_ + 0.05, vel.f_82481_);
        }
    }

    public boolean wantsToPickupItem() {
        return !this.m_21827_() && this.m_21188_() == null && this.m_5448_() == null;
    }

    @Override
    public boolean isHungry() {
        return this.isAngry() || super.isHungry();
    }

    @Override
    public boolean tamedFollowOwner() {
        return !UntitledConfig.gooseTamedNotFollow();
    }

    static class GooseEscapeDangerGoal
    extends PanicGoal {
        private final GooseEntity goose;

        public GooseEscapeDangerGoal(GooseEntity goose, double speed) {
            super((PathfinderMob)goose, speed);
            this.goose = goose;
        }

        public boolean m_8036_() {
            return (this.goose.m_21223_() < this.goose.m_21233_() / 2.0f || this.goose.m_6162_()) && super.m_8036_();
        }
    }

    static class IntimidateMobsGoal
    extends Goal {
        private static final int STARTING_DELAY = 10;
        private static final int ANIMATION_LENGTH = 25;
        private static final double INTIMIDATE_DISTANCE = 12.0;
        private final GooseEntity goose;
        private int animationTime;
        private int delayTime;
        private int cooldown;
        protected Entity targetEntity;
        private Vec3 originalLocation;

        public IntimidateMobsGoal(GooseEntity goose) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.goose = goose;
        }

        public boolean m_8036_() {
            if (this.cooldown-- > 0) {
                return false;
            }
            if (this.goose.f_19797_ % 5 == 0) {
                this.targetEntity = this.goose.m_9236_().m_45963_(AbstractIllager.class, TargetingConditions.m_148352_(), (LivingEntity)this.goose, this.goose.m_20185_(), this.goose.m_20186_(), this.goose.m_20189_(), this.goose.m_20191_().m_82377_(12.0, 3.0, 12.0));
                return this.targetEntity != null;
            }
            return false;
        }

        public void m_8056_() {
            this.goose.m_21573_().m_26573_();
            this.animationTime = 25;
            this.delayTime = 10;
            this.originalLocation = this.goose.m_20182_();
            this.goose.m_21573_().m_5624_(this.targetEntity, 1.2);
        }

        public void m_8041_() {
            this.goose.setAnimation((byte)0);
            this.goose.m_21573_().m_26519_(this.originalLocation.f_82479_, this.originalLocation.f_82480_, this.originalLocation.f_82481_, 1.2);
            this.cooldown = 20;
            this.targetEntity = null;
        }

        public boolean m_8045_() {
            return this.targetEntity.m_6084_() && this.goose.m_20238_(this.originalLocation) <= 144.0 && this.animationTime >= 0;
        }

        public void m_8037_() {
            this.goose.m_21563_().m_24946_(this.targetEntity.m_20185_(), this.targetEntity.m_20188_(), this.targetEntity.m_20189_());
            if (this.delayTime > 0) {
                --this.delayTime;
                if (this.delayTime == 0) {
                    this.goose.m_21573_().m_26573_();
                    this.goose.setAnimation((byte)6);
                    this.goose.m_5496_(ModSoundEvents.GOOSE_HONK.get(), 1.0f, 1.0f);
                }
                return;
            }
            --this.animationTime;
        }
    }

    static class StealItemGoal
    extends Goal {
        private static final double SPEED = 1.3;
        private final GooseEntity goose;
        Player targetPlayer;
        int nextStealTime;
        private ItemStack playerHandStack;

        public StealItemGoal(GooseEntity goose) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.goose = goose;
            this.nextStealTime = goose.f_19797_ + goose.m_217043_().m_188503_(1200) + 1200;
        }

        public boolean m_8036_() {
            if (this.goose.m_6162_() || this.goose.m_21824_() || !this.goose.m_21205_().m_41619_()) {
                return false;
            }
            if (this.goose.f_19797_ <= this.nextStealTime) {
                return false;
            }
            if (this.goose.m_217043_().m_188503_(10) != 0) {
                return false;
            }
            this.targetPlayer = this.goose.m_9236_().m_45924_(this.goose.m_20185_(), this.goose.m_20186_(), this.goose.m_20189_(), 10.0, true);
            if (this.targetPlayer == null) {
                this.nextStealTime = this.goose.f_19797_ + this.goose.m_217043_().m_188503_(200) + 200;
                return false;
            }
            this.playerHandStack = this.targetPlayer.m_21205_();
            return FOOD.test(this.playerHandStack);
        }

        public boolean m_8045_() {
            if (this.targetPlayer == null) {
                return false;
            }
            this.playerHandStack = this.targetPlayer.m_21205_();
            return FOOD.test(this.playerHandStack);
        }

        public void m_8056_() {
            this.goose.m_21573_().m_5624_((Entity)this.targetPlayer, 1.3);
        }

        public void m_8041_() {
            this.nextStealTime = this.goose.f_19797_ + this.goose.m_217043_().m_188503_(1200) + 1200;
            this.targetPlayer = null;
        }

        public void m_8037_() {
            if (this.goose.m_20270_((Entity)this.targetPlayer) <= 2.0f) {
                ItemStack stolenItemStack = this.playerHandStack.m_41777_();
                stolenItemStack.m_41764_(1);
                if (!this.goose.m_255207_(stolenItemStack).m_41619_()) {
                    this.playerHandStack.m_41774_(1);
                }
                this.goose.m_21008_(InteractionHand.MAIN_HAND, stolenItemStack);
                this.m_8041_();
            } else {
                this.goose.m_21573_().m_5624_((Entity)this.targetPlayer, 1.3);
            }
        }
    }

    static class PickupFoodGoal
    extends Goal {
        public static final double SPEED = 1.3;
        private final GooseEntity goose;
        private static final Predicate<ItemEntity> PICKABLE_DROP_FILTER = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_() && FOOD.test(itemEntity.m_32055_());

        public PickupFoodGoal(GooseEntity goose) {
            this.goose = goose;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.goose.m_6162_() || !this.goose.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (!this.goose.wantsToPickupItem()) {
                return false;
            }
            if (this.goose.m_217043_().m_188503_(10) != 0) {
                return false;
            }
            List list = this.goose.m_9236_().m_6443_(ItemEntity.class, this.goose.m_20191_().m_82377_(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            return !list.isEmpty() && this.goose.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
        }

        public void m_8037_() {
            ItemStack itemStack = this.goose.m_6844_(EquipmentSlot.MAINHAND);
            if (itemStack.m_41619_()) {
                this.m_8056_();
            }
        }

        public void m_8056_() {
            List list = this.goose.m_9236_().m_6443_(ItemEntity.class, this.goose.m_20191_().m_82377_(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            if (!list.isEmpty()) {
                this.goose.m_21573_().m_5624_((Entity)list.get(0), 1.3);
            }
        }
    }

    static class GooseMeleeAttackGoal
    extends MeleeAttackGoal {
        private final GooseEntity goose;
        private static final int ANIMATION_LEN = 22;
        private static final int ANIMATION_ATTACK = 5;
        private int animationTimer = 0;

        public GooseMeleeAttackGoal(GooseEntity gooseEntity, double speed, boolean pauseWhenIdle) {
            super((PathfinderMob)gooseEntity, speed, pauseWhenIdle);
            this.goose = gooseEntity;
        }

        public boolean m_8036_() {
            return !this.goose.m_6162_() && !this.goose.m_20069_() && super.m_8036_();
        }

        protected void m_6739_(LivingEntity target, double squaredDistance) {
            double d = this.m_6639_(target);
            if (squaredDistance <= d && this.animationTimer <= 0) {
                this.goose.setAnimation((byte)2);
                this.animationTimer = 22;
                this.goose.m_5496_(ModSoundEvents.GOOSE_HONK.get(), 0.8f, 1.2f);
            }
            if (this.animationTimer > 0) {
                --this.animationTimer;
                if (this.animationTimer == 5) {
                    this.f_25540_.m_7327_((Entity)target);
                }
                if (this.animationTimer == 0) {
                    this.goose.setAnimation((byte)0);
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.goose.setAnimation((byte)0);
            this.animationTimer = 0;
        }
    }

    static class CleanGoal
    extends Goal {
        private static final int ANIMATION_LENGTH = 32;
        private final GooseEntity goose;
        private int cleanTime;
        private int nextCleanTime;

        public CleanGoal(GooseEntity goose) {
            this.goose = goose;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nextCleanTime = goose.f_19797_ + (200 + goose.m_217043_().m_188503_(10) * 20);
        }

        public boolean m_8036_() {
            if (this.nextCleanTime > this.goose.f_19797_ || this.goose.m_21216_() >= 100 || this.goose.getAnimation() != 0) {
                return false;
            }
            return this.goose.m_217043_().m_188503_(40) == 0;
        }

        public void m_8056_() {
            this.cleanTime = 32;
            this.goose.setAnimation((byte)1);
            this.nextCleanTime = this.goose.f_19797_ + (200 + this.goose.m_217043_().m_188503_(10) * 20);
        }

        public void m_8041_() {
            this.goose.setAnimation((byte)0);
        }

        public boolean m_8045_() {
            return this.cleanTime >= 0;
        }

        public void m_8037_() {
            --this.cleanTime;
        }
    }

    static class GooseRevengeGoal
    extends HurtByTargetGoal {
        private final GooseEntity goose;

        public GooseRevengeGoal(GooseEntity goose) {
            super((PathfinderMob)goose, new Class[0]);
            this.goose = goose;
        }

        public boolean m_8045_() {
            return this.goose.m_5448_() != null && super.m_8045_();
        }
    }
}

