/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.compat._base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammerlib.compat.base.Ability;
import org.zeith.hammerlib.compat.base.CompatList;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.solarflux.compat._base.SolarFluxCompat;
import org.zeith.solarflux.panels.SolarPanel;

public class SFCompatList
extends CompatList<SolarFluxCompat> {
    private static final Ability<PanelsListWrapper> PANELS_LIST_WRAPPER_ABILITY = new Ability(PanelsListWrapper.class);

    public SFCompatList(List<? extends SolarFluxCompat> lst) {
        super(lst);
    }

    public void setupSolarPanels() {
        Supplier<SolarPanel.Builder> factory = SolarPanel::builder;
        for (SolarFluxCompat compat : this.getActive()) {
            List<SolarPanel> panels = compat.getAbility(PANELS_LIST_WRAPPER_ABILITY).orElseThrow().panels();
            compat.registerSolarPanels(factory, builder -> {
                SolarPanel sp = builder.buildAndRegister().setCompatMod(compat.getCompatModID());
                panels.add(sp);
                return sp;
            });
        }
    }

    public void indexRecipes(Consumer<ResourceLocation[]> recipes) {
        ArrayList all = new ArrayList();
        for (SolarFluxCompat compat : this.getActive()) {
            compat.indexRecipes(all::add);
        }
        recipes.accept((ResourceLocation[])all.toArray(ResourceLocation[]::new));
    }

    public void registerRecipes(RegisterRecipesEvent e) {
        for (SolarFluxCompat compat : this.getActive()) {
            compat.registerRecipes(e);
        }
    }

    record PanelsListWrapper(List<SolarPanel> panels) {
    }
}

