/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items.upgrades;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.init.ItemsSF;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.items.upgrades.ItemTraversalUpgrade;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;
import org.zeith.solarflux.util.BlockPosFace;

public class ItemBlockChargingUpgrade
extends UpgradeItem {
    private static final Direction[] DIRECTIONS = Direction.values();

    public ItemBlockChargingUpgrade() {
        super(1);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.m_5812_(stack)) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128425_("Dim", 8)) {
                tooltip.add((Component)Component.m_237113_((String)("Dimension: " + nbt.m_128461_("Dim"))));
            }
            tooltip.add((Component)Component.m_237113_((String)("Facing: " + DIRECTIONS[nbt.m_128445_("Face")])));
            BlockPos pos = BlockPos.m_122022_((long)nbt.m_128454_("Pos"));
            tooltip.add((Component)Component.m_237113_((String)("X: " + pos.m_123341_() + ", Y: " + pos.m_123342_() + ", Z: " + pos.m_123343_())));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity tile = context.m_43725_().m_7702_(context.m_8083_());
        if (tile instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)tile;
            if (context.m_43719_() == Direction.UP) {
                ItemStack held = context.m_43722_();
                CompoundTag nbt = held.m_41783_();
                if (nbt == null) {
                    nbt = new CompoundTag();
                    held.m_41751_(nbt);
                }
                nbt.m_128359_("Dim", context.m_43725_().m_46472_().m_135782_().toString());
                nbt.m_128356_("Pos", context.m_8083_().m_121878_());
                nbt.m_128344_("Face", (byte)context.m_43719_().ordinal());
                context.m_43725_().m_5594_(null, context.m_8083_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.25f, 1.8f);
                return InteractionResult.SUCCESS;
            }
        }
        return tile != null ? tile.getCapability(ForgeCapabilities.ENERGY, context.m_43719_()).filter(IEnergyStorage::canReceive).map(estorage -> {
            ItemStack held = context.m_43722_();
            CompoundTag nbt = held.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
                held.m_41751_(nbt);
            }
            nbt.m_128359_("Dim", context.m_43725_().m_46472_().m_135782_().toString());
            nbt.m_128356_("Pos", context.m_8083_().m_121878_());
            nbt.m_128344_("Face", (byte)context.m_43719_().ordinal());
            context.m_43725_().m_5594_(null, context.m_8083_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.25f, 1.8f);
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.FAIL) : InteractionResult.FAIL;
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("Pos", 4) && stack.m_41783_().m_128425_("Face", 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canInstall(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        BlockPos blockPos;
        if (!this.m_5812_(stack)) return false;
        if (stack.m_41783_().m_128425_("Dim", 8)) {
            if (!tile.level().m_46472_().m_135782_().toString().equals(stack.m_41783_().m_128461_("Dim"))) return false;
        }
        BlockPos pos = BlockPos.m_122022_((long)stack.m_41783_().m_128454_("Pos"));
        if (!(tile.pos().m_123331_((Vec3i)blockPos) <= (double)SolarPanelsSF.BLOCK_CHARGING_UPGRADE_RANGE)) return false;
        BlockEntity t = tile.level().m_7702_(pos);
        if (t == null) return false;
        if (t instanceof AbstractFurnaceBlockEntity && DIRECTIONS[stack.m_41783_().m_128445_("Face")] == Direction.UP) {
            if (tile.getUpgrades(ItemsSF.FURNACE_UPGRADE) > 0) return true;
        }
        if (!t.getCapability(ForgeCapabilities.ENERGY, DIRECTIONS[stack.m_41783_().m_128445_("Face")]).isPresent()) return false;
        return true;
    }

    @Override
    public boolean canStayInPanel(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return this.canInstall(tile, stack, upgradeInv);
    }

    @Override
    public void update(ISolarPanelTile tile, ItemStack stack, int amount) {
        CompoundTag nbt = stack.m_41783_();
        if (tile.level().m_46468_() % 20L == 0L) {
            double d;
            BlockPos pos = BlockPos.m_122022_((long)nbt.m_128454_("Pos"));
            double d2 = tile.pos().m_123331_((Vec3i)pos);
            if (d <= (double)SolarPanelsSF.BLOCK_CHARGING_UPGRADE_RANGE) {
                d2 /= (double)SolarPanelsSF.BLOCK_CHARGING_UPGRADE_RANGE;
                tile.traversal().clear();
                if (tile.getUpgrades(ItemsSF.TRAVERSAL_UPGRADE) > 0) {
                    ItemTraversalUpgrade.cache.clear();
                    ItemTraversalUpgrade.cache.add(pos);
                    ItemTraversalUpgrade.findMachines(tile, ItemTraversalUpgrade.cache, tile.traversal());
                }
                tile.traversal().add(new BlockPosFace(pos, Direction.values()[nbt.m_128445_("Face")], (float)(1.0 - d2)));
            }
        }
    }

    @Override
    protected Object[] hoverTextData(ItemStack stack) {
        return new Object[]{Math.round((float)Math.sqrt(SolarPanelsSF.BLOCK_CHARGING_UPGRADE_RANGE))};
    }
}

