/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.WithHooks;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolSlotsModule;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class ToolDefinitionDataBuilder {
    private final StatsNBT.Builder bonuses = StatsNBT.builder();
    private final ImmutableList.Builder<WithHooks<ToolModule>> modules = ImmutableList.builder();

    public <T> ToolDefinitionDataBuilder stat(IToolStat<T> stat, T value) {
        this.bonuses.set(stat, value);
        return this;
    }

    public ToolDefinitionDataBuilder smallToolStartingSlots() {
        this.module((ToolModule)new ToolSlotsModule((Map<SlotType, Integer>)ImmutableMap.of((Object)SlotType.UPGRADE, (Object)3, (Object)SlotType.ABILITY, (Object)1)));
        return this;
    }

    public ToolDefinitionDataBuilder largeToolStartingSlots() {
        this.module((ToolModule)new ToolSlotsModule((Map<SlotType, Integer>)ImmutableMap.of((Object)SlotType.UPGRADE, (Object)2, (Object)SlotType.ABILITY, (Object)1)));
        return this;
    }

    @SafeVarargs
    public final <T extends ToolModule> ToolDefinitionDataBuilder module(T module, ModuleHook<? super T> ... hooks) {
        this.modules.add(new WithHooks<T>(module, List.of(hooks)));
        return this;
    }

    public ToolDefinitionDataBuilder module(ToolModule module) {
        this.modules.add(new WithHooks<ToolModule>(module, List.of()));
        return this;
    }

    public ToolDefinitionDataBuilder module(ToolModule ... modules) {
        for (ToolModule module : modules) {
            this.module(module);
        }
        return this;
    }

    public ToolDefinitionData build() {
        return new ToolDefinitionData((List<WithHooks<ToolModule>>)this.modules.build(), ErrorFactory.RUNTIME);
    }

    private ToolDefinitionDataBuilder() {
    }

    public static ToolDefinitionDataBuilder builder() {
        return new ToolDefinitionDataBuilder();
    }
}

