/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class LazyToolStack {
    @Nullable
    private ItemStack stack;
    @Nullable
    private ToolStack tool;
    private final int size;

    public static LazyToolStack from(ItemStack stack) {
        return new LazyToolStack(stack, null, stack.m_41613_());
    }

    public static LazyToolStack from(ToolStack tool, int count) {
        return new LazyToolStack(null, tool, count);
    }

    public static LazyToolStack copyFrom(ToolStack tool, int count, ItemStack original) {
        return new LazyToolStack(tool.copyStack(original, count), tool, count);
    }

    public static LazyToolStack copyFrom(ToolStack tool, ItemStack original) {
        return new LazyToolStack(tool.copyStack(original), tool, original.m_41613_());
    }

    public static RecipeResult<LazyToolStack> success(ItemStack stack) {
        return RecipeResult.success(LazyToolStack.from(stack));
    }

    public static RecipeResult<LazyToolStack> success(ToolStack tool, int count) {
        return RecipeResult.success(LazyToolStack.from(tool, count));
    }

    public static RecipeResult<LazyToolStack> successCopy(ToolStack tool, int count, ItemStack original) {
        return RecipeResult.success(LazyToolStack.copyFrom(tool, count, original));
    }

    public static RecipeResult<LazyToolStack> successCopy(ToolStack tool, ItemStack original) {
        return RecipeResult.success(LazyToolStack.copyFrom(tool, original));
    }

    public Item getItem() {
        if (this.stack != null) {
            return this.stack.m_41720_();
        }
        if (this.tool != null) {
            return this.tool.getItem();
        }
        return Items.f_41852_;
    }

    public boolean hasTag(TagKey<Item> tag) {
        if (this.stack != null) {
            return this.stack.m_204117_(tag);
        }
        if (this.tool != null) {
            return this.tool.hasTag(tag);
        }
        return false;
    }

    public ToolStack getTool() {
        if (this.tool == null) {
            assert (this.stack != null);
            this.tool = ToolStack.from(this.stack);
        }
        return this.tool;
    }

    public ItemStack getStack() {
        if (this.stack == null) {
            assert (this.tool != null);
            this.stack = this.tool.createStack(this.size);
        }
        return this.stack;
    }

    private LazyToolStack(@Nullable ItemStack stack, @Nullable ToolStack tool, int size) {
        this.stack = stack;
        this.tool = tool;
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }
}

