/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.acropolis;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.projectiles.FlyingItem;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.ally.InternalAnimationSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonAttackGoal;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonMoveGoal;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonStateGoal;
import com.Polarice3.goety_cataclysm.common.items.CataclysmItems;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.client.particle.Not_Spin_TrailParticle;
import com.github.L_Ender.cataclysm.client.particle.RingParticle;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.AcropolisMonsters.ClawdianMoveController;
import com.github.L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Wave_Entity;
import com.github.L_Ender.cataclysm.entity.etc.IHoldEntity;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.etc.path.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.entity.etc.path.SemiAquaticPathNavigator;
import com.github.L_Ender.cataclysm.entity.projectile.Accretion_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.cataclysm.message.MessageEntityCamera;
import com.github.L_Ender.lionfishapi.server.animation.LegSolverQuadruped;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;

public class ClawdianServant
extends InternalAnimationSummon
implements IHoldEntity {
    boolean searchingForLand;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState verticalswingAnimationState = new AnimationState();
    public AnimationState horizontalswingAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState chargeReadyAnimationState = new AnimationState();
    public AnimationState chargeLoopAnimationState = new AnimationState();
    public AnimationState chargeEndAnimationState = new AnimationState();
    public AnimationState waveStompAnimationState = new AnimationState();
    public AnimationState ClawPunchAnimationState = new AnimationState();
    public AnimationState GrabAndThrowAnimationState = new AnimationState();
    public AnimationState BackstepAnimationState = new AnimationState();
    public static int VERTICAL_SWING = 1;
    public static int HORIZONTAL_SWING = 2;
    public static int DEATH = 3;
    public static int CHARGE_READY = 4;
    public static int CHARGE_LOOP = 5;
    public static int CHARGE_END = 6;
    public static int WAVE_STOMP = 7;
    public static int CLAW_PUNCH = 8;
    public static int GRAB_AND_THROW = 9;
    public static int BACKSTEP = 10;
    public LegSolverQuadruped legSolver = new LegSolverQuadruped(-0.1f, 0.45f, 1.4f, 1.4f, 1.0f);
    private int charge_cooldown = 0;
    public static final int CHARGE_COOLDOWN = 200;
    private int wave_cooldown = 0;
    public static final int WAVE_COOLDOWN = 250;
    private int accretion_cooldown = 0;
    public static final int ACCRETION_COOLDOWN = 120;
    private int backstep_cooldown = 0;
    public static final int BACKSTEP_COOLDOWN = 200;
    private static final EntityDataAccessor<Optional<BlockState>> HOLD_STATE = SynchedEntityData.m_135353_(ClawdianServant.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);
    private static final EntityDataAccessor<Integer> BACKSTEP_METER = SynchedEntityData.m_135353_(ClawdianServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected final SemiAquaticPathNavigator waterNavigation;
    protected final CMPathNavigateGround groundNavigation;

    public ClawdianServant(EntityType<? extends Summoned> entity, Level world) {
        super(entity, world);
        this.m_274367_(2.5f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.waterNavigation = new SemiAquaticPathNavigator((Mob)this, world);
        this.groundNavigation = new CMPathNavigateGround((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new InternalSummonMoveGoal(this, false, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonAttackGoal(this, 0, CLAW_PUNCH, 0, 47, 19, 3.3f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && ClawdianServant.this.m_217043_().m_188501_() * 100.0f < 35.0f;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonAttackGoal(this, 0, CHARGE_READY, CHARGE_LOOP, 30, 30, 18.0f){

            @Override
            public boolean m_8036_() {
                BlockPos currentPos = this.entity.m_20183_();
                float yaw = this.entity.m_146908_() * ((float)Math.PI / 180);
                float dx = -Mth.m_14031_((float)yaw) * 2.0f;
                float dz = Mth.m_14089_((float)yaw) * 2.0f;
                BlockPos targetPos = currentPos.m_7918_((int)dx, 0, (int)dz);
                return super.m_8036_() && !ClawdianServant.this.isDangerousFallZone((PathfinderMob)this.entity, targetPos) && ClawdianServant.this.m_217043_().m_188501_() * 100.0f < 17.0f && ClawdianServant.this.charge_cooldown <= 0 && this.entity.m_20096_() && !this.entity.m_6069_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonStateGoal(this, CHARGE_LOOP, CHARGE_LOOP, CHARGE_END, 45, 45){

            @Override
            public void m_8037_() {
                LivingEntity target = this.entity.m_5448_();
                if (this.entity.attackTicks < this.attackseetick && target != null) {
                    this.entity.m_21563_().m_24960_((Entity)target, 2.0f, 30.0f);
                    this.entity.m_21391_((Entity)target, 2.0f, 30.0f);
                } else {
                    this.entity.m_146922_(this.entity.f_19859_);
                }
                BlockPos currentPos = this.entity.m_20183_();
                float yaw = this.entity.m_146908_() * ((float)Math.PI / 180);
                float dx = -Mth.m_14031_((float)yaw) * 2.0f;
                float dz = Mth.m_14089_((float)yaw) * 2.0f;
                BlockPos targetPos = currentPos.m_7918_((int)dx, 0, (int)dz);
                if (this.entity.m_20096_()) {
                    if (!ClawdianServant.this.isDangerousFallZone((PathfinderMob)this.entity, targetPos)) {
                        Vec3 motion = this.entity.m_20184_();
                        Vec3 push = new Vec3((double)(-Mth.m_14031_((float)yaw)), motion.f_82480_, (double)Mth.m_14089_((float)yaw)).m_82490_(0.5).m_82549_(motion.m_82490_(0.5));
                        this.entity.m_20334_(push.f_82479_, motion.f_82480_, push.f_82481_);
                    } else {
                        this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new InternalSummonStateGoal(this, CHARGE_END, CHARGE_END, 0, 10, 0){

            @Override
            public void m_8041_() {
                super.m_8041_();
                ClawdianServant.this.charge_cooldown = 200;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonAttackGoal(this, 0, HORIZONTAL_SWING, 0, 75, 48, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && ClawdianServant.this.m_217043_().m_188501_() * 100.0f < 27.0f;
            }

            @Override
            public void m_8037_() {
                LivingEntity target = this.entity.m_5448_();
                if (this.entity.attackTicks < this.attackseetick && target != null) {
                    this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
                } else {
                    this.entity.m_146922_(this.entity.f_19859_);
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonAttackGoal(this, 0, VERTICAL_SWING, 0, 46, 19, 5.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && ClawdianServant.this.m_217043_().m_188501_() * 100.0f < 30.0f;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonAttackGoal(this, 0, WAVE_STOMP, 0, 53, 25, 10.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && ClawdianServant.this.m_217043_().m_188501_() * 100.0f < 20.0f && ClawdianServant.this.wave_cooldown <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                ClawdianServant.this.wave_cooldown = 250;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new Clawdian_Accretion(this, 0, GRAB_AND_THROW, 0, 70, 30, 4.0f, 8.5f, 46.0f, 14.0f));
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonAttackGoal(this, 0, BACKSTEP, 0, 34, 33, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && ClawdianServant.this.m_217043_().m_188501_() * 100.0f < (float)(7 * ClawdianServant.this.getBackstep()) && ClawdianServant.this.backstep_cooldown <= 0;
            }

            @Override
            public void m_8037_() {
                LivingEntity target = this.entity.m_5448_();
                if (this.entity.attackTicks < this.attackseetick && target != null) {
                    this.entity.m_21563_().m_24960_((Entity)target, 2.0f, 30.0f);
                    this.entity.m_21391_((Entity)target, 2.0f, 30.0f);
                } else {
                    this.entity.m_146922_(this.entity.f_19859_);
                }
                if (this.entity.attackTicks < 24) {
                    this.entity.m_21566_().m_24988_(-2.0f, 0.0f);
                }
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                ClawdianServant.this.backstep_cooldown = 200;
                ClawdianServant.this.setBackstep(0);
            }
        });
    }

    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal((Summoned)this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.ClawdianDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.ClawdianHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.ClawdianArmor.get()).doubleValue()).m_22268_(Attributes.f_22285_, 3.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.ClawdianHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.ClawdianArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.ClawdianDamage.get()));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public int xpReward() {
        return 100;
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof ClawdianServant;
    }

    public int getSummonLimit(LivingEntity owner) {
        return (Integer)GCSpellConfig.ClawdianLimit.get();
    }

    protected void m_6731_(LivingEntity entity) {
        if (this.getAttackState() == CLAW_PUNCH) {
            double d0 = entity.m_20185_() - this.m_20185_();
            double d1 = entity.m_20189_() - this.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            entity.m_5997_(d0 / d2 * 9.0, 0.2, d1 / d2 * 9.0);
            entity.f_19864_ = true;
        }
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20069_()) {
            return true;
        }
        return this.getTrueOwner() != null && this.isFollowing() && (this.getTrueOwner().m_20069_() || this.m_20069_() && this.getTrueOwner().m_20186_() > this.m_20186_());
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6109_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    private boolean isDangerousFallZone(PathfinderMob mob, BlockPos pos) {
        PathNavigation navigation = mob.m_21573_();
        NodeEvaluator evaluator = navigation.m_26575_();
        if (evaluator == null) {
            return false;
        }
        BlockPathTypes type = evaluator.m_7209_((BlockGetter)mob.m_9236_(), Mth.m_14143_((float)pos.m_123341_()), Mth.m_14143_((float)pos.m_123342_()), Mth.m_14143_((float)pos.m_123343_()), (Mob)mob);
        int safeDrop = 2;
        BlockPos.MutableBlockPos checkPos = pos.m_122032_();
        for (int i = 1; i <= safeDrop; ++i) {
            checkPos.m_122173_(Direction.DOWN);
            if (mob.m_9236_().m_8055_((BlockPos)checkPos).m_60795_()) continue;
            return false;
        }
        return type == BlockPathTypes.DAMAGE_OTHER || type == BlockPathTypes.OPEN || type == BlockPathTypes.DANGER_OTHER;
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.f_21342_ = new ClawdianSwimControl(this, 6.0f);
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.f_21342_ = new ClawdianMoveController((Mob)this);
                this.m_20282_(false);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Entity rider;
        Entity entity = source.m_7640_();
        if (this.canBlockDamageSource(source)) {
            this.m_5496_((SoundEvent)CataclysmSounds.PARRY.get(), 0.2f, 1.4f);
            return false;
        }
        if (!this.m_20197_().isEmpty() && (rider = (Entity)this.m_20197_().get(0)).equals((Object)entity)) {
            return false;
        }
        boolean flag = super.m_6469_(source, damage);
        if (flag && this.getBackstep() < 10) {
            this.setBackstep(this.getBackstep() + 1);
        }
        return flag;
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn) {
        Vec3 vector3d2;
        boolean flag = false;
        if (!damageSourceIn.m_269533_(DamageTypeTags.f_276146_) && !flag && this.getAttackState() == CHARGE_LOOP && (vector3d2 = damageSourceIn.m_7270_()) != null) {
            Vec3 vector3d = this.m_20252_(1.0f);
            Vec3 vector3d1 = vector3d2.m_82505_(this.m_20182_()).m_82541_();
            vector3d1 = new Vec3(vector3d1.f_82479_, 0.0, vector3d1.f_82481_);
            return vector3d1.m_82526_(vector3d) < 0.0;
        }
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "idle")) {
            return this.idleAnimationState;
        }
        if (Objects.equals(input, "vertical_swing")) {
            return this.verticalswingAnimationState;
        }
        if (Objects.equals(input, "horizontal_swing")) {
            return this.horizontalswingAnimationState;
        }
        if (Objects.equals(input, "charge_ready")) {
            return this.chargeReadyAnimationState;
        }
        if (Objects.equals(input, "charge_loop")) {
            return this.chargeLoopAnimationState;
        }
        if (Objects.equals(input, "charge_end")) {
            return this.chargeEndAnimationState;
        }
        if (Objects.equals(input, "death")) {
            return this.deathAnimationState;
        }
        if (Objects.equals(input, "wave_stomp")) {
            return this.waveStompAnimationState;
        }
        if (Objects.equals(input, "claw_punch")) {
            return this.ClawPunchAnimationState;
        }
        if (Objects.equals(input, "grab_and_throw")) {
            return this.GrabAndThrowAnimationState;
        }
        return Objects.equals(input, "backstep") ? this.BackstepAnimationState : new AnimationState();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOLD_STATE, Optional.empty());
        this.f_19804_.m_135372_(BACKSTEP_METER, (Object)0);
    }

    public void setHoldBlock(@Nullable BlockState state) {
        this.f_19804_.m_135381_(HOLD_STATE, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState getHoldBlock() {
        return ((Optional)this.f_19804_.m_135370_(HOLD_STATE)).orElse(null);
    }

    public int getBackstep() {
        return (Integer)this.f_19804_.m_135370_(BACKSTEP_METER);
    }

    public void setBackstep(int hurt) {
        this.f_19804_.m_135381_(BACKSTEP_METER, (Object)hurt);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_)) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.verticalswingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.horizontalswingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.chargeReadyAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.chargeLoopAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.chargeEndAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.waveStompAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.ClawPunchAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.GrabAndThrowAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.BackstepAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.verticalswingAnimationState.m_216973_();
        this.horizontalswingAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.chargeReadyAnimationState.m_216973_();
        this.chargeLoopAnimationState.m_216973_();
        this.chargeEndAnimationState.m_216973_();
        this.waveStompAnimationState.m_216973_();
        this.ClawPunchAnimationState.m_216973_();
        this.GrabAndThrowAnimationState.m_216973_();
        this.BackstepAnimationState.m_216973_();
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        if (this.getTrueOwner() != null) {
            ItemStack itemStack = new ItemStack((ItemLike)CataclysmItems.CHITIN_CLAW.get());
            FlyingItem flyingItem = new FlyingItem((EntityType)ModEntityType.FLYING_ITEM.get(), this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            flyingItem.setOwner(this.getTrueOwner());
            flyingItem.setItem(itemStack);
            flyingItem.setParticle((ParticleOptions)ModParticle.SPARK.get());
            flyingItem.setSecondsCool(0);
            this.m_9236_().m_7967_((Entity)flyingItem);
        }
        super.m_6667_(p_21014_);
        this.setAttackState(DEATH);
    }

    @Override
    public int deathTimer() {
        return 45;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        BlockState blockstate = this.getHoldBlock();
        if (blockstate != null) {
            compound.m_128365_("holdBlockState", (Tag)NbtUtils.m_129202_((BlockState)blockstate));
        }
        compound.m_128405_("backstep", this.getBackstep());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        BlockState blockstate = null;
        if (compound.m_128425_("holdBlockState", 10) && (blockstate = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("holdBlockState"))).m_60795_()) {
            blockstate = null;
        }
        this.setHoldBlock(blockstate);
        this.setBackstep(compound.m_128451_("backstep"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(true, this.f_19797_);
        }
        if (this.charge_cooldown > 0) {
            --this.charge_cooldown;
        }
        if (this.wave_cooldown > 0) {
            --this.wave_cooldown;
        }
        if (this.accretion_cooldown > 0) {
            --this.accretion_cooldown;
        }
        if (this.backstep_cooldown > 0) {
            --this.backstep_cooldown;
        }
        this.legSolver.update((LivingEntity)this, this.f_20883_, this.m_6134_());
        float dis = this.m_20205_() * 0.75f;
        if (this.getAttackState() != CHARGE_LOOP) {
            this.repelEntities(dis, this.m_20206_(), dis, dis);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackState() == VERTICAL_SWING) {
            if (this.attackTicks == 22) {
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)15.0f, (float)0.2f, (int)0, (int)20);
                this.m_5496_((SoundEvent)CataclysmSounds.STRONGSWING.get(), 2.0f, 0.75f + this.m_217043_().m_188501_() * 0.1f);
                this.m_5496_(SoundEvents.f_11913_, 2.0f, 0.95f + this.m_217043_().m_188501_() * 0.1f);
                this.AreaAttack(8.5f, 8.5f, 50.0f, 1.0f, 140, false, 2.25);
                this.MakeParticle(2.0f, 7.3f, 0.35f);
            }
            if (this.attackTicks == 22) {
                this.BlockSmashDamage(2.0f, 1, 2.5f, 7.3f, 160, 1.0f, 0.15f);
            }
            if (this.attackTicks == 25) {
                this.BlockSmashDamage(2.0f, 2, 2.5f, 7.3f, 160, 1.0f, 0.15f);
            }
        }
        if (this.getAttackState() == HORIZONTAL_SWING) {
            if (this.attackTicks == 22) {
                this.m_5496_((SoundEvent)CataclysmSounds.STRONGSWING.get(), 2.0f, 0.75f + this.m_217043_().m_188501_() * 0.1f);
                this.AreaAttack(7.5f, 7.5f, 200.0f, 0.9f, 100, true, 2.25);
            }
            if (this.attackTicks == 50) {
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)15.0f, (float)0.2f, (int)0, (int)20);
                this.m_5496_((SoundEvent)CataclysmSounds.STRONGSWING.get(), 2.0f, 0.75f + this.m_217043_().m_188501_() * 0.1f);
                this.m_5496_(SoundEvents.f_11913_, 2.0f, 0.95f + this.m_217043_().m_188501_() * 0.1f);
                this.AreaAttack(8.5f, 8.5f, 50.0f, 1.15f, 160, false, 2.25);
                this.MakeParticle(2.0f, 7.3f, 0.35f);
            }
            if (this.attackTicks == 50) {
                this.BlockSmashDamage(2.0f, 1, 2.5f, 7.3f, 160, 1.0f, 0.15f);
            }
            if (this.attackTicks == 53) {
                this.BlockSmashDamage(2.0f, 2, 2.5f, 7.3f, 160, 1.0f, 0.15f);
            }
        }
        if (this.getAttackState() == CHARGE_LOOP && !this.m_9236_().f_46443_) {
            if (CMConfig.KobolediatorBlockBreaking) {
                this.ChargeBlockBreaking();
            } else if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                this.ChargeBlockBreaking();
            }
            if (this.f_19797_ % 2 == 0) {
                for (LivingEntity Lentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.2))) {
                    boolean flag;
                    if (MobUtil.areAllies((Entity)this, (Entity)Lentity) || !(flag = Lentity.m_6469_(this.getServantAttack(), (float)this.m_21133_(Attributes.f_22281_) * 0.6f)) || !Lentity.m_20096_()) continue;
                    double d0 = Lentity.m_20185_() - this.m_20185_();
                    double d1 = Lentity.m_20189_() - this.m_20189_();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    float f = 1.5f;
                    Lentity.m_5997_(d0 / d2 * (double)f, (double)0.4f, d1 / d2 * (double)f);
                }
            }
        }
        if (this.getAttackState() == WAVE_STOMP) {
            double vecZ;
            if (this.attackTicks == 27) {
                this.AreaAttack(3.5f, 3.5f, 120.0f, 1.35f, 200, false, 2.25);
                this.MakeParticle(2.0f, 0.9f, 0.0f);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)30.0f, (float)0.25f, (int)0, (int)20);
                this.m_5496_(SoundEvents.f_11913_, 2.0f, 0.95f + this.m_217043_().m_188501_() * 0.1f);
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                vecZ = Math.sin(theta);
                double vec = 2.0;
                if (!this.m_9236_().m_5776_()) {
                    numberOfWaves = 6;
                    angleStep = 35.0f;
                    firstAngleOffset = (double)(numberOfWaves - 1) / 2.0 * (double)angleStep;
                    for (i = 0; i < numberOfWaves; ++i) {
                        angle = (double)this.f_20883_ - firstAngleOffset + (double)((float)i * angleStep);
                        rad = Math.toRadians(angle);
                        dx = -Math.sin(rad);
                        dz = Math.cos(rad);
                        spawnX = this.m_20185_() + vecX * vec;
                        spawnY = this.m_20186_();
                        spawnZ = this.m_20189_() + vecZ * vec;
                        Wave_Entity WaveEntity = new Wave_Entity(this.m_9236_(), (LivingEntity)this, 80, 9.0f);
                        WaveEntity.m_6034_(spawnX, spawnY, spawnZ);
                        WaveEntity.setState(1);
                        WaveEntity.m_146922_(-((float)(Mth.m_14136_((double)dx, (double)dz) * 57.29577951308232)));
                        this.m_9236_().m_7967_((Entity)WaveEntity);
                    }
                } else {
                    numberOfWaves = 14;
                    angleStep = 15.0f;
                    firstAngleOffset = (double)(numberOfWaves - 1) / 2.0 * (double)angleStep;
                    for (i = 0; i < numberOfWaves; ++i) {
                        angle = (double)this.f_20883_ - firstAngleOffset + (double)((float)i * angleStep);
                        rad = Math.toRadians(angle);
                        dx = -Math.sin(rad);
                        dz = Math.cos(rad);
                        spawnX = this.m_20185_() + vecX * vec;
                        spawnY = this.m_20186_();
                        spawnZ = this.m_20189_() + vecZ * vec;
                        double extraX = spawnX + dx * (1.0 + this.f_19796_.m_188500_() / 2.0);
                        double extraY = spawnY + 0.9 + this.f_19796_.m_188500_() * 0.5;
                        double extraZ = spawnZ + dz * (1.0 + this.f_19796_.m_188500_() / 2.0);
                        this.m_9236_().m_7106_((ParticleOptions)new Not_Spin_TrailParticle.NSTData(0.44313726f, 0.7607843f, 0.9411765f, 0.05f, 0.5f + this.f_19796_.m_188501_() * 0.3f, 0.4f + this.f_19796_.m_188501_() * 0.2f, 0.0, 120), spawnX, spawnY, spawnZ, extraX, extraY, extraZ);
                    }
                }
            }
            for (int l = 26; l <= 28; l += 2) {
                if (this.attackTicks != l) continue;
                int d = l - 24;
                int d2 = l - 25;
                this.BlockSmashDamage(0.6f, d, 2.5f, 2.0f, 160, 1.0f, 0.15f);
                this.BlockSmashDamage(0.6f, d2, 2.5f, 2.0f, 160, 1.0f, 0.15f);
            }
            if (this.attackTicks == 31 && !this.m_9236_().m_5776_()) {
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                vecZ = Math.sin(theta);
                int numberOfSkulls = 5;
                float angleStep = 35.0f;
                double firstAngleOffset = (double)(numberOfSkulls - 1) / 2.0 * (double)angleStep;
                for (int i = 0; i < numberOfSkulls; ++i) {
                    double angle = (double)this.f_20883_ - firstAngleOffset + (double)((float)i * angleStep);
                    double rad = Math.toRadians(angle);
                    double dx = -Math.sin(rad);
                    double dz = Math.cos(rad);
                    double spawnX = this.m_20185_() + vecX * 2.0;
                    double spawnY = this.m_20186_();
                    double spawnZ = this.m_20189_() + vecZ * 2.0;
                    Wave_Entity WaveEntity = new Wave_Entity(this.m_9236_(), (LivingEntity)this, 80, 9.0f);
                    WaveEntity.m_6034_(spawnX, spawnY, spawnZ);
                    WaveEntity.setState(1);
                    WaveEntity.m_146922_(-((float)(Mth.m_14136_((double)dx, (double)dz) * 57.29577951308232)));
                    this.m_9236_().m_7967_((Entity)WaveEntity);
                }
            }
        }
        if (this.getAttackState() == CLAW_PUNCH) {
            if (this.attackTicks == 18) {
                this.m_5496_((SoundEvent)CataclysmSounds.CRAB_BITE.get(), 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
            }
            if (this.attackTicks == 21) {
                this.AreaAttack(4.5f, 4.5f, 140.0f, 1.0f, 200, true, 2.25);
            }
        }
        if (this.getAttackState() == GRAB_AND_THROW) {
            if (this.attackTicks == 16) {
                this.m_5496_(SoundEvents.f_12601_, 1.0f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
                this.MakeParticle(0.6f, 2.5f, -0.5f);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)30.0f, (float)0.25f, (int)0, (int)20);
                this.HoldAttack(4.5f, 4.5f, 60.0f, 1.0f, 120);
            }
            if (!this.m_20197_().isEmpty() && ((Entity)this.m_20197_().get(0)).m_6144_()) {
                ((Entity)this.m_20197_().get(0)).m_20260_(false);
            }
        }
    }

    private void MakeParticle(float size, float vec, float math) {
        if (this.m_9236_().f_46443_) {
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)this.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            for (int i1 = 0; i1 < 80 + this.f_19796_.m_188503_(12); ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                double extraX = size * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = size * Mth.m_14089_((float)angle);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.m_9236_().m_8055_(hit.m_7495_());
                if (block.m_60799_() == RenderShape.INVISIBLE) continue;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption((ParticleType)ModParticle.DUST_PILLAR.get(), block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
            this.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(0.0f, 1.5707964f, 30, 1.0f, 1.0f, 1.0f, 1.0f, 20.0f, false, RingParticle.EnumRingBehavior.CONSTANT), this.m_20185_() + (double)vec * vecX + (double)(f * math), this.m_20186_() + (double)0.2f, this.m_20189_() + (double)vec * vecZ + (double)(f1 * math), 0.0, 0.0, 0.0);
        }
    }

    private void BlockSmashDamage(float spreadarc, int distance, float mxy, float vec, int shieldbreakticks, float damage, float airborne) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        double minY = this.m_20186_() - 1.0;
        double maxY = this.m_20186_() + (double)mxy;
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance + (double)vec * Math.cos((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = this.m_20189_() + vz * (double)distance + (double)vec * Math.sin((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockState block = this.m_9236_().m_8055_(pos);
            int maxDepth = 256;
            for (int depthCount = 0; depthCount < maxDepth && block.m_60799_() != RenderShape.MODEL; ++depthCount) {
                pos = pos.m_7495_();
                block = this.m_9236_().m_8055_(pos);
            }
            if (block.m_60799_() != RenderShape.MODEL) {
                block = Blocks.f_50016_.m_49966_();
            }
            if (this.m_9236_().f_46443_) continue;
            Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.m_9236_(), (double)hitX + 0.5, (double)hitY + 1.0, (double)hitZ + 0.5, block, 10);
            fallingBlockEntity.m_5997_(0.0, 0.2 + this.m_217043_().m_188583_() * 0.15, 0.0);
            this.m_9236_().m_7967_((Entity)fallingBlockEntity);
            AABB selection = new AABB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
            List hit = this.m_9236_().m_45976_(LivingEntity.class, selection);
            for (LivingEntity entity : hit) {
                if (MobUtil.areAllies((Entity)this, (Entity)entity)) continue;
                DamageSource damagesource = this.getServantAttack();
                boolean flag = entity.m_6469_(damagesource, (float)(this.m_21133_(Attributes.f_22281_) * (double)damage));
                if (entity.m_21275_(damagesource) && shieldbreakticks > 0) {
                    this.disableShield(entity, shieldbreakticks);
                }
                if (!flag) continue;
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)airborne + this.m_9236_().f_46441_.m_188500_() * 0.15, 0.0));
            }
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean knockback, double xz) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        if (!this.m_9236_().f_46443_) {
            for (LivingEntity entityHit : entitiesHit) {
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || MobUtil.areAllies((Entity)this, (Entity)entityHit)) continue;
                DamageSource damagesource = this.getServantAttack();
                boolean hurt = entityHit.m_6469_(damagesource, (float)(this.m_21133_(Attributes.f_22281_) * (double)damage));
                if (entityHit.m_21275_(damagesource) && shieldbreakticks > 0) {
                    this.disableShield(entityHit, shieldbreakticks);
                }
                double d0 = entityHit.m_20185_() - this.m_20185_();
                double d1 = entityHit.m_20189_() - this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                if (!hurt || !knockback) continue;
                entityHit.m_5997_(d0 / d2 * xz, 0.15, d1 / d2 * xz);
            }
        }
    }

    private void HoldAttack(float range, float height, float arc, float damage, int shieldbreakticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        if (!this.m_9236_().f_46443_) {
            for (LivingEntity entityHit : entitiesHit) {
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || MobUtil.areAllies((Entity)this, (Entity)entityHit)) continue;
                DamageSource damagesource = this.m_269291_().m_269333_((LivingEntity)this);
                if (!entityHit.m_6095_().m_204039_(ModTag.IGNIS_CANT_POKE) && entityHit.m_6084_() && this.m_20197_().isEmpty()) {
                    if (entityHit.m_6144_()) {
                        entityHit.m_20260_(false);
                    }
                    if (!entityHit.m_6469_(damagesource, 1.0f)) continue;
                    entityHit.m_7998_((Entity)this, true);
                    Cataclysm.NETWORK_WRAPPER.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entityHit), (Object)new MessageEntityCamera(entityHit.m_19879_(), true));
                    continue;
                }
                if (this.m_7307_((Entity)entityHit)) continue;
                entityHit.m_6469_(damagesource, (float)(this.m_21133_(Attributes.f_22281_) * (double)damage));
            }
        }
    }

    private void ChargeBlockBreaking() {
        boolean flag = false;
        AABB aabb = this.m_20191_().m_82377_(0.5, 0.2, 0.5);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)this.m_20186_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60795_() || !blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || blockstate.m_204336_(ModTag.REMNANT_IMMUNE) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
            if (this.f_19796_.m_188503_(6) == 0 && !blockstate.m_155947_()) {
                Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.m_9236_(), (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, blockstate, 20);
                flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
                fallingBlockEntity.m_20256_(fallingBlockEntity.m_20184_().m_82549_(this.m_20182_().m_82546_(fallingBlockEntity.m_20182_()).m_82542_((-1.2 + this.f_19796_.m_188500_()) / 3.0, 0.2 + this.m_217043_().m_188583_() * 0.15, (-1.2 + this.f_19796_.m_188500_()) / 3.0)));
                this.m_9236_().m_7967_((Entity)fallingBlockEntity);
                continue;
            }
            flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunc) {
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double px = this.m_20185_() + 2.5 * vecX;
        double pz = this.m_20189_() + 2.5 * vecZ;
        double PosY = this.m_20186_() + (double)this.m_20206_() * 0.8;
        if (this.m_20363_(passenger)) {
            moveFunc.m_20372_(passenger, px, PosY, pz);
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() != ModEffect.EFFECTSTUN.get() && p_34192_.m_19544_() != ModEffect.EFFECTABYSSAL_CURSE.get() && super.m_7301_(p_34192_);
    }

    protected boolean m_7341_(Entity p_31508_) {
        return false;
    }

    protected boolean m_6129_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_204117_(ItemTags.f_13156_) && this.m_21223_() < this.m_21233_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.m_5634_(2.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static class Clawdian_Accretion
    extends InternalSummonAttackGoal {
        private final ClawdianServant entity;
        private final float meleerandom;
        private final float rangerandom;
        private final int getattackstate;
        private final int attackseetick;
        private final float Meleeattackrange;
        private final float attackrange;

        public Clawdian_Accretion(ClawdianServant entity, int getAttackState, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float Meleeattackrange, float attackrange, float meleerandom, float rangerandom) {
            super(entity, getAttackState, attackstate, attackendstate, attackMaxtick, attackseetick, attackrange);
            this.entity = entity;
            this.meleerandom = meleerandom;
            this.rangerandom = rangerandom;
            this.getattackstate = getAttackState;
            this.attackseetick = attackseetick;
            this.Meleeattackrange = Meleeattackrange;
            this.attackrange = attackrange;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.accretion_cooldown <= 0 && this.entity.getAttackState() == this.getattackstate && this.entity.m_20096_() && !this.entity.m_6069_() && (this.entity.m_20270_((Entity)target) < this.Meleeattackrange && this.entity.m_217043_().m_188501_() * 100.0f < this.meleerandom || this.entity.m_20270_((Entity)target) > this.attackrange && this.entity.m_217043_().m_188501_() * 100.0f < this.rangerandom);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.entity.accretion_cooldown = 120;
        }

        @Override
        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks > this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 90.0f);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
            double theta = (double)this.entity.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            if (this.entity.attackTicks == 29) {
                double vec = 2.0;
                int hitX = Mth.m_14107_((double)(this.entity.m_20185_() + vec * vecX));
                int hitY = Mth.m_14107_((double)this.entity.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.entity.m_20189_() + vec * vecZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.entity.m_9236_().m_8055_(hit.m_7495_());
                if (block.m_60799_() == RenderShape.MODEL) {
                    this.entity.setHoldBlock(block.m_60734_().m_49966_());
                } else {
                    this.entity.setHoldBlock(Blocks.f_50069_.m_49966_());
                }
            }
            this.entity.m_21573_().m_26573_();
            if (this.entity.attackTicks == 45) {
                int count = 4;
                if (target != null) {
                    double vec = 2.5;
                    double offsetangle = Math.toRadians(4 + this.entity.f_19796_.m_188503_(5));
                    for (int i = 0; i <= count - 1; ++i) {
                        Accretion_Entity acc = new Accretion_Entity((EntityType)ModEntities.ACCRETION.get(), this.entity.m_9236_(), (LivingEntity)this.entity);
                        double angle = ((double)i - (double)(count - 1) / 2.0) * offsetangle;
                        double d1 = target.m_20185_() - this.entity.m_20185_();
                        double d3 = target.m_20189_() - this.entity.m_20189_();
                        double x = d1 * Math.cos(angle) + d3 * Math.sin(angle);
                        double z = -d1 * Math.sin(angle) + d3 * Math.cos(angle);
                        double distance = Math.sqrt(x * x + z * z);
                        double d2 = target.m_20227_(0.2) - acc.m_20186_() + ((double)this.entity.f_19796_.m_188501_() - 0.5) * (double)i;
                        double PosX = this.entity.m_20185_() + vecX * vec;
                        double PosY = this.entity.m_20186_() + (double)this.entity.m_20206_() * 0.8;
                        double PosZ = this.entity.m_20189_() + vecZ * vec;
                        acc.m_20343_(PosX, PosY, PosZ);
                        acc.m_6686_(x, d2 + distance * (double)0.2f, z, 1.4f, 4.0f);
                        acc.setDamage(15.0f);
                        acc.setBlockState(this.entity.getHoldBlock());
                        acc.m_9236_().m_7967_((Entity)acc);
                    }
                } else {
                    double tempvec = 12.0;
                    double vec = 2.5;
                    double d1 = this.entity.m_20185_() + vecX * tempvec - this.entity.m_20185_();
                    double d3 = this.entity.m_20189_() + vecZ * tempvec - this.entity.m_20189_();
                    double offsetangle = Math.toRadians(4 + this.entity.f_19796_.m_188503_(5));
                    for (int i = 0; i <= count - 1; ++i) {
                        Accretion_Entity acc = new Accretion_Entity((EntityType)ModEntities.ACCRETION.get(), this.entity.m_9236_(), (LivingEntity)this.entity);
                        double angle = ((double)i - (double)(count - 1) / 2.0) * offsetangle;
                        double x = d1 * Math.cos(angle) + d3 * Math.sin(angle);
                        double z = -d1 * Math.sin(angle) + d3 * Math.cos(angle);
                        double distance = Math.sqrt(x * x + z * z);
                        double d2 = this.entity.m_20227_(0.2) - acc.m_20186_() + ((double)this.entity.f_19796_.m_188501_() - 0.5) * (double)i;
                        double PosX = this.entity.m_20185_() + vecX * vec;
                        double PosY = this.entity.m_20186_() + (double)this.entity.m_20206_() * 0.8;
                        double PosZ = this.entity.m_20189_() + vecZ * vec;
                        acc.m_20343_(PosX, PosY, PosZ);
                        acc.m_6686_(x, d2 + distance * (double)0.2f, z, 1.4f, 4.0f);
                        acc.setDamage(15.0f);
                        acc.setBlockState(this.entity.getHoldBlock());
                        acc.m_9236_().m_7967_((Entity)acc);
                    }
                }
                if (!this.entity.m_20197_().isEmpty()) {
                    Entity rider = (Entity)this.entity.m_20197_().get(0);
                    double vec = 2.5;
                    if (rider.equals((Object)target) || target == null) {
                        double tempvec = 12.0;
                        double d1 = this.entity.m_20185_() + vecX * tempvec - this.entity.m_20185_();
                        double d2 = this.entity.m_20227_(0.2) - rider.m_20186_();
                        double d3 = this.entity.m_20189_() + vecZ * tempvec - this.entity.m_20189_();
                        double distance = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3)));
                        double PosX = this.entity.m_20185_() + vecX * vec;
                        double PosY = this.entity.m_20186_() + (double)this.entity.m_20206_() * 0.8;
                        double PosZ = this.entity.m_20189_() + vecZ * vec;
                        Accretion_Entity acc = new Accretion_Entity((EntityType)ModEntities.ACCRETION.get(), this.entity.m_9236_(), (LivingEntity)this.entity);
                        acc.m_20343_(PosX, PosY, PosZ);
                        acc.m_6686_(d1, d2 + distance * (double)0.2f, d3, 1.4f, 4.0f);
                        acc.setDamage(15.0f);
                        acc.setBlockState(this.entity.getHoldBlock());
                        rider.m_7998_((Entity)acc, true);
                        acc.m_9236_().m_7967_((Entity)acc);
                    } else {
                        double d1 = target.m_20185_() - this.entity.m_20185_();
                        double d3 = target.m_20189_() - this.entity.m_20189_();
                        double d2 = target.m_20227_(0.2) - rider.m_20186_();
                        double distance = Mth.m_14116_((float)((float)(d1 * d1 + d3 * d3)));
                        double PosX = this.entity.m_20185_() + vecX * vec;
                        double PosY = this.entity.m_20186_() + (double)this.entity.m_20206_() * 0.8;
                        double PosZ = this.entity.m_20189_() + vecZ * vec;
                        Accretion_Entity acc = new Accretion_Entity((EntityType)ModEntities.ACCRETION.get(), this.entity.m_9236_(), (LivingEntity)this.entity);
                        acc.m_20343_(PosX, PosY, PosZ);
                        acc.m_6686_(d1, d2 + distance * (double)0.2f, d3, 1.4f, 4.0f);
                        acc.setDamage(15.0f);
                        acc.setBlockState(this.entity.getHoldBlock());
                        rider.m_7998_((Entity)acc, true);
                        acc.m_9236_().m_7967_((Entity)acc);
                    }
                }
            }
            if (this.entity.attackTicks == 46) {
                this.entity.setHoldBlock(null);
            }
        }

        @Override
        public boolean m_183429_() {
            return true;
        }
    }

    static class ClawdianSwimControl
    extends ClawdianMoveController {
        private final ClawdianServant drowned;
        private final float speedMulti;

        public ClawdianSwimControl(ClawdianServant p_32433_, float speedMulti) {
            super((Mob)p_32433_);
            this.drowned = p_32433_;
            this.speedMulti = speedMulti;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            LivingEntity owner = this.drowned.getTrueOwner();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand || owner != null && owner.m_20186_() > this.drowned.m_20186_() && this.drowned.isFollowing()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * (double)this.speedMulti * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }
}

