/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.factory;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.projectiles.FlyingItem;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.InternalAnimationSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonAttackGoal;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonMoveGoal;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonStateGoal;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.DeathLaserBeam;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.WitherHomingMissile;
import com.Polarice3.goety_cataclysm.common.items.GCItems;
import com.Polarice3.goety_cataclysm.common.items.revive.MechanizedCore;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCMobsConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.etc.path.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class ProwlerServant
extends InternalAnimationSummon {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState stunAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public AnimationState laserAnimationState = new AnimationState();
    public AnimationState spinAnimationState = new AnimationState();
    public AnimationState meleeAnimationState = new AnimationState();
    public AnimationState strongAttackAnimationState = new AnimationState();
    public AnimationState pierceAnimationState = new AnimationState();
    public static final int STUNNED = 1;
    public static final int LASER = 2;
    public static final int DEATH = 3;
    public static final int SPIN = 4;
    public static final int MELEE = 5;
    public static final int STRONG = 6;
    public static final int PIERCE = 7;
    public static final int SPIN_COOLDOWN = 80;
    public static final int LASER_COOLDOWN = 200;
    private int spin_cooldown = 0;
    private int laser_cooldown = 100;

    public ProwlerServant(EntityType<? extends Summoned> entity, Level world) {
        super(entity, world);
        this.m_274367_(1.25f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonMoveGoal(this, false, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WanderGoal((PathfinderMob)this, 1.0, 80.0f));
        this.f_21345_.m_25352_(0, (Goal)new InternalSummonStateGoal(this, 1, 1, 0, 60, 0));
        this.f_21345_.m_25352_(1, (Goal)new LaserShoot(this, 0, 2, 0, 90, 20, 8.0f, 20, 100.0f));
        this.f_21345_.m_25352_(1, (Goal)new InternalSummonAttackGoal(this, 0, 4, 0, 50, 22, 4.75f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && this.entity.m_217043_().m_188501_() * 100.0f < 26.0f && ProwlerServant.this.spin_cooldown <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                ProwlerServant.this.spin_cooldown = 80;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new InternalSummonAttackGoal(this, 0, 5, 0, 50, 38, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && this.entity.m_217043_().m_188501_() * 100.0f < 20.0f;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new InternalSummonAttackGoal(this, 0, 6, 0, 55, 45, 6.0f){

            @Override
            public boolean m_8036_() {
                LivingEntity target = this.entity.m_5448_();
                return super.m_8036_() && this.entity.m_217043_().m_188501_() * 100.0f < 20.0f && target != null && (double)this.entity.m_20270_((Entity)target) >= 2.75;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new InternalSummonAttackGoal(this, 0, 7, 0, 80, 38, 4.25f){

            @Override
            public boolean m_8036_() {
                LivingEntity target = this.entity.m_5448_();
                return super.m_8036_() && this.entity.m_217043_().m_188501_() * 100.0f < 24.0f && target != null;
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.ProwlerMeleeDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.ProwlerHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.ProwlerArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.95);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.ProwlerHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.ProwlerArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.ProwlerMeleeDamage.get()));
    }

    public int xpReward() {
        return 20;
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof ProwlerServant;
    }

    public int getSummonLimit(LivingEntity owner) {
        return (Integer)GCSpellConfig.ProwlerLimit.get();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        double range;
        if (source.m_276093_(CMDamageTypes.EMP) && this.getAttackState() != 1) {
            this.setAttackState(1);
        }
        if ((range = this.calculateRange(source)) > CMConfig.ProwlerLongRangelimit * CMConfig.ProwlerLongRangelimit) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "stun")) {
            return this.stunAnimationState;
        }
        if (Objects.equals(input, "laser")) {
            return this.laserAnimationState;
        }
        if (Objects.equals(input, "death")) {
            return this.deathAnimationState;
        }
        if (Objects.equals(input, "spin")) {
            return this.spinAnimationState;
        }
        if (Objects.equals(input, "idle")) {
            return this.idleAnimationState;
        }
        if (Objects.equals(input, "melee")) {
            return this.meleeAnimationState;
        }
        if (Objects.equals(input, "strong_attack")) {
            return this.strongAttackAnimationState;
        }
        if (Objects.equals(input, "pierce")) {
            return this.pierceAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_)) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.stunAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.laserAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.spinAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.meleeAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.strongAttackAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.pierceAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.laserAnimationState.m_216973_();
        this.stunAnimationState.m_216973_();
        this.spinAnimationState.m_216973_();
        this.meleeAnimationState.m_216973_();
        this.strongAttackAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
        this.pierceAnimationState.m_216973_();
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        if (this.getTrueOwner() != null && ((Boolean)GCMobsConfig.ProwlerCore.get()).booleanValue()) {
            ItemStack itemStack = new ItemStack((ItemLike)GCItems.MECHANIZED_CORE.get());
            MechanizedCore.setOwnerName((LivingEntity)this.getTrueOwner(), (ItemStack)itemStack);
            MechanizedCore.setSummon((Entity)this, (ItemStack)itemStack);
            FlyingItem flyingItem = new FlyingItem((EntityType)ModEntityType.FLYING_ITEM.get(), this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            flyingItem.setOwner(this.getTrueOwner());
            flyingItem.setItem(itemStack);
            flyingItem.setParticle((ParticleOptions)ModParticleTypes.ELECTRIC.get());
            flyingItem.setSecondsCool(30);
            this.m_9236_().m_7967_((Entity)flyingItem);
        }
        super.m_6667_(p_21014_);
        this.setAttackState(3);
    }

    @Override
    public int deathTimer() {
        return 40;
    }

    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(this.getAttackState() != 1, this.f_19797_);
        }
        if (this.laser_cooldown > 0) {
            --this.laser_cooldown;
        }
        if (this.spin_cooldown > 0) {
            --this.spin_cooldown;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity target = this.m_5448_();
        if (this.getAttackState() == 2 && this.attackTicks == 38) {
            this.m_9236_().m_6269_((Player)null, (Entity)this, (SoundEvent)CataclysmSounds.DEATH_LASER.get(), this.m_5720_(), 1.0f, 1.0f);
            ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)20.0f, (float)0.2f, (int)0, (int)10);
        }
        if (this.getAttackState() == 1 && this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.getAttackState() == 4) {
            if (this.attackTicks == 23 || this.attackTicks == 32) {
                this.AreaAttack(6.0f, 6.0f, 180.0f, 1.0f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CataclysmSounds.PROWLER_SAW_SPIN_ATTACK.get(), this.m_5720_(), 1.5f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            if (this.attackTicks == 23) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CataclysmSounds.PROWLER_SAW_SPIN_ATTACK.get(), this.m_5720_(), 1.5f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
        }
        if (this.getAttackState() == 5) {
            if (this.attackTicks == 27) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CataclysmSounds.PROWLER_SAW_SPIN_ATTACK.get(), this.m_5720_(), 1.5f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            if (this.attackTicks == 20 || this.attackTicks == 26 || this.attackTicks == 32 || this.attackTicks == 38 || this.attackTicks == 44) {
                this.AreaAttack(5.4f, 5.5f, 110.0f, 0.5f);
            }
        }
        float f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
        float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
        if (this.getAttackState() == 6) {
            if (this.attackTicks == 18) {
                this.m_5997_((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
            }
            if (this.attackTicks == 17) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CataclysmSounds.PROWLER_SAW_SPIN_ATTACK.get(), this.m_5720_(), 1.5f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            if (this.attackTicks == 25) {
                this.AreaAttack(5.5f, 5.5f, 70.0f, 1.5f);
            }
        }
        if (this.getAttackState() == 7) {
            if (target != null) {
                if (this.attackTicks == 12) {
                    this.MissileLaunch(2.0f, 0.5f, target);
                }
                if (this.attackTicks == 15) {
                    this.MissileLaunch(2.3f, 0.5f, target);
                }
                if (this.attackTicks == 18) {
                    this.MissileLaunch(2.6f, 0.5f, target);
                }
            }
            if (this.attackTicks == 18) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CataclysmSounds.PROWLER_SAW_ATTACK.get(), this.m_5720_(), 1.5f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            if (this.attackTicks == 25 || this.attackTicks == 32 || this.attackTicks == 40) {
                this.AreaAttack(5.5f, 5.5f, 60.0f, 0.5f);
            }
            if (this.attackTicks == 64) {
                this.AreaAttack(5.5f, 5.5f, 140.0f, 1.0f);
            }
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || MobUtil.areAllies((Entity)this, (Entity)entityHit) || entityHit == this) continue;
            entityHit.m_6469_(CMDamageTypes.causeShredderDamage((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage));
        }
    }

    private void MissileLaunch(float y, float math, LivingEntity target) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)CataclysmSounds.ROCKET_LAUNCH.get(), this.m_5720_(), 1.5f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double theta = (double)this.f_20883_ * (Math.PI / 180);
        double vecX = Math.cos(theta += 1.5707963267948966);
        double vecZ = Math.sin(theta);
        double d0 = this.m_20185_() + 0.5 * vecX + (double)(f * math);
        double d1 = this.m_20186_() + (double)y;
        double d2 = this.m_20189_() + 0.5 * vecZ + (double)(f1 * math);
        WitherHomingMissile missile = new WitherHomingMissile(this.m_9236_(), (LivingEntity)this, target);
        missile.m_20343_(d0, d1, d2);
        missile.setDamage(((Double)GCAttributesConfig.ProwlerMissileDamage.get()).floatValue());
        this.m_9236_().m_7967_((Entity)missile);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.PROWLER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.PROWLER_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CataclysmSounds.PROWLER_IDLE.get();
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() != ModEffect.EFFECTSTUN.get() && p_34192_.m_19544_() != ModEffect.EFFECTABYSSAL_CURSE.get() && super.m_7301_(p_34192_);
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && (itemstack.m_204117_(Tags.Items.INGOTS_IRON) || itemstack.m_204117_(Tags.Items.STORAGE_BLOCKS_IRON)) && this.m_21223_() < this.m_21233_()) {
            Level level;
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            this.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
            if (itemstack.m_204117_(Tags.Items.STORAGE_BLOCKS_IRON)) {
                this.m_5634_(45.0f);
            }
            if (itemstack.m_204117_(Tags.Items.INGOTS_IRON)) {
                this.m_5634_(5.0f);
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static class LaserShoot
    extends InternalSummonAttackGoal {
        private final ProwlerServant entity;
        private final int attackshot;
        private final float random;

        public LaserShoot(ProwlerServant entity, int getAttackState, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, int attackshot, float random) {
            super(entity, getAttackState, attackstate, attackendstate, attackMaxtick, attackseetick, attackrange);
            this.entity = entity;
            this.attackshot = attackshot;
            this.random = random;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return super.m_8036_() && target != null && this.entity.m_217043_().m_188501_() * 100.0f < this.random && this.entity.m_21574_().m_148306_((Entity)target) && this.entity.laser_cooldown <= 0;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.entity.laser_cooldown = 200;
        }

        @Override
        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            super.m_8037_();
            if (this.entity.attackTicks == this.attackshot) {
                DeathLaserBeam DeathBeam = new DeathLaserBeam((EntityType<? extends DeathLaserBeam>)((EntityType)GCEntityType.DEATH_LASER_BEAM.get()), this.entity.m_9236_(), (LivingEntity)this.entity, this.entity.m_20185_(), this.entity.m_20186_() + 1.8, this.entity.m_20189_(), (float)((double)(this.entity.f_20885_ + 90.0f) * Math.PI / 180.0), (float)((double)(-this.entity.m_146909_()) * Math.PI / 180.0), 28, ((Double)GCSpellConfig.DeathLaserDamage.get()).floatValue(), ((Double)GCSpellConfig.DeathLaserHPDamage.get()).floatValue());
                this.entity.m_9236_().m_7967_((Entity)DeathBeam);
            }
            if (this.entity.attackTicks >= this.attackshot && target != null) {
                this.entity.m_21563_().m_24950_(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 2.0f, 90.0f);
            }
        }

        @Override
        public boolean m_183429_() {
            return true;
        }
    }
}

