/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.factory;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.ally.AnimationSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.LLibrarySummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.SimpleSummonAnimationGoal;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.LaserBeamProjectile;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import com.github.L_Ender.lionfishapi.server.animation.AnimationHandler;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class WatcherServant
extends LLibrarySummon {
    public static final Animation WATCHER_BITE = Animation.create((int)22);
    public static final Animation WATCHER_SHOT = Animation.create((int)55);
    public static final Animation WATCHER_EXTRA_SHOT = Animation.create((int)17);

    public WatcherServant(EntityType<? extends AnimationSummon> entity, Level world) {
        super(entity, world);
        this.m_274367_(1.25f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, WATCHER_BITE, WATCHER_EXTRA_SHOT, WATCHER_SHOT};
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new WatcherMoveGoal(this, false, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WanderGoal((PathfinderMob)this, 1.0, 80.0f));
        this.f_21345_.m_25352_(0, (Goal)new ShotPrepare(this, WATCHER_SHOT));
        this.f_21345_.m_25352_(0, (Goal)new Shot(this, WATCHER_EXTRA_SHOT));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.WatcherMeleeDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.WatcherHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.WatcherArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.5);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.WatcherHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.WatcherArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.WatcherMeleeDamage.get()));
    }

    public int xpReward() {
        return 8;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source.m_276093_(CMDamageTypes.EMP)) {
            damage = 1000.0f;
        }
        return super.m_6469_(source, damage);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_146922_(this.f_20883_);
        LivingEntity target = this.m_5448_();
        if (this.getAnimation() == WATCHER_BITE && this.getAnimationTick() == 13 && target != null && this.m_20270_((Entity)target) < 3.0f && this.m_142582_((Entity)target)) {
            float damage = (int)this.m_21133_(Attributes.f_22281_);
            target.m_6469_(this.getServantAttack(), damage);
        }
        if (this.getAnimation() == WATCHER_EXTRA_SHOT && this.getAnimationTick() == 9) {
            if (!this.m_20067_()) {
                this.m_5496_((SoundEvent)CataclysmSounds.HARBINGER_LASER.get(), 1.0f, 1.0f);
            }
            if (target != null && target.m_6084_()) {
                double d0 = this.m_20185_();
                double d1 = this.m_20186_() + (double)(this.m_20206_() * 1.0f / 2.0f);
                double d2 = this.m_20189_();
                double d3 = target.m_20185_() - d0;
                double d4 = target.m_20186_() + (double)(target.m_20206_() * 1.0f / 2.0f) - d1;
                double d5 = target.m_20189_() - d2;
                Vec3 vec3 = new Vec3(d3, d4, d5);
                LaserBeamProjectile laserBeam = new LaserBeamProjectile((LivingEntity)this, d3, d4, d5, this.m_9236_(), ((Double)GCAttributesConfig.WatcherRangeDamage.get()).floatValue());
                float yRot = (float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.29577951308232) + 90.0f;
                float xRot = (float)(-(Mth.m_14136_((double)vec3.f_82480_, (double)Math.sqrt(vec3.f_82479_ * vec3.f_82479_ + vec3.f_82481_ * vec3.f_82481_)) * 57.29577951308232));
                laserBeam.m_146922_(yRot);
                laserBeam.m_146926_(xRot);
                laserBeam.m_20343_(d0, d1, d2);
                this.m_9236_().m_7967_((Entity)laserBeam);
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.WATCHER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.WATCHER_DEATH.get();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_204117_(Tags.Items.INGOTS_IRON) && this.m_21223_() < this.m_21233_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            this.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
            this.m_5634_(5.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static class WatcherMoveGoal
    extends Goal {
        private final WatcherServant watcher;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private int delayCounter;
        protected final double moveSpeed;

        public WatcherMoveGoal(WatcherServant boss, boolean followingTargetEvenIfNotSeen, double moveSpeed) {
            this.watcher = boss;
            this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
            this.moveSpeed = moveSpeed;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity target = this.watcher.m_5448_();
            return target != null && target.m_6084_();
        }

        public void m_8041_() {
            this.watcher.m_21573_().m_26573_();
            LivingEntity livingentity = this.watcher.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.watcher.m_6710_(null);
            }
            this.watcher.m_21561_(false);
            this.watcher.m_21573_().m_26573_();
        }

        public boolean m_8045_() {
            LivingEntity target = this.watcher.m_5448_();
            if (target == null) {
                return false;
            }
            if (!target.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.watcher.m_21573_().m_26571_();
            }
            if (!this.watcher.m_21444_(target.m_20183_())) {
                return false;
            }
            return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
        }

        public void m_8056_() {
            this.watcher.m_21573_().m_26536_(this.path, this.moveSpeed);
            this.watcher.m_21561_(true);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.watcher.m_5448_();
            if (target != null) {
                this.watcher.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                double distSq = this.watcher.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
                if (--this.delayCounter <= 0) {
                    this.delayCounter = 4 + this.watcher.m_217043_().m_188503_(7);
                    if (distSq > Math.pow(this.watcher.m_21051_(Attributes.f_22277_).m_22135_(), 2.0)) {
                        if (!this.watcher.m_21691_() && !this.watcher.m_21573_().m_5624_((Entity)target, 1.0)) {
                            this.delayCounter += 5;
                        }
                    } else {
                        this.watcher.m_21573_().m_5624_((Entity)target, this.moveSpeed);
                    }
                }
                if (target.m_6084_() && this.watcher.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    if (this.watcher.m_20270_((Entity)target) < 1.5f) {
                        this.watcher.setAnimation(WATCHER_BITE);
                    } else if (this.watcher.m_217043_().m_188501_() * 100.0f < 24.0f && (double)this.watcher.m_20270_((Entity)target) >= 6.0) {
                        this.watcher.setAnimation(WATCHER_SHOT);
                    }
                }
            }
        }
    }

    static class ShotPrepare
    extends SimpleSummonAnimationGoal<WatcherServant> {
        public ShotPrepare(WatcherServant entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public void m_8056_() {
            LivingEntity target = ((WatcherServant)this.entity).m_5448_();
            if (target != null) {
                ((WatcherServant)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            super.m_8056_();
        }

        public void m_8041_() {
            LivingEntity target = ((WatcherServant)this.entity).m_5448_();
            if (target != null) {
                ((WatcherServant)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            super.m_8041_();
        }

        public void m_8037_() {
            LivingEntity target = ((WatcherServant)this.entity).m_5448_();
            if (target != null) {
                ((WatcherServant)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                if (((WatcherServant)this.entity).getAnimationTick() == 45) {
                    AnimationHandler.INSTANCE.sendAnimationMessage((Entity)((WatcherServant)this.entity), WATCHER_EXTRA_SHOT);
                }
            }
        }
    }

    static class Shot
    extends SimpleSummonAnimationGoal<WatcherServant> {
        public Shot(WatcherServant entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public void m_8056_() {
            LivingEntity target = ((WatcherServant)this.entity).m_5448_();
            if (target != null) {
                ((WatcherServant)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
            }
            super.m_8056_();
        }

        public void m_8037_() {
            LivingEntity target = ((WatcherServant)this.entity).m_5448_();
            if (((WatcherServant)this.entity).getAnimationTick() < 7 && target != null) {
                ((WatcherServant)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((WatcherServant)this.entity).m_146922_(((WatcherServant)this.entity).f_19859_);
            }
            if (target != null && ((WatcherServant)this.entity).getAnimationTick() == 11 && ((WatcherServant)this.entity).m_217043_().m_188501_() * 100.0f < 60.0f) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)((WatcherServant)this.entity), WATCHER_EXTRA_SHOT);
            }
        }
    }
}

