/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractIgnisFireball
extends AbstractHurtingProjectile {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(AbstractIgnisFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> OWNER_CLIENT_ID = SynchedEntityData.m_135353_(AbstractIgnisFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> TARGET_UNIQUE_ID = SynchedEntityData.m_135353_(AbstractIgnisFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> TARGET_CLIENT_ID = SynchedEntityData.m_135353_(AbstractIgnisFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> DATA_EXTRA_DAMAGE = SynchedEntityData.m_135353_(AbstractIgnisFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(AbstractIgnisFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.m_135353_(AbstractIgnisFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int timer;
    private Vec3[] trailPositions = new Vec3[64];
    private int trailPointer = -1;

    public AbstractIgnisFireball(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
    }

    public AbstractIgnisFireball(EntityType<? extends AbstractHurtingProjectile> p_36817_, double p_36818_, double p_36819_, double p_36820_, double p_36821_, double p_36822_, double p_36823_, Level p_36824_) {
        super(p_36817_, p_36818_, p_36819_, p_36820_, p_36821_, p_36822_, p_36823_, p_36824_);
    }

    public AbstractIgnisFireball(EntityType<? extends AbstractHurtingProjectile> p_36826_, LivingEntity p_36827_, double p_36828_, double p_36829_, double p_36830_, Level p_36831_) {
        super(p_36826_, p_36827_, p_36828_, p_36829_, p_36830_, p_36831_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(OWNER_CLIENT_ID, (Object)-1);
        this.f_19804_.m_135372_(TARGET_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(TARGET_CLIENT_ID, (Object)-1);
        this.f_19804_.m_135372_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FIRED, (Object)false);
        this.defineRadius();
    }

    public void defineRadius() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(1.0f));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Owner")) {
            this.setOwnerId(compound.m_128342_("Owner"));
        }
        if (compound.m_128441_("OwnerClient")) {
            this.setOwnerClientId(compound.m_128451_("OwnerClient"));
        }
        if (compound.m_128403_("Target")) {
            this.setTargetId(compound.m_128342_("Target"));
        }
        if (compound.m_128441_("TargetClient")) {
            this.setTargetClientId(compound.m_128451_("TargetClient"));
        }
        if (compound.m_128441_("ExtraDamage")) {
            this.setExtraDamage(compound.m_128457_("ExtraDamage"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        if (this.getOwnerClientId() > -1) {
            compound.m_128405_("OwnerClient", this.getOwnerClientId());
        }
        if (this.getTargetId() != null) {
            compound.m_128362_("Target", this.getTargetId());
        }
        if (this.getTargetClientId() > -1) {
            compound.m_128405_("TargetClient", this.getTargetClientId());
        }
        compound.m_128350_("ExtraDamage", this.getExtraDamage());
    }

    @Nullable
    public LivingEntity getOwner() {
        LivingEntity living;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD((UUID)uuid);
        }
        int id = this.getOwnerClientId();
        return id <= -1 ? null : ((entity = this.m_9236_().m_6815_(this.getOwnerClientId())) instanceof LivingEntity ? (living = (LivingEntity)entity) : null);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.getOwnerId();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public int getOwnerClientId() {
        return (Integer)this.f_19804_.m_135370_(OWNER_CLIENT_ID);
    }

    public void setOwnerClientId(int id) {
        this.f_19804_.m_135381_(OWNER_CLIENT_ID, (Object)id);
    }

    @Nullable
    public LivingEntity getTarget() {
        LivingEntity living;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            UUID uuid = this.getTargetId();
            return uuid == null ? null : EntityFinder.getLivingEntityByUuiD((UUID)uuid);
        }
        int id = this.getTargetClientId();
        return id <= -1 ? null : ((entity = this.m_9236_().m_6815_(this.getTargetClientId())) instanceof LivingEntity ? (living = (LivingEntity)entity) : null);
    }

    @Nullable
    public UUID getTargetId() {
        return ((Optional)this.f_19804_.m_135370_(TARGET_UNIQUE_ID)).orElse(null);
    }

    public void setTargetId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(TARGET_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public int getTargetClientId() {
        return (Integer)this.f_19804_.m_135370_(TARGET_CLIENT_ID);
    }

    public void setTargetClientId(int id) {
        this.f_19804_.m_135381_(TARGET_CLIENT_ID, (Object)id);
    }

    public void setOwner(LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setOwnerId(livingEntity.m_20148_());
            this.setOwnerClientId(livingEntity.m_19879_());
        }
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null) {
            this.setTargetId(livingEntity.m_20148_());
            this.setTargetClientId(livingEntity.m_19879_());
        }
    }

    public float getExtraDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_EXTRA_DAMAGE)).floatValue();
    }

    public void setExtraDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
    }

    public void setRadius(float pDamage) {
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(pDamage));
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            --this.timer;
            if (this.timer <= 0 && !this.getFired()) {
                this.setFired(true);
            }
        }
        if (this.timer < -160) {
            this.m_146870_();
        }
        Vec3 trailAt = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        if (this.trailPointer == -1) {
            Arrays.fill(this.trailPositions, trailAt);
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = trailAt;
    }

    public void setUp(int delay) {
        this.setFired(false);
        this.timer = delay;
    }

    public void setFired(boolean fired) {
        this.f_19804_.m_135381_(FIRED, (Object)fired);
    }

    public boolean getFired() {
        return (Boolean)this.f_19804_.m_135370_(FIRED);
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.getOwner() != null) {
            Projectile projectile;
            Mob mob;
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), (Entity)pEntity)) {
                return false;
            }
            if (this.getOwner() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof Projectile && (projectile = (Projectile)pEntity).m_19749_() == this.getOwner()) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.getOwner();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack((IOwned)owned0, (IOwned)owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }

    public boolean hasTrail() {
        return this.trailPointer != -1;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

