/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.projectiles;

import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.AbstractIgnisFireball;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.util.CustomExplosion.IgnisExplosion;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class IgnisAbyssFireball
extends AbstractIgnisFireball {
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.m_135353_(IgnisAbyssFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public IgnisAbyssFireball(EntityType<? extends IgnisAbyssFireball> type, Level level) {
        super(type, level);
    }

    public IgnisAbyssFireball(Level level, LivingEntity entity, double x, double y, double z) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)GCEntityType.IGNIS_ABYSS_FIREBALL.get()), entity, x, y, z, level);
    }

    public IgnisAbyssFireball(Level worldIn, LivingEntity owner, @Nullable LivingEntity target) {
        this((EntityType<? extends IgnisAbyssFireball>)((EntityType)GCEntityType.IGNIS_ABYSS_FIREBALL.get()), worldIn);
        this.setOwner(owner);
        this.setTarget(target);
    }

    @Override
    public void defineRadius() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(2.0f));
    }

    protected Component m_5677_() {
        return ((EntityType)ModEntities.IGNIS_ABYSS_FIREBALL.get()).m_20676_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if ((this.timer == 0 || this.timer == -40) && this.getTotalBounces() == 0) {
            if (this.getTarget() != null) {
                LivingEntity target = this.getTarget();
                float speed = 0.2f;
                double dx = target.m_20185_() - this.m_20185_();
                double dy = target.m_20186_() + (double)(target.m_20206_() * 0.5f) - this.m_20186_();
                double dz = target.m_20189_() - this.m_20189_();
                double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                this.f_36813_ = (dx /= d) * (double)speed;
                this.f_36814_ = (dy /= d) * (double)speed;
                this.f_36815_ = (dz /= d) * (double)speed;
            } else {
                ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
                for (Entity entity1 : this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82400_(16.0))) {
                    PartEntity partEntity;
                    Entity entity;
                    LivingEntity livingEntity = null;
                    if (entity1 instanceof PartEntity && (entity = (partEntity = (PartEntity)entity1).getParent()) instanceof LivingEntity) {
                        LivingEntity living;
                        livingEntity = living = (LivingEntity)entity;
                    } else if (entity1 instanceof LivingEntity) {
                        LivingEntity living;
                        livingEntity = living = (LivingEntity)entity1;
                    }
                    if (livingEntity == null || !MobUtil.ownedPredicate((Entity)this).test(livingEntity)) continue;
                    list.add(livingEntity);
                }
                list.sort(Comparator.comparingDouble(arg_0 -> ((IgnisAbyssFireball)this).m_20270_(arg_0)));
                if (list.stream().findFirst().isPresent()) {
                    LivingEntity livingEntity = (LivingEntity)list.stream().findFirst().get();
                    this.setTarget(livingEntity);
                }
            }
        }
    }

    protected void m_5790_(EntityHitResult p_37626_) {
        super.m_5790_(p_37626_);
        LivingEntity shooter = this.getOwner();
        if (!this.m_9236_().f_46443_ && this.getFired()) {
            boolean flag;
            LivingEntity livingEntity;
            Entity entity = p_37626_.m_82443_();
            if (shooter instanceof LivingEntity) {
                LivingEntity owner = shooter;
                if (entity instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity;
                    flag = entity.m_6469_(this.m_269291_().m_269299_((Entity)this, owner), 10.0f + this.getExtraDamage() + livingEntity.m_21233_() * 0.2f);
                } else {
                    flag = entity.m_6469_(this.m_269291_().m_269299_((Entity)this, owner), 10.0f + this.getExtraDamage());
                }
                if (flag) {
                    this.m_19970_(owner, entity);
                    if (entity instanceof LivingEntity) {
                        owner.m_5634_(5.0f);
                    }
                }
            } else {
                flag = entity.m_6469_(this.m_269291_().m_269425_(), 5.0f + this.getExtraDamage());
            }
            IgnisExplosion explosion = new IgnisExplosion(this.m_9236_(), (Entity)this, (DamageSource)null, (ExplosionDamageCalculator)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, true, Explosion.BlockInteraction.KEEP);
            explosion.m_46061_();
            explosion.finalizeExplosion(3, 0.75);
            this.m_146870_();
            if (flag && entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                MobEffectInstance effectinstance1 = livingEntity.m_21124_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                int i = 2;
                if (effectinstance1 != null) {
                    i += effectinstance1.m_19564_();
                    livingEntity.m_6234_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                } else {
                    --i;
                }
                i = Mth.m_14045_((int)i, (int)0, (int)4);
                MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get(), 200, i, false, false, true);
                livingEntity.m_7292_(effectinstance);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockState blockstate = this.m_9236_().m_8055_(result.m_82425_());
        if (!blockstate.m_60812_((BlockGetter)this.m_9236_(), result.m_82425_()).m_83281_() && this.getFired()) {
            Direction face = result.m_82434_();
            blockstate.m_60669_(this.m_9236_(), blockstate, result, (Projectile)this);
            Vec3 motion = this.m_20184_();
            double motionX = motion.m_7096_();
            double motionY = motion.m_7098_();
            double motionZ = motion.m_7094_();
            if (face == Direction.EAST) {
                motionX = -motionX;
            } else if (face == Direction.SOUTH) {
                motionZ = -motionZ;
            } else if (face == Direction.WEST) {
                motionX = -motionX;
            } else if (face == Direction.NORTH) {
                motionZ = -motionZ;
            } else if (face == Direction.UP) {
                motionY = -motionY;
            } else if (face == Direction.DOWN) {
                motionY = -motionY;
            }
            this.m_20334_(motionX, motionY, motionZ);
            this.f_36813_ = motionX * 0.05;
            this.f_36814_ = motionY * 0.05;
            this.f_36815_ = motionZ * 0.05;
            if (this.f_19797_ <= 500 && this.getTotalBounces() <= 5) {
                this.setTotalBounces(this.getTotalBounces() + 1);
            } else if (!this.m_9236_().f_46443_) {
                IgnisExplosion explosion = new IgnisExplosion(this.m_9236_(), (Entity)this, (DamageSource)null, (ExplosionDamageCalculator)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, true, Explosion.BlockInteraction.KEEP);
                explosion.m_46061_();
                explosion.finalizeExplosion(3, 0.5);
                this.m_146870_();
            }
        }
    }

    protected void m_6532_(HitResult ray) {
        HitResult.Type hitresult$type = ray.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)ray);
            this.m_9236_().m_214171_(GameEvent.f_157777_, ray.m_82450_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)ray;
            this.m_8060_(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOUNCES, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("totalBounces", this.getTotalBounces());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setTotalBounces(compound.m_128451_("totalBounces"));
    }

    public int getTotalBounces() {
        return (Integer)this.f_19804_.m_135370_(BOUNCES);
    }

    public void setTotalBounces(int bounces) {
        this.f_19804_.m_135381_(BOUNCES, (Object)bounces);
    }

    public boolean m_6469_(DamageSource p_36839_, float p_36840_) {
        if (this.m_6673_(p_36839_)) {
            return false;
        }
        this.m_5834_();
        Entity entity = p_36839_.m_7639_();
        if (entity != null && this.getFired()) {
            if (!this.m_9236_().f_46443_) {
                Vec3 vec3 = entity.m_20154_();
                this.m_20256_(vec3);
                this.f_36813_ = vec3.f_82479_ * 0.1;
                this.f_36814_ = vec3.f_82480_ * 0.1;
                this.f_36815_ = vec3.f_82481_ * 0.1;
                this.m_5602_(entity);
            }
            return true;
        }
        return false;
    }
}

