/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.events;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.magic.GolemType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.Fangs;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.NoKnockBackDamageSource;
import com.Polarice3.goety_cataclysm.common.blocks.GoetyBlocks;
import com.Polarice3.goety_cataclysm.common.entities.ally.golem.NMPart;
import com.Polarice3.goety_cataclysm.common.entities.ally.golem.NetheriteMonstrosityServant;
import com.Polarice3.goety_cataclysm.common.items.CataclysmItems;
import com.Polarice3.goety_cataclysm.common.items.GoetyItems;
import com.Polarice3.goety_cataclysm.common.magic.construct.NetheriteMonstrosityMold;
import com.Polarice3.goety_cataclysm.init.GCGolemTypes;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.util.CustomExplosion.IgnisExplosion;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber(modid="goety_cataclysm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GCEvents {
    @SubscribeEvent
    public static void worldLoad(LevelEvent.Load event) {
        GCGolemTypes.addGolems();
    }

    @SubscribeEvent
    public static void worldUnload(LevelEvent.Unload event) {
        Object[] members;
        for (GolemType golemType : members = GolemType.values()) {
            if (!GCGolemTypes.NEW_GOLEM_TYPES.contains(golemType)) continue;
            ArrayUtils.remove((Object[])members, (int)golemType.ordinal());
        }
    }

    @SubscribeEvent
    public static void PlayerAttackEvent(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof NMPart) {
            IOwned owned;
            LivingEntity livingEntity;
            NMPart nmPart = (NMPart)entity;
            ItemStack itemStack = event.getEntity().m_21205_();
            if ((((NetheriteMonstrosityServant)nmPart.getParent()).getTrueOwner() == event.getEntity() || (livingEntity = ((NetheriteMonstrosityServant)nmPart.getParent()).getTrueOwner()) instanceof IOwned && (owned = (IOwned)livingEntity).getTrueOwner() == event.getEntity()) && ((Boolean)MobsConfig.OwnerAttackCancel.get()).booleanValue()) {
                itemStack.m_41720_().onLeftClickEntity(itemStack, event.getEntity(), nmPart.getParent());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void UseOnBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState blockState;
        if (event.getItemStack().m_150930_((Item)CataclysmItems.INFERNAL_FORGE.get()) && (blockState = event.getLevel().m_8055_(event.getPos())).m_60713_((Block)GoetyBlocks.REINFORCED_REDSTONE_BLOCK.get()) && new NetheriteMonstrosityMold().spawnServant(event.getEntity(), event.getItemStack(), event.getLevel(), event.getPos())) {
            event.getItemStack().m_41774_(1);
            event.getEntity().m_6674_(event.getHand());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingInteract(PlayerInteractEvent.EntityInteract event) {
        IOwned owned;
        LivingEntity livingEntity;
        NMPart nmPart;
        Entity entity;
        if (!event.getLevel().f_46443_ && (entity = event.getTarget()) instanceof NMPart && (((NetheriteMonstrosityServant)(nmPart = (NMPart)entity).getParent()).getTrueOwner() == event.getEntity() || (livingEntity = ((NetheriteMonstrosityServant)nmPart.getParent()).getTrueOwner()) instanceof IOwned && (owned = (IOwned)livingEntity).getTrueOwner() == event.getEntity())) {
            event.getItemStack().m_41720_().m_6880_(event.getItemStack(), event.getEntity(), (LivingEntity)nmPart.getParent(), event.getHand());
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        MobEffectInstance effectinstance1;
        LivingEntity entity = event.getEntity();
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        if (source.m_269533_(ModTags.DamageTypes.SHOCK_ATTACKS) && entity.m_21023_((MobEffect)ModEffect.EFFECTWETNESS.get()) && (effectinstance1 = entity.m_21124_((MobEffect)ModEffect.EFFECTWETNESS.get())) != null) {
            float i = (float)(effectinstance1.m_19564_() + 1) * 0.2f;
            float f = damage + damage * i;
            damage = Math.min(Float.MAX_VALUE, f);
            event.setAmount(damage);
        }
    }

    @SubscribeEvent
    public static void SpecialDeath(LivingDeathEvent event) {
        LivingEntity killed = event.getEntity();
        Entity killer = event.getSource().m_7639_();
        Level world = killed.m_20193_();
        DamageSource damageSource = event.getSource();
        if (damageSource instanceof NoKnockBackDamageSource) {
            NoKnockBackDamageSource noKnockBackDamageSource = (NoKnockBackDamageSource)damageSource;
            killer = noKnockBackDamageSource.getOwner();
        }
        if (killer instanceof Player) {
            int enchantment;
            Entity entity;
            Player player = (Player)killer;
            if (world.m_46469_().m_46207_(GameRules.f_46135_) && (entity = event.getSource().m_7640_()) instanceof Fangs && CuriosFinder.findRing((Player)player).m_41720_() == GoetyItems.RING_OF_WANT.get() && (enchantment = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.WANTING.get()), (ItemStack)CuriosFinder.findRing((Player)player))) >= 3 && world.f_46441_.m_188501_() <= (float)enchantment / 9.0f) {
                if (killed.m_6095_() == ModEntities.DRAUGR.get() || killed.m_6095_() == ModEntities.ELITE_DRAUGR.get() || killed.m_6095_() == ModEntities.ROYAL_DRAUGR.get()) {
                    killed.m_19983_(new ItemStack((ItemLike)CataclysmItems.DRAUGR_HEAD.get()));
                }
                if (killed.m_6095_() == ModEntities.APTRGANGR.get()) {
                    killed.m_19983_(new ItemStack((ItemLike)CataclysmItems.APTRGANGR_HEAD.get()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void LootEvents(LootingLevelEvent event) {
        if (event.getDamageSource() != null && event.getEntity() != null && !event.getEntity().m_9236_().f_46443_) {
            int looting = 0;
            Entity entity = event.getDamageSource().m_7639_();
            if (entity instanceof Player) {
                Entity direct;
                Player player = (Player)entity;
                if (event.getDamageSource().m_276093_(DamageTypes.f_268534_) && event.getDamageSource().m_7640_() != null && ((direct = event.getDamageSource().m_7640_()).m_6095_().m_20676_().getString().contains("cataclysm") || direct.m_6095_().m_20676_().getString().contains("goety_cataclysm"))) {
                    if (CuriosFinder.findRing((Player)player).m_41720_() == GoetyItems.RING_OF_WANT.get() && CuriosFinder.findRing((Player)player).m_41793_()) {
                        looting = CuriosFinder.findRing((Player)player).getEnchantmentLevel((Enchantment)ModEnchantments.WANTING.get());
                    }
                    if (looting > event.getLootingLevel()) {
                        event.setLootingLevel(looting);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void PotionApplicationEvent(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance().m_19544_() == ModEffect.EFFECTSTUN.get() && event.getEntity().m_6095_().m_204039_(ModTags.EntityTypes.UNSTUNNABLE)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void ExplosionEvent(ExplosionEvent.Detonate event) {
        if (event.getExplosion() instanceof IgnisExplosion && event.getExplosion().m_252906_() != null) {
            LivingEntity livingEntity = event.getExplosion().m_252906_();
            if (CuriosFinder.hasWanting((Entity)livingEntity)) {
                event.getAffectedEntities().removeIf(entity -> entity instanceof ItemEntity);
            }
            event.getAffectedEntities().removeIf(entity -> MobUtil.areAllies((Entity)livingEntity, (Entity)entity));
        }
    }
}

