/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import com.github.L_Ender.cataclysm.entity.projectile.Lightning_Spear_Entity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LightningSpearSpell
extends Spell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.LightningSpearCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.LightningSpearDuration.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.LightningSpearCoolDown.get();
    }

    @Nullable
    public SoundEvent CastingSound(LivingEntity caster) {
        return (SoundEvent)GoetySounds.ZAP.get();
    }

    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float velocity = spellStat.getVelocity();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.POTENCY.get()), (LivingEntity)caster);
            velocity += (float)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.VELOCITY.get()), (LivingEntity)caster) / 10.0f;
            radius += (double)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RADIUS.get()), (LivingEntity)caster);
        }
        Vec3 vector3d = caster.m_20154_();
        float multiply = ((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        float damage = (float)((Double)GCSpellConfig.LightningSpearDamage.get() * (double)multiply);
        float areaDamage = (float)((Double)GCSpellConfig.LightningSpearAreaDamage.get() * (double)multiply);
        float yRot = (float)(Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) * 57.29577951308232) + 90.0f;
        float xRot = (float)(-(Mth.m_14136_((double)vector3d.f_82480_, (double)Math.sqrt(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82481_ * vector3d.f_82481_)) * 57.29577951308232));
        if (this.rightStaff(staff)) {
            for (int i = 0; i < 2; ++i) {
                float f = Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
                double dis = 2.0;
                double firstAngleOffset = 0.5 * dis;
                double math = -0.5 - firstAngleOffset + (double)i * dis;
                double d0 = caster.m_20185_() + (double)f * math;
                double d1 = caster.m_20186_() + (double)(caster.m_20206_() * 0.7f);
                double d2 = caster.m_20189_() + (double)f1 * math;
                Lightning_Spear_Entity lightning = new Lightning_Spear_Entity(caster, vector3d, (Level)worldIn, damage + (float)potency);
                lightning.accelerationPower = 0.15 + (double)velocity;
                lightning.m_146922_(yRot);
                lightning.m_146926_(xRot);
                lightning.m_20343_(d0, caster.m_20188_() - 0.2, d2);
                lightning.setAreaDamage(areaDamage + (float)potency);
                lightning.setHpDamage(((Double)GCSpellConfig.LightningSpearHPDamage.get()).floatValue());
                lightning.setAreaRadius((float)radius);
                worldIn.m_7967_((Entity)lightning);
            }
        } else {
            Lightning_Spear_Entity lightningSpear = new Lightning_Spear_Entity(caster, vector3d, (Level)worldIn, damage + (float)potency);
            lightningSpear.m_146922_(yRot);
            lightningSpear.m_146926_(xRot);
            lightningSpear.m_20343_(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0);
            lightningSpear.accelerationPower = 0.2 + (double)velocity;
            lightningSpear.setAreaDamage(areaDamage + (float)potency);
            lightningSpear.setAreaRadius((float)radius);
            worldIn.m_7967_((Entity)lightningSpear);
        }
        this.playSound(worldIn, (Entity)caster, (SoundEvent)GoetySounds.SHOCK_CAST.get());
    }
}

