/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.inventory;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IInventorySlot
extends INBTSerializable<CompoundTag>,
IContentsListener {
    public ItemStack getStack();

    public void setStack(ItemStack var1);

    default public ItemStack insertItem(ItemStack stack, Action action, AutomationType automationType) {
        if (stack.m_41619_() || !this.isItemValid(stack)) {
            return stack;
        }
        int needed = this.getLimit(stack) - this.getCount();
        if (needed <= 0) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStack(), (ItemStack)stack))) {
            int toAdd = Math.min(stack.m_41613_(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.growStack(toAdd, action);
                } else {
                    this.setStack(stack.m_255036_(toAdd));
                }
            }
            return stack.m_255036_(stack.m_41613_() - toAdd);
        }
        return stack;
    }

    default public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1) {
            return ItemStack.f_41583_;
        }
        ItemStack current = this.getStack();
        int currentAmount = Math.min(this.getCount(), current.m_41741_());
        if (currentAmount < amount) {
            amount = currentAmount;
        }
        ItemStack toReturn = current.m_255036_(amount);
        if (action.execute()) {
            this.shrinkStack(amount, action);
        }
        return toReturn;
    }

    public int getLimit(ItemStack var1);

    public boolean isItemValid(ItemStack var1);

    @Nullable
    public Slot createContainerSlot();

    default public int setStackSize(int amount, Action action) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0;
        }
        ItemStack stack = this.getStack();
        int maxStackSize = this.getLimit(stack);
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (stack.m_41613_() == amount || action.simulate()) {
            return amount;
        }
        this.setStack(stack.m_255036_(amount));
        return amount;
    }

    default public int growStack(int amount, Action action) {
        int current = this.getCount();
        if (amount > 0) {
            amount = Math.min(amount, this.getLimit(this.getStack()));
        }
        int newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    default public int shrinkStack(int amount, Action action) {
        return -this.growStack(-amount, action);
    }

    default public boolean isEmpty() {
        return this.getStack().m_41619_();
    }

    default public void setEmpty() {
        this.setStack(ItemStack.f_41583_);
    }

    default public int getCount() {
        return this.getStack().m_41613_();
    }
}

