/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.List;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.Coord4D;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.tier.BaseTier;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.advancements.triggers.UseGaugeDropperTrigger;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.network.NetworkEvent;

public class PacketDropperUse
implements IMekanismPacket {
    private final BlockPos pos;
    private final DropperAction action;
    private final TankType tankType;
    private final int tankId;

    public PacketDropperUse(BlockPos pos, DropperAction action, TankType tankType, int tankId) {
        this.pos = pos;
        this.action = action;
        this.tankType = tankType;
        this.tankId = tankId;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        TileEntityMekanism tile;
        ServerPlayer player = context.getSender();
        if (player == null || this.tankId < 0) {
            return;
        }
        ItemStack stack = player.f_36096_.m_142621_();
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemGaugeDropper && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.m_9236_(), this.pos)) != null) {
            if (tile instanceof TileEntityMultiblock) {
                TileEntityMultiblock multiblock = (TileEntityMultiblock)tile;
                MultiblockData structure = multiblock.getMultiblock();
                if (structure.isFormed()) {
                    this.handleTankType(structure, player, stack, new Coord4D((Vec3i)structure.getBounds().getCenter(), player.m_9236_()));
                }
            } else {
                if (this.action == DropperAction.DUMP_TANK && !player.m_7500_() && Attribute.getBaseTier(tile.getBlockType()) == BaseTier.CREATIVE) {
                    return;
                }
                this.handleTankType(tile, player, stack, tile.getTileCoord());
            }
        }
    }

    private <HANDLER extends IMekanismFluidHandler & IGasTracker & IPigmentTracker> void handleTankType(HANDLER handler, ServerPlayer player, ItemStack stack, Coord4D coord) {
        if (this.tankType == TankType.FLUID_TANK) {
            IExtendedFluidTank fluidTank = handler.getFluidTank(this.tankId, null);
            if (fluidTank != null) {
                this.handleFluidTank(player, stack, fluidTank);
            }
        } else if (this.tankType == TankType.GAS_TANK) {
            this.handleChemicalTanks(player, stack, ((IGasTracker)handler).getGasTanks(null), coord);
        } else if (this.tankType == TankType.INFUSION_TANK) {
            this.handleChemicalTanks(player, stack, ((IInfusionTracker)handler).getInfusionTanks(null), coord);
        } else if (this.tankType == TankType.PIGMENT_TANK) {
            this.handleChemicalTanks(player, stack, ((IPigmentTracker)handler).getPigmentTanks(null), coord);
        } else if (this.tankType == TankType.SLURRY_TANK) {
            this.handleChemicalTanks(player, stack, ((ISlurryTracker)handler).getSlurryTanks(null), coord);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> void handleChemicalTanks(ServerPlayer player, ItemStack stack, List<TANK> tanks, Coord4D coord) {
        if (this.tankId < tanks.size()) {
            this.handleChemicalTank(player, stack, (IChemicalTank)tanks.get(this.tankId), coord);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void handleChemicalTank(ServerPlayer player, ItemStack stack, IChemicalTank<CHEMICAL, STACK> tank, Coord4D coord) {
        if (this.action == DropperAction.DUMP_TANK) {
            if (!tank.isEmpty()) {
                if (tank instanceof IGasTank) {
                    IGasTank gasTank = (IGasTank)tank;
                    IRadiationManager.INSTANCE.dumpRadiation(coord, (GasStack)gasTank.getStack());
                }
                tank.setEmpty();
                MekanismCriteriaTriggers.USE_GAUGE_DROPPER.trigger(player, UseGaugeDropperTrigger.UseDropperAction.DUMP);
            }
        } else {
            IMekanismChemicalHandler chemicalHandler;
            Object itemTank;
            IChemicalHandler handler;
            Optional cap = stack.getCapability(ChemicalUtil.getCapabilityForChemical(tank)).resolve();
            if (cap.isPresent() && (handler = (IChemicalHandler)cap.get()) instanceof IMekanismChemicalHandler && (itemTank = (chemicalHandler = (IMekanismChemicalHandler)handler).getChemicalTank(0, null)) != null) {
                if (this.action == DropperAction.FILL_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(tank, itemTank, (Player)player);
                    MekanismCriteriaTriggers.USE_GAUGE_DROPPER.trigger(player, UseGaugeDropperTrigger.UseDropperAction.FILL);
                } else if (this.action == DropperAction.DRAIN_DROPPER) {
                    PacketDropperUse.transferBetweenTanks(itemTank, tank, (Player)player);
                    MekanismCriteriaTriggers.USE_GAUGE_DROPPER.trigger(player, UseGaugeDropperTrigger.UseDropperAction.DRAIN);
                }
            }
        }
    }

    private void handleFluidTank(ServerPlayer player, ItemStack stack, IExtendedFluidTank fluidTank) {
        IMekanismFluidHandler fluidHandler;
        IExtendedFluidTank itemFluidTank;
        IFluidHandlerItem fluidHandlerItem;
        if (this.action == DropperAction.DUMP_TANK) {
            fluidTank.setEmpty();
            MekanismCriteriaTriggers.USE_GAUGE_DROPPER.trigger(player, UseGaugeDropperTrigger.UseDropperAction.DUMP);
            return;
        }
        Optional capability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (capability.isPresent() && (fluidHandlerItem = (IFluidHandlerItem)capability.get()) instanceof IMekanismFluidHandler && (itemFluidTank = (fluidHandler = (IMekanismFluidHandler)fluidHandlerItem).getFluidTank(0, null)) != null) {
            if (this.action == DropperAction.FILL_DROPPER) {
                PacketDropperUse.transferBetweenTanks(fluidTank, itemFluidTank, (Player)player);
                MekanismCriteriaTriggers.USE_GAUGE_DROPPER.trigger(player, UseGaugeDropperTrigger.UseDropperAction.FILL);
            } else if (this.action == DropperAction.DRAIN_DROPPER) {
                PacketDropperUse.transferBetweenTanks(itemFluidTank, fluidTank, (Player)player);
                MekanismCriteriaTriggers.USE_GAUGE_DROPPER.trigger(player, UseGaugeDropperTrigger.UseDropperAction.DRAIN);
            }
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void transferBetweenTanks(IChemicalTank<CHEMICAL, STACK> drainTank, IChemicalTank<CHEMICAL, STACK> fillTank, Player player) {
        STACK extractedChemical;
        long amount;
        STACK chemicalInDrainTank;
        STACK simulatedRemainder;
        long remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0L && (remainder = ((ChemicalStack)(simulatedRemainder = fillTank.insert(chemicalInDrainTank = drainTank.getStack(), Action.SIMULATE, AutomationType.MANUAL))).getAmount()) < (amount = ((ChemicalStack)chemicalInDrainTank).getAmount()) && !((ChemicalStack)(extractedChemical = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL))).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)fillTank.insert(extractedChemical, Action.EXECUTE, AutomationType.MANUAL)).getAmount(), 0L);
            player.f_36096_.m_150445_();
        }
    }

    private static void transferBetweenTanks(IExtendedFluidTank drainTank, IExtendedFluidTank fillTank, Player player) {
        FluidStack extractedFluid;
        int amount;
        FluidStack fluidInDrainTank;
        FluidStack simulatedRemainder;
        int remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0 && (remainder = (simulatedRemainder = fillTank.insert(fluidInDrainTank = drainTank.getFluid(), Action.SIMULATE, AutomationType.MANUAL)).getAmount()) < (amount = fluidInDrainTank.getAmount()) && !(extractedFluid = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL)).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(fillTank.insert(extractedFluid, Action.EXECUTE, AutomationType.MANUAL).getAmount(), 0L);
            player.f_36096_.m_150445_();
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130068_((Enum)this.action);
        buffer.m_130068_((Enum)this.tankType);
        buffer.m_130130_(this.tankId);
    }

    public static PacketDropperUse decode(FriendlyByteBuf buffer) {
        return new PacketDropperUse(buffer.m_130135_(), (DropperAction)buffer.m_130066_(DropperAction.class), (TankType)buffer.m_130066_(TankType.class), buffer.m_130242_());
    }

    public static enum DropperAction {
        FILL_DROPPER,
        DRAIN_DROPPER,
        DUMP_TANK;

    }

    public static enum TankType {
        GAS_TANK,
        FLUID_TANK,
        INFUSION_TANK,
        PIGMENT_TANK,
        SLURRY_TANK;

    }
}

