/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade.chemical;

import java.util.List;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.providers.IGasProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.upgrade.chemical.ChemicalRecipeData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class GasRecipeData
extends ChemicalRecipeData<Gas, GasStack, IGasTank, IGasHandler> {
    public GasRecipeData(ListTag tanks) {
        super(tanks);
    }

    private GasRecipeData(List<IGasTank> tanks) {
        super(tanks);
    }

    protected GasRecipeData create(List<IGasTank> tanks) {
        return new GasRecipeData(tanks);
    }

    @Override
    protected SubstanceType getSubstanceType() {
        return SubstanceType.GAS;
    }

    @Override
    protected ChemicalTankBuilder<Gas, GasStack, IGasTank> getTankBuilder() {
        return ChemicalTankBuilder.GAS;
    }

    @Override
    protected IGasHandler getOutputHandler(final List<IGasTank> tanks) {
        return new IGasHandler.IMekanismGasHandler(){

            @Override
            @NotNull
            public List<IGasTank> getChemicalTanks(@Nullable Direction side) {
                return tanks;
            }

            @Override
            public void onContentsChanged() {
            }
        };
    }

    @Override
    protected Capability<IGasHandler> getCapability() {
        return Capabilities.GAS_HANDLER;
    }

    @Override
    protected Predicate<Gas> cloneValidator(IGasHandler handler, int tank) {
        return type -> handler.isValid(tank, new GasStack((IGasProvider)type, 1L));
    }

    @Override
    protected IGasHandler getHandlerFromTile(TileEntityMekanism tile) {
        return (IGasHandler)tile.getGasManager().getInternal();
    }
}

