/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.client.render.item.block;

import com.jerry.mekanism_extras.client.model.ExtraModelEnergyCore;
import com.jerry.mekanism_extras.client.render.tileentity.ExtraRenderEnergyCube;
import com.jerry.mekanism_extras.common.item.block.ExtraItemBlockEnergyCube;
import com.jerry.mekanism_extras.common.tier.ECTier;
import com.jerry.mekanism_extras.common.tier.TierColor;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityEnergyCube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mekanism.api.RelativeSide;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.item.MekanismISTER;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class ExtraRenderEnergyCubeItem
extends MekanismISTER {
    public static final ExtraRenderEnergyCubeItem EXTRA_RENDERER = new ExtraRenderEnergyCubeItem();
    private ExtraModelEnergyCore core;

    public void m_6213_(@NotNull ResourceManager resourceManager) {
        this.core = new ExtraModelEnergyCore(this.getEntityModels());
    }

    public void m_108829_(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight) {
        ECTier tier = ((ExtraItemBlockEnergyCube)stack.m_41720_()).getAdvanceTier();
        ExtraTileEntityEnergyCube.CubeSideState[] sideStates = new ExtraTileEntityEnergyCube.CubeSideState[EnumUtils.SIDES.length];
        CompoundTag configData = ItemDataUtils.getDataMapIfPresent((ItemStack)stack);
        if (configData != null && configData.m_128425_("componentConfig", 10)) {
            CompoundTag sideConfig = configData.m_128469_("componentConfig").m_128469_("config" + TransmissionType.ENERGY.ordinal());
            for (RelativeSide side : EnumUtils.SIDES) {
                DataType dataType = DataType.byIndexStatic((int)sideConfig.m_128451_("side" + side.ordinal()));
                ExtraTileEntityEnergyCube.CubeSideState state = ExtraTileEntityEnergyCube.CubeSideState.INACTIVE;
                if (dataType != DataType.NONE) {
                    state = dataType.canOutput() ? ExtraTileEntityEnergyCube.CubeSideState.ACTIVE_LIT : ExtraTileEntityEnergyCube.CubeSideState.ACTIVE_UNLIT;
                }
                sideStates[side.ordinal()] = state;
            }
        } else {
            for (CompoundTag side : EnumUtils.SIDES) {
                sideStates[side.ordinal()] = side == RelativeSide.FRONT ? ExtraTileEntityEnergyCube.CubeSideState.ACTIVE_LIT : ExtraTileEntityEnergyCube.CubeSideState.ACTIVE_UNLIT;
            }
        }
        ModelData modelData = ModelData.builder().with(ExtraTileEntityEnergyCube.SIDE_STATE_PROPERTY, (Object)sideStates).build();
        this.renderBlockItem(stack, displayContext, matrix, renderer, light, overlayLight, modelData);
        double energyPercentage = StorageUtils.getStoredEnergyFromNBT((ItemStack)stack).divideToLevel(tier.getMaxEnergy());
        if (energyPercentage > 0.0) {
            float ticks = (float)Minecraft.m_91087_().f_91060_.getTicks() + MekanismRenderer.getPartialTick();
            float scaledTicks = 4.0f * ticks;
            matrix.m_85836_();
            matrix.m_85837_(0.5, 0.5, 0.5);
            matrix.m_85841_(0.4f, 0.4f, 0.4f);
            matrix.m_85837_(0.0, Math.sin(Math.toRadians(3.0f * ticks)) / 7.0, 0.0);
            matrix.m_252781_(Axis.f_252436_.m_252977_(scaledTicks));
            matrix.m_252781_(ExtraRenderEnergyCube.coreVec.m_252977_(36.0f + scaledTicks));
            this.core.render(matrix, renderer, 0xF000F0, overlayLight, TierColor.getColor(tier), (float)energyPercentage);
            matrix.m_85849_();
        }
    }
}

