/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common;

import com.jerry.mekanism_extras.MekanismExtras;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.common.tags.LazyTagLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ExtraTag {
    public static void init() {
        Items.init();
        Fluids.init();
        Gases.init();
        InfuseTypes.init();
        Slurries.init();
    }

    public static class Items {
        public static final TagKey<Item> NAQUADAH = Items.forgeTag("ores/naquadah");
        public static final TagKey<Item> END_NAQUADAH = Items.forgeTag("ores/naquadah");

        private static void init() {
        }

        private Items() {
        }

        private static TagKey<Item> forgeTag(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)name));
        }
    }

    public static class Fluids {
        public static final TagKey<Fluid> NAQUADAH_TETRAFLUORIDE = Fluids.forgeTag("naquadah_tetrafluoride");
        public static final TagKey<Fluid> FLUORINATED_NAQUADAH_URANIUM_FUEL = Fluids.forgeTag("fluorinated_naquadah_uranium_fuel");
        public static final TagKey<Fluid> RICH_NAQUADAH_FUEL = Fluids.forgeTag("rich_naquadah_fuel");
        public static final TagKey<Fluid> RICH_URANIUM_FUEL = Fluids.forgeTag("rich_uranium_fuel");
        public static final TagKey<Fluid> POLONIUM_CONTAINING_SOLUTION = Fluids.forgeTag("polonium_containing_solution");
        public static final LazyTagLookup<Fluid> LAZY_POLONIUM_CONTAINING_SOLUTION = LazyTagLookup.create((IForgeRegistry)ForgeRegistries.FLUIDS, POLONIUM_CONTAINING_SOLUTION);

        private static void init() {
        }

        private Fluids() {
        }

        private static TagKey<Fluid> forgeTag(String name) {
            return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)name));
        }

        private static TagKey<Fluid> tag(String name) {
            return FluidTags.create((ResourceLocation)MekanismExtras.rl(name));
        }
    }

    public static class Gases {
        public static final TagKey<Gas> MOLTEN_THERMONUCLEAR = Gases.tag("molten_thermonuclear");
        public static final TagKey<Gas> NAQUADAH_TETRAFLUORIDE = Gases.tag("naquadah_tetrafluoride");
        public static final TagKey<Gas> FLUORINATED_NAQUADAH_URANIUM_FUEL = Gases.tag("fluorinated_naquadah_uranium_fuel");
        public static final TagKey<Gas> RICH_NAQUADAH_FUEL = Gases.tag("rich_naquadah_fuel");
        public static final LazyTagLookup<Gas> RICH_NAQUADAH_FUEL_LOOKUP = LazyTagLookup.create((ChemicalTags)ChemicalTags.GAS, RICH_NAQUADAH_FUEL);
        public static final TagKey<Gas> RICH_URANIUM_FUEL = Gases.tag("rich_uranium_fuel");
        public static final LazyTagLookup<Gas> RICH_URANIUM_FUEL_LOOKUP = LazyTagLookup.create((ChemicalTags)ChemicalTags.GAS, RICH_URANIUM_FUEL);
        public static final TagKey<Gas> NAQUADAH_URANIUM_FUEL = Gases.tag("naquadah_uranium_fuel");
        public static final LazyTagLookup<Gas> NAQUADAH_URANIUM_FUEL_LOOKUP = LazyTagLookup.create((ChemicalTags)ChemicalTags.GAS, NAQUADAH_URANIUM_FUEL);

        private static void init() {
        }

        private Gases() {
        }

        private static TagKey<Gas> tag(String name) {
            return ChemicalTags.GAS.tag(MekanismExtras.rl(name));
        }
    }

    public static class InfuseTypes {
        public static final TagKey<InfuseType> RADIANCE = InfuseTypes.tag("radiance");
        public static final TagKey<InfuseType> THERMONUCLEAR = InfuseTypes.tag("thermonuclear");
        public static final TagKey<InfuseType> SHINING = InfuseTypes.tag("shining");
        public static final TagKey<InfuseType> SPECTRUM = InfuseTypes.tag("spectrum");

        private static void init() {
        }

        private InfuseTypes() {
        }

        private static TagKey<InfuseType> tag(String name) {
            return ChemicalTags.INFUSE_TYPE.tag(MekanismExtras.rl(name));
        }
    }

    public static class Slurries {
        public static final TagKey<Slurry> DIRTY = Slurries.tag("dirty");
        public static final LazyTagLookup<Slurry> DIRTY_LOOKUP = LazyTagLookup.create((ChemicalTags)ChemicalTags.SLURRY, DIRTY);
        public static final TagKey<Slurry> CLEAN = Slurries.tag("clean");

        private static void init() {
        }

        private Slurries() {
        }

        private static TagKey<Slurry> tag(String name) {
            return ChemicalTags.SLURRY.tag(MekanismExtras.rl(name));
        }
    }
}

