/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.content.network.transmitter;

import com.jerry.mekanism_extras.common.content.network.transmitter.IExtraUpgradeableTransmitter;
import com.jerry.mekanism_extras.common.tier.transmitter.TTier;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.chemical.BoxedChemicalHandler;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.PressurizedTubeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EnumUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraBoxedPressurizedTube
extends BoxedPressurizedTube
implements IExtraUpgradeableTransmitter<PressurizedTubeUpgradeData> {
    public ExtraBoxedPressurizedTube(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(blockProvider, tile);
    }

    public void pullFromAcceptors() {
        Set connections = this.getConnections(ConnectionType.PULL);
        if (!connections.isEmpty()) {
            for (BoxedChemicalHandler connectedAcceptor : this.getAcceptorCache().getConnectedAcceptors(connections)) {
                BoxedChemicalStack bufferWithFallback = this.getBufferWithFallback();
                if (bufferWithFallback.isEmpty()) {
                    for (ChemicalType chemicalType : EnumUtils.CHEMICAL_TYPES) {
                        if (this.pullFromAcceptor(connectedAcceptor, chemicalType, bufferWithFallback, true)) break;
                    }
                    continue;
                }
                this.pullFromAcceptor(connectedAcceptor, bufferWithFallback.getChemicalType(), bufferWithFallback, false);
            }
        }
    }

    private boolean pullFromAcceptor(BoxedChemicalHandler acceptor, ChemicalType chemicalType, BoxedChemicalStack bufferWithFallback, boolean bufferIsEmpty) {
        IChemicalHandler handler = acceptor.getHandlerFor(chemicalType);
        if (handler != null) {
            return this.pullFromAcceptor(handler, bufferWithFallback, chemicalType, bufferIsEmpty);
        }
        return false;
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> boolean pullFromAcceptor(HANDLER connectedAcceptor, BoxedChemicalStack bufferWithFallback, ChemicalType chemicalType, boolean bufferIsEmpty) {
        long availablePull = this.getAvailablePull(chemicalType);
        ChemicalStack received = bufferIsEmpty ? connectedAcceptor.extractChemical(availablePull, Action.SIMULATE) : connectedAcceptor.extractChemical(ChemicalUtil.copyWithAmount((ChemicalStack)bufferWithFallback.getChemicalStack(), (long)availablePull), Action.SIMULATE);
        if (!received.isEmpty() && this.takeChemical(chemicalType, received, Action.SIMULATE).isEmpty()) {
            this.takeChemical(chemicalType, connectedAcceptor.extractChemical(received, Action.EXECUTE), Action.EXECUTE);
            return true;
        }
        return false;
    }

    private long getAvailablePull(ChemicalType chemicalType) {
        if (this.hasTransmitterNetwork()) {
            return Math.min(TTier.getTubePullAmount(this.tier), ((BoxedChemicalNetwork)this.getTransmitterNetwork()).chemicalTank.getTankForType(chemicalType).getNeeded());
        }
        return Math.min(TTier.getTubePullAmount(this.tier), this.chemicalTank.getTankForType(chemicalType).getNeeded());
    }

    public long getCapacity() {
        return TTier.getTubeCapacity(this.tier);
    }

    @NotNull
    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK takeChemical(ChemicalType type, STACK stack, Action action) {
        IChemicalTank tank = this.hasTransmitterNetwork() ? ((BoxedChemicalNetwork)this.getTransmitterNetwork()).chemicalTank.getTankForType(type) : this.chemicalTank.getTankForType(type);
        return (STACK)tank.insert(stack, action, AutomationType.INTERNAL);
    }

    @Override
    @Nullable
    public PressurizedTubeUpgradeData getUpgradeData() {
        return super.getUpgradeData();
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return super.dataTypeMatches(data);
    }

    @Override
    public void parseUpgradeData(@NotNull PressurizedTubeUpgradeData data) {
        super.parseUpgradeData(data);
    }
}

