/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.content.network.transmitter;

import com.jerry.mekanism_extras.common.content.network.transmitter.IExtraUpgradeableTransmitter;
import com.jerry.mekanism_extras.common.tier.transmitter.CTier;
import java.util.Set;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.transmitter.UniversalCable;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.upgrade.transmitter.UniversalCableUpgradeData;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraUniversalCable
extends UniversalCable
implements IExtraUpgradeableTransmitter<UniversalCableUpgradeData> {
    public ExtraUniversalCable(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(blockProvider, tile);
    }

    public void pullFromAcceptors() {
        Set connections = this.getConnections(ConnectionType.PULL);
        if (!connections.isEmpty()) {
            for (IStrictEnergyHandler connectedAcceptor : this.getAcceptorCache().getConnectedAcceptors(connections)) {
                FloatingLong received = connectedAcceptor.extractEnergy(this.getAvailablePull(), Action.SIMULATE);
                if (received.isZero() || !this.takeEnergy(received, Action.SIMULATE).isZero()) continue;
                FloatingLong remainder = this.takeEnergy(received, Action.EXECUTE);
                connectedAcceptor.extractEnergy(received.subtract(remainder), Action.EXECUTE);
            }
        }
    }

    private FloatingLong getAvailablePull() {
        if (this.hasTransmitterNetwork()) {
            return this.getCapacityAsFloatingLong().min(((EnergyNetwork)this.getTransmitterNetwork()).energyContainer.getNeeded());
        }
        return this.getCapacityAsFloatingLong().min(this.buffer.getNeeded());
    }

    @NotNull
    public FloatingLong getCapacityAsFloatingLong() {
        return CTier.getCapacityAsFloatingLong(this.tier);
    }

    public long getCapacity() {
        return this.getCapacityAsFloatingLong().longValue();
    }

    private FloatingLong takeEnergy(FloatingLong amount, Action action) {
        if (this.hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitterNetwork()).energyContainer.insert(amount, action, AutomationType.INTERNAL);
        }
        return this.buffer.insert(amount, action, AutomationType.INTERNAL);
    }

    protected void handleContentsUpdateTag(@NotNull EnergyNetwork network, @NotNull CompoundTag tag) {
        super.handleContentsUpdateTag(network, tag);
        NBTUtils.setFloatingLongIfPresent((CompoundTag)tag, (String)"energy", arg_0 -> ((VariableCapacityEnergyContainer)network.energyContainer).setEnergy(arg_0));
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale", scale -> {
            network.currentScale = scale;
        });
    }

    @Override
    @Nullable
    public UniversalCableUpgradeData getUpgradeData() {
        return super.getUpgradeData();
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return super.dataTypeMatches(data);
    }

    @Override
    public void parseUpgradeData(@NotNull UniversalCableUpgradeData data) {
        super.parseUpgradeData(data);
    }
}

