/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.item.block;

import com.jerry.mekanism_extras.api.tier.IAdvancedTier;
import com.jerry.mekanism_extras.common.config.LoadConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mekanism.api.AutomationType;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.capabilities.security.item.ItemStackSecurityObject;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockMekExtra<BLOCK extends Block>
extends BlockItem {
    @NotNull
    private final BLOCK block;

    public ItemBlockMekExtra(@NotNull BLOCK block, Item.Properties properties) {
        super(block, properties);
        this.block = block;
    }

    @NotNull
    public BLOCK m_40614_() {
        return this.block;
    }

    public IAdvancedTier getAdvanceTier() {
        return null;
    }

    public TextColor getTextColor(ItemStack stack) {
        IAdvancedTier tier = this.getAdvanceTier();
        return tier == null ? null : tier.getAdvanceTier().getColor();
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        TextColor color = this.getTextColor(stack);
        if (color == null) {
            return super.m_7626_(stack);
        }
        return TextComponentUtil.build((Object[])new Object[]{color, super.m_7626_(stack)});
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (this.exposesEnergyCap(oldStack) && this.exposesEnergyCap(newStack)) {
            return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (this.exposesEnergyCap(oldStack) && this.exposesEnergyCap(newStack)) {
            return oldStack.m_41720_() != newStack.m_41720_();
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        if (Attribute.has(this.block, Attributes.AttributeSecurity.class)) {
            capabilities.add((ItemCapabilityWrapper.ItemCapability)new ItemStackSecurityObject());
        }
        if (this.exposesEnergyCap(stack)) {
            AttributeEnergy attributeEnergy = (AttributeEnergy)Attribute.get(this.block, AttributeEnergy.class);
            FloatingLongSupplier maxEnergy = Attribute.matches(this.block, AttributeUpgradeSupport.class, attribute -> attribute.supportedUpgrades().contains(Upgrade.ENERGY)) ? new UpgradeBasedFloatingLongCache(stack, () -> ((AttributeEnergy)attributeEnergy).getStorage()) : () -> ((AttributeEnergy)attributeEnergy).getStorage();
            capabilities.add((ItemCapabilityWrapper.ItemCapability)RateLimitEnergyHandler.create((FloatingLongSupplier)maxEnergy, (Predicate)BasicEnergyContainer.manualOnly, this.getEnergyCapInsertPredicate()));
        }
    }

    protected Predicate<@NotNull AutomationType> getEnergyCapInsertPredicate() {
        return BasicEnergyContainer.alwaysTrue;
    }

    protected boolean exposesEnergyCap(ItemStack stack) {
        return Attribute.has(this.block, AttributeEnergy.class);
    }

    protected boolean areCapabilityConfigsLoaded(ItemStack stack) {
        if (this.exposesEnergyCap(stack)) {
            return LoadConfig.extraStorage.isLoaded() && LoadConfig.extraConfig.isLoaded();
        }
        return true;
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!this.areCapabilityConfigsLoaded(stack)) {
            return super.initCapabilities(stack, nbt);
        }
        ArrayList<ItemCapabilityWrapper.ItemCapability> capabilities = new ArrayList<ItemCapabilityWrapper.ItemCapability>();
        this.gatherCapabilities(capabilities, stack, nbt);
        if (capabilities.isEmpty()) {
            return super.initCapabilities(stack, nbt);
        }
        return new ItemCapabilityWrapper(stack, (ItemCapabilityWrapper.ItemCapability[])capabilities.toArray(ItemCapabilityWrapper.ItemCapability[]::new));
    }

    private static class UpgradeBasedFloatingLongCache
    implements FloatingLongSupplier {
        private final ItemStack stack;
        private final FloatingLongSupplier baseStorage;
        @Nullable
        private CompoundTag lastNBT;
        private FloatingLong value;

        private UpgradeBasedFloatingLongCache(ItemStack stack, FloatingLongSupplier baseStorage) {
            this.stack = stack;
            this.lastNBT = ItemDataUtils.hasData((ItemStack)stack, (String)"componentUpgrade", (int)10) ? ItemDataUtils.getCompound((ItemStack)stack, (String)"componentUpgrade").m_6426_() : null;
            this.baseStorage = baseStorage;
            this.value = MekanismUtils.getMaxEnergy((ItemStack)this.stack, (FloatingLong)this.baseStorage.get());
        }

        @NotNull
        public FloatingLong get() {
            if (ItemDataUtils.hasData((ItemStack)this.stack, (String)"componentUpgrade", (int)10)) {
                CompoundTag upgrades = ItemDataUtils.getCompound((ItemStack)this.stack, (String)"componentUpgrade");
                if (this.lastNBT == null || !this.lastNBT.equals((Object)upgrades)) {
                    this.lastNBT = upgrades.m_6426_();
                    this.value = MekanismUtils.getMaxEnergy((ItemStack)this.stack, (FloatingLong)this.baseStorage.get());
                }
            } else if (this.lastNBT != null) {
                this.lastNBT = null;
                this.value = MekanismUtils.getMaxEnergy((ItemStack)this.stack, (FloatingLong)this.baseStorage.get());
            }
            return this.value;
        }
    }
}

