/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.registry;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekanism_extras.api.ExtraUpgrade;
import com.jerry.mekanism_extras.common.block.attribute.ExtraAttributeTier;
import com.jerry.mekanism_extras.common.block.attribute.ExtraAttributeUpgradeable;
import com.jerry.mekanism_extras.common.config.LoadConfig;
import com.jerry.mekanism_extras.common.content.blocktype.AdvancedFactory;
import com.jerry.mekanism_extras.common.content.blocktype.AdvancedMachine;
import com.jerry.mekanism_extras.common.integration.Addons;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.registry.ExtraContainerTypes;
import com.jerry.mekanism_extras.common.registry.ExtraTileEntityTypes;
import com.jerry.mekanism_extras.common.tier.AdvancedFactoryTier;
import com.jerry.mekanism_extras.common.tier.BTier;
import com.jerry.mekanism_extras.common.tier.CTTier;
import com.jerry.mekanism_extras.common.tier.ECTier;
import com.jerry.mekanism_extras.common.tier.FTTier;
import com.jerry.mekanism_extras.common.tier.ICTier;
import com.jerry.mekanism_extras.common.tier.IPTier;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityBin;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityChemicalTank;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityEnergyCube;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityFluidTank;
import com.jerry.mekanism_extras.common.tile.ExtraTileEntityRadioactiveWasteBarrel;
import com.jerry.mekanism_extras.common.tile.machine.TileEntityAdvancedElectricPump;
import com.jerry.mekanism_extras.common.tile.multiblock.ExtraTileEntityInductionCell;
import com.jerry.mekanism_extras.common.tile.multiblock.ExtraTileEntityInductionProvider;
import com.jerry.mekanism_extras.common.tile.multiblock.TileEntityReinforcedInductionCasing;
import com.jerry.mekanism_extras.common.tile.multiblock.TileEntityReinforcedInductionPort;
import com.jerry.mekanism_extras.common.util.ExtraEnumUtils;
import com.jerry.mekanism_extras.common.util.ExtraFloatingLong;
import fr.iglee42.evolvedmekanism.registries.EMFactoryType;
import java.util.EnumSet;
import java.util.function.Supplier;
import mekanism.api.Upgrade;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.ILangEntry;
import mekanism.api.tier.ITier;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeParticleFX;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.blocktype.BlockShapes;
import mekanism.common.content.blocktype.BlockTypeTile;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.machine.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.machine.TileEntityCombiner;
import mekanism.common.tile.machine.TileEntityCrusher;
import mekanism.common.tile.machine.TileEntityEnergizedSmelter;
import mekanism.common.tile.machine.TileEntityEnrichmentChamber;
import mekanism.common.tile.machine.TileEntityMetallurgicInfuser;
import mekanism.common.tile.machine.TileEntityOsmiumCompressor;
import mekanism.common.tile.machine.TileEntityPrecisionSawmill;
import mekanism.common.tile.machine.TileEntityPurificationChamber;
import mekanism.common.util.EnumUtils;

public class ExtraBlockType {
    private static final Table<AdvancedFactoryTier, FactoryType, AdvancedFactory<?>> FACTORIES = HashBasedTable.create();
    public static final AdvancedMachine.AdvancedFactoryMachine<TileEntityEnrichmentChamber> ENRICHMENT_CHAMBER = (AdvancedMachine.AdvancedFactoryMachine)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)AdvancedMachine.AdvancedMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.ENRICHMENT_CHAMBER, MekanismLang.DESCRIPTION_ENRICHMENT_CHAMBER, FactoryType.ENRICHING).withGui(() -> MekanismContainerTypes.ENRICHMENT_CHAMBER)).withSound(MekanismSounds.ENRICHMENT_CHAMBER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.enrichmentChamber, (FloatingLongSupplier)MekanismConfig.storage.enrichmentChamber)).withComputerSupport("enrichmentChamber")).build();
    public static final AdvancedMachine.AdvancedFactoryMachine<TileEntityCrusher> CRUSHER = (AdvancedMachine.AdvancedFactoryMachine)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)AdvancedMachine.AdvancedMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CRUSHER, MekanismLang.DESCRIPTION_CRUSHER, FactoryType.CRUSHING).withGui(() -> MekanismContainerTypes.CRUSHER)).withSound(MekanismSounds.CRUSHER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.crusher, (FloatingLongSupplier)MekanismConfig.storage.crusher)).withComputerSupport("crusher")).build();
    public static final AdvancedMachine.AdvancedFactoryMachine<TileEntityEnergizedSmelter> ENERGIZED_SMELTER = (AdvancedMachine.AdvancedFactoryMachine)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)AdvancedMachine.AdvancedMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.ENERGIZED_SMELTER, MekanismLang.DESCRIPTION_ENERGIZED_SMELTER, FactoryType.SMELTING).withGui(() -> MekanismContainerTypes.ENERGIZED_SMELTER)).withSound(MekanismSounds.ENERGIZED_SMELTER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.energizedSmelter, (FloatingLongSupplier)MekanismConfig.storage.energizedSmelter)).withComputerSupport("energizedSmelter")).build();
    public static final AdvancedMachine.AdvancedFactoryMachine<TileEntityPrecisionSawmill> PRECISION_SAWMILL = (AdvancedMachine.AdvancedFactoryMachine)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)AdvancedMachine.AdvancedMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.PRECISION_SAWMILL, MekanismLang.DESCRIPTION_PRECISION_SAWMILL, FactoryType.SAWING).withGui(() -> MekanismContainerTypes.PRECISION_SAWMILL)).withSound(MekanismSounds.PRECISION_SAWMILL)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.precisionSawmill, (FloatingLongSupplier)MekanismConfig.storage.precisionSawmill)).withComputerSupport("precisionSawmill")).build();
    public static final AdvancedMachine.AdvancedFactoryMachine<TileEntityOsmiumCompressor> OSMIUM_COMPRESSOR = (AdvancedMachine.AdvancedFactoryMachine)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)AdvancedMachine.AdvancedMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.OSMIUM_COMPRESSOR, MekanismLang.DESCRIPTION_OSMIUM_COMPRESSOR, FactoryType.COMPRESSING).withGui(() -> MekanismContainerTypes.OSMIUM_COMPRESSOR)).withSound(MekanismSounds.OSMIUM_COMPRESSOR)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.osmiumCompressor, (FloatingLongSupplier)MekanismConfig.storage.osmiumCompressor)).withComputerSupport("osmiumCompressor")).build();
    public static final AdvancedMachine.AdvancedFactoryMachine<TileEntityCombiner> COMBINER = (AdvancedMachine.AdvancedFactoryMachine)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)AdvancedMachine.AdvancedMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.COMBINER, MekanismLang.DESCRIPTION_COMBINER, FactoryType.COMBINING).withGui(() -> MekanismContainerTypes.COMBINER)).withSound(MekanismSounds.COMBINER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.combiner, (FloatingLongSupplier)MekanismConfig.storage.combiner)).withComputerSupport("combiner")).build();
    public static final AdvancedMachine.AdvancedFactoryMachine<TileEntityMetallurgicInfuser> METALLURGIC_INFUSER = (AdvancedMachine.AdvancedFactoryMachine)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)AdvancedMachine.AdvancedMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.METALLURGIC_INFUSER, MekanismLang.DESCRIPTION_METALLURGIC_INFUSER, FactoryType.INFUSING).withGui(() -> MekanismContainerTypes.METALLURGIC_INFUSER)).withSound(MekanismSounds.METALLURGIC_INFUSER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.metallurgicInfuser, (FloatingLongSupplier)MekanismConfig.storage.metallurgicInfuser)).withCustomShape(BlockShapes.METALLURGIC_INFUSER)).withComputerSupport("metallurgicInfuser")).build();
    public static final AdvancedMachine.AdvancedFactoryMachine<TileEntityPurificationChamber> PURIFICATION_CHAMBER = (AdvancedMachine.AdvancedFactoryMachine)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)AdvancedMachine.AdvancedMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.PURIFICATION_CHAMBER, MekanismLang.DESCRIPTION_PURIFICATION_CHAMBER, FactoryType.PURIFYING).withGui(() -> MekanismContainerTypes.PURIFICATION_CHAMBER)).withSound(MekanismSounds.PURIFICATION_CHAMBER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.purificationChamber, (FloatingLongSupplier)MekanismConfig.storage.purificationChamber)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.MUFFLING, Upgrade.GAS))).withComputerSupport("purificationChamber")).build();
    public static final AdvancedMachine.AdvancedFactoryMachine<TileEntityChemicalInjectionChamber> CHEMICAL_INJECTION_CHAMBER = (AdvancedMachine.AdvancedFactoryMachine)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)((AdvancedMachine.AdvancedMachineBuilder)AdvancedMachine.AdvancedMachineBuilder.createAdvancedFactoryMachine(() -> MekanismTileEntityTypes.CHEMICAL_INJECTION_CHAMBER, MekanismLang.DESCRIPTION_CHEMICAL_INJECTION_CHAMBER, FactoryType.INJECTING).withGui(() -> MekanismContainerTypes.CHEMICAL_INJECTION_CHAMBER)).withSound(MekanismSounds.CHEMICAL_INJECTION_CHAMBER)).withEnergyConfig((FloatingLongSupplier)MekanismConfig.usage.chemicalInjectionChamber, (FloatingLongSupplier)MekanismConfig.storage.chemicalInjectionChamber)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.MUFFLING, Upgrade.GAS))).withComputerSupport("chemicalInjectionChamber")).build();
    public static final BlockTypeTile<ExtraTileEntityRadioactiveWasteBarrel> EXPAND_RADIOACTIVE_WASTE_BARREL = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> ExtraTileEntityTypes.EXPAND_RADIOACTIVE_WASTE_BARREL, (ILangEntry)MekanismLang.DESCRIPTION_RADIOACTIVE_WASTE_BARREL).with(new Attribute[]{Attributes.ACTIVE_LIGHT, new AttributeStateFacing(), Attributes.COMPARATOR})).withCustomShape(BlockShapes.RADIOACTIVE_WASTE_BARREL)).withComputerSupport("radioactiveWasteBarrel")).build();
    public static final BlockTypeTile<TileEntityReinforcedInductionCasing> REINFORCED_INDUCTION_CASING = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> ExtraTileEntityTypes.REINFORCED_INDUCTION_CASING, (ILangEntry)MekanismLang.DESCRIPTION_INDUCTION_CASING).withGui(() -> ExtraContainerTypes.REINFORCED_INDUCTION_MATRIX, (ILangEntry)MekanismLang.MATRIX).with(new Attribute[]{Attributes.INVENTORY, Attributes.COMPARATOR})).externalMultiblock()).build();
    public static final BlockTypeTile<TileEntityReinforcedInductionPort> REINFORCED_INDUCTION_PORT = (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(() -> ExtraTileEntityTypes.REINFORCED_INDUCTION_PORT, (ILangEntry)MekanismLang.DESCRIPTION_INDUCTION_PORT).withGui(() -> ExtraContainerTypes.REINFORCED_INDUCTION_MATRIX, (ILangEntry)MekanismLang.MATRIX).with(new Attribute[]{Attributes.INVENTORY, Attributes.COMPARATOR, Attributes.ACTIVE})).externalMultiblock()).withComputerSupport("reinforcedInductionPort")).build();
    public static final Machine<ExtraTileEntityBin> ABSOLUTE_BIN = ExtraBlockType.createBin(BTier.ABSOLUTE, () -> ExtraTileEntityTypes.ABSOLUTE_BIN, () -> ExtraBlock.SUPREME_BIN);
    public static final Machine<ExtraTileEntityBin> SUPREME_BIN = ExtraBlockType.createBin(BTier.SUPREME, () -> ExtraTileEntityTypes.SUPREME_BIN, () -> ExtraBlock.COSMIC_BIN);
    public static final Machine<ExtraTileEntityBin> COSMIC_BIN = ExtraBlockType.createBin(BTier.COSMIC, () -> ExtraTileEntityTypes.COSMIC_BIN, () -> ExtraBlock.INFINITE_BIN);
    public static final Machine<ExtraTileEntityBin> INFINITE_BIN = ExtraBlockType.createBin(BTier.INFINITE, () -> ExtraTileEntityTypes.INFINITE_BIN, null);
    public static final BlockTypeTile<ExtraTileEntityInductionCell> ABSOLUTE_INDUCTION_CELL = ExtraBlockType.createInductionCell(ICTier.ABSOLUTE, () -> ExtraTileEntityTypes.ABSOLUTE_INDUCTION_CELL);
    public static final BlockTypeTile<ExtraTileEntityInductionCell> SUPREME_INDUCTION_CELL = ExtraBlockType.createInductionCell(ICTier.SUPREME, () -> ExtraTileEntityTypes.SUPREME_INDUCTION_CELL);
    public static final BlockTypeTile<ExtraTileEntityInductionCell> COSMIC_INDUCTION_CELL = ExtraBlockType.createInductionCell(ICTier.COSMIC, () -> ExtraTileEntityTypes.COSMIC_INDUCTION_CELL);
    public static final BlockTypeTile<ExtraTileEntityInductionCell> INFINITE_INDUCTION_CELL = ExtraBlockType.createInductionCell(ICTier.INFINITE, () -> ExtraTileEntityTypes.INFINITE_INDUCTION_CELL);
    public static final BlockTypeTile<ExtraTileEntityInductionProvider> ABSOLUTE_INDUCTION_PROVIDER = ExtraBlockType.createInductionProvider(IPTier.ABSOLUTE, () -> ExtraTileEntityTypes.ABSOLUTE_INDUCTION_PROVIDER);
    public static final BlockTypeTile<ExtraTileEntityInductionProvider> SUPREME_INDUCTION_PROVIDER = ExtraBlockType.createInductionProvider(IPTier.SUPREME, () -> ExtraTileEntityTypes.SUPREME_INDUCTION_PROVIDER);
    public static final BlockTypeTile<ExtraTileEntityInductionProvider> COSMIC_INDUCTION_PROVIDER = ExtraBlockType.createInductionProvider(IPTier.COSMIC, () -> ExtraTileEntityTypes.COSMIC_INDUCTION_PROVIDER);
    public static final BlockTypeTile<ExtraTileEntityInductionProvider> INFINITE_INDUCTION_PROVIDER = ExtraBlockType.createInductionProvider(IPTier.INFINITE, () -> ExtraTileEntityTypes.INFINITE_INDUCTION_PROVIDER);
    public static final Machine<ExtraTileEntityFluidTank> ABSOLUTE_FLUID_TANK = ExtraBlockType.createFluidTank(FTTier.ABSOLUTE, () -> ExtraTileEntityTypes.ABSOLUTE_FLUID_TANK, () -> ExtraBlock.SUPREME_FLUID_TANK);
    public static final Machine<ExtraTileEntityFluidTank> SUPREME_FLUID_TANK = ExtraBlockType.createFluidTank(FTTier.SUPREME, () -> ExtraTileEntityTypes.SUPREME_FLUID_TANK, () -> ExtraBlock.COSMIC_FLUID_TANK);
    public static final Machine<ExtraTileEntityFluidTank> COSMIC_FLUID_TANK = ExtraBlockType.createFluidTank(FTTier.COSMIC, () -> ExtraTileEntityTypes.COSMIC_FLUID_TANK, () -> ExtraBlock.INFINITE_FLUID_TANK);
    public static final Machine<ExtraTileEntityFluidTank> INFINITE_FLUID_TANK = ExtraBlockType.createFluidTank(FTTier.INFINITE, () -> ExtraTileEntityTypes.INFINITE_FLUID_TANK, null);
    public static final Machine<ExtraTileEntityEnergyCube> ABSOLUTE_ENERGY_CUBE = ExtraBlockType.createEnergyCube(ECTier.ABSOLUTE, () -> ExtraTileEntityTypes.ABSOLUTE_ENERGY_CUBE, () -> ExtraBlock.SUPREME_ENERGY_CUBE);
    public static final Machine<ExtraTileEntityEnergyCube> SUPREME_ENERGY_CUBE = ExtraBlockType.createEnergyCube(ECTier.SUPREME, () -> ExtraTileEntityTypes.SUPREME_ENERGY_CUBE, () -> ExtraBlock.COSMIC_ENERGY_CUBE);
    public static final Machine<ExtraTileEntityEnergyCube> COSMIC_ENERGY_CUBE = ExtraBlockType.createEnergyCube(ECTier.COSMIC, () -> ExtraTileEntityTypes.COSMIC_ENERGY_CUBE, () -> ExtraBlock.INFINITE_ENERGY_CUBE);
    public static final Machine<ExtraTileEntityEnergyCube> INFINITE_ENERGY_CUBE = ExtraBlockType.createEnergyCube(ECTier.INFINITE, () -> ExtraTileEntityTypes.INFINITE_ENERGY_CUBE, null);
    public static final Machine<ExtraTileEntityChemicalTank> ABSOLUTE_CHEMICAL_TANK = ExtraBlockType.createChemicalTank(CTTier.ABSOLUTE, () -> ExtraTileEntityTypes.ABSOLUTE_CHEMICAL_TANK, () -> ExtraBlock.SUPREME_CHEMICAL_TANK);
    public static final Machine<ExtraTileEntityChemicalTank> SUPREME_CHEMICAL_TANK = ExtraBlockType.createChemicalTank(CTTier.SUPREME, () -> ExtraTileEntityTypes.SUPREME_CHEMICAL_TANK, () -> ExtraBlock.COSMIC_CHEMICAL_TANK);
    public static final Machine<ExtraTileEntityChemicalTank> COSMIC_CHEMICAL_TANK = ExtraBlockType.createChemicalTank(CTTier.COSMIC, () -> ExtraTileEntityTypes.COSMIC_CHEMICAL_TANK, () -> ExtraBlock.INFINITE_CHEMICAL_TANK);
    public static final Machine<ExtraTileEntityChemicalTank> INFINITE_CHEMICAL_TANK = ExtraBlockType.createChemicalTank(CTTier.INFINITE, () -> ExtraTileEntityTypes.INFINITE_CHEMICAL_TANK, null);
    public static final Machine<TileEntityAdvancedElectricPump> ADVANCED_ELECTRIC_PUMP = (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(() -> ExtraTileEntityTypes.ADVANCED_ELECTRIC_PUMP, (MekanismLang)MekanismLang.DESCRIPTION_ELECTRIC_PUMP).withGui(() -> ExtraContainerTypes.ADVANCED_ELECTRIC_PUMP)).withEnergyConfig((FloatingLongSupplier)LoadConfig.extraUsage.advanceElectricPump, (FloatingLongSupplier)LoadConfig.extraStorage.advanceElectricPump)).withSupportedUpgrades(EnumSet.of(Upgrade.SPEED, Upgrade.ENERGY, Upgrade.FILTER, ExtraUpgrade.IONIC_MEMBRANE))).withCustomShape(BlockShapes.ELECTRIC_PUMP)).withComputerSupport("advancedElectricPump")).replace(new Attribute[]{Attributes.ACTIVE})).build();

    public static AdvancedFactory<?> getAdvancedFactory(AdvancedFactoryTier tier, FactoryType type) {
        return (AdvancedFactory)((Object)FACTORIES.get((Object)tier, (Object)type));
    }

    private static <TILE extends ExtraTileEntityInductionCell> BlockTypeTile<TILE> createInductionCell(ICTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile) {
        return (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(tile, (ILangEntry)MekanismLang.DESCRIPTION_INDUCTION_CELL).withEnergyConfig(tier::getMaxEnergy).with(new Attribute[]{new AttributeTier((ITier)tier)})).internalMultiblock()).build();
    }

    private static <TILE extends ExtraTileEntityInductionProvider> BlockTypeTile<TILE> createInductionProvider(IPTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile) {
        return (BlockTypeTile)((BlockTypeTile.BlockTileBuilder)((BlockTypeTile.BlockTileBuilder)BlockTypeTile.BlockTileBuilder.createBlock(tile, (ILangEntry)MekanismLang.DESCRIPTION_INDUCTION_PROVIDER).with(new Attribute[]{new AttributeTier((ITier)tier)})).internalMultiblock()).build();
    }

    private static <TILE extends ExtraTileEntityBin> Machine<TILE> createBin(BTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile, Supplier<BlockRegistryObject<?, ?>> upgradeBlock) {
        return (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(tile, (MekanismLang)MekanismLang.DESCRIPTION_BIN).with(new Attribute[]{new ExtraAttributeTier<BTier>(tier), new ExtraAttributeUpgradeable(upgradeBlock)})).without(new Class[]{AttributeParticleFX.class, Attributes.AttributeSecurity.class, AttributeUpgradeSupport.class, Attributes.AttributeRedstone.class})).withComputerSupport(tier.getAdvanceTier().getLowerName() + "Bin")).build();
    }

    private static <TILE extends ExtraTileEntityFluidTank> Machine<TILE> createFluidTank(FTTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile, Supplier<BlockRegistryObject<?, ?>> upgradeBlock) {
        return (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(tile, (MekanismLang)MekanismLang.DESCRIPTION_FLUID_TANK).withGui(() -> ExtraContainerTypes.FLUID_TANK)).withCustomShape(BlockShapes.FLUID_TANK)).with(new Attribute[]{new ExtraAttributeTier<FTTier>(tier), new ExtraAttributeUpgradeable(upgradeBlock)})).without(new Class[]{AttributeParticleFX.class, AttributeStateFacing.class, Attributes.AttributeRedstone.class, AttributeUpgradeSupport.class})).withComputerSupport(tier.getAdvanceTier().getLowerName() + "FluidTank")).build();
    }

    private static <TILE extends ExtraTileEntityEnergyCube> Machine<TILE> createEnergyCube(ECTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile, Supplier<BlockRegistryObject<?, ?>> upgradeBlock) {
        return (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(tile, (MekanismLang)MekanismLang.DESCRIPTION_ENERGY_CUBE).withGui(() -> ExtraContainerTypes.ENERGY_CUBE)).withEnergyConfig((FloatingLongSupplier)new ExtraFloatingLong(tier.getMaxEnergy()))).with(new Attribute[]{new ExtraAttributeTier<ECTier>(tier), new ExtraAttributeUpgradeable(upgradeBlock)})).without(new Class[]{AttributeParticleFX.class, AttributeStateActive.class, AttributeUpgradeSupport.class})).withComputerSupport(tier.getAdvanceTier().getLowerName() + "EnergyCube")).build();
    }

    private static <TILE extends ExtraTileEntityChemicalTank> Machine<TILE> createChemicalTank(CTTier tier, Supplier<TileEntityTypeRegistryObject<TILE>> tile, Supplier<BlockRegistryObject<?, ?>> upgradeBlock) {
        return (Machine)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)((Machine.MachineBuilder)Machine.MachineBuilder.createMachine(tile, (MekanismLang)MekanismLang.DESCRIPTION_CHEMICAL_TANK).withGui(() -> ExtraContainerTypes.CHEMICAL_TANK)).withCustomShape(BlockShapes.CHEMICAL_TANK)).with(new Attribute[]{new ExtraAttributeTier<CTTier>(tier), new ExtraAttributeUpgradeable(upgradeBlock)})).without(new Class[]{AttributeParticleFX.class, AttributeStateActive.class, AttributeUpgradeSupport.class})).withComputerSupport(tier.getAdvanceTier().getLowerName() + "ChemicalTank")).build();
    }

    static {
        for (AdvancedFactoryTier tier : ExtraEnumUtils.ADVANCED_FACTORY_TIERS) {
            for (FactoryType type : EnumUtils.FACTORY_TYPES) {
                if (Addons.EVOLVEDMEKANISM.isLoaded()) {
                    if (type == EMFactoryType.ALLOYING) continue;
                    FACTORIES.put((Object)tier, (Object)type, (Object)((AdvancedFactory)AdvancedFactory.AdvancedFactoryBuilder.createFactory(() -> ExtraTileEntityTypes.getAdvancedFactoryTile(tier, type), type, tier).build()));
                    continue;
                }
                FACTORIES.put((Object)tier, (Object)type, (Object)((AdvancedFactory)AdvancedFactory.AdvancedFactoryBuilder.createFactory(() -> ExtraTileEntityTypes.getAdvancedFactoryTile(tier, type), type, tier).build()));
            }
        }
    }
}

