/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tier;

import mekanism.api.math.FloatingLong;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedFloatingLongValue;
import org.jetbrains.annotations.Nullable;

public enum ICTier implements ITier
{
    ABSOLUTE(BaseTier.BASIC, FloatingLong.createConst((long)32768000000000L)),
    SUPREME(BaseTier.ADVANCED, FloatingLong.createConst((long)262144000000000L)),
    COSMIC(BaseTier.ELITE, FloatingLong.createConst((long)2097152000000000L)),
    INFINITE(BaseTier.ULTIMATE, FloatingLong.createConst((long)Long.MAX_VALUE));

    private final FloatingLong baseMaxEnergy;
    private final BaseTier baseTier;
    @Nullable
    private CachedFloatingLongValue storageReference;

    private ICTier(BaseTier tier, FloatingLong max) {
        this.baseMaxEnergy = max;
        this.baseTier = tier;
    }

    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public FloatingLong getMaxEnergy() {
        return this.storageReference == null ? this.getBaseMaxEnergy() : (FloatingLong)this.storageReference.getOrDefault();
    }

    public FloatingLong getBaseMaxEnergy() {
        return this.baseMaxEnergy;
    }

    public void setConfigReference(CachedFloatingLongValue storageReference) {
        this.storageReference = storageReference;
    }
}

