/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile.transmitter;

import com.jerry.mekanism_extras.api.tier.AdvancedTier;
import com.jerry.mekanism_extras.common.content.network.transmitter.ExtraBoxedPressurizedTube;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityTransmitter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.radiation.IRadiationManager;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.DynamicHandler;
import mekanism.common.capabilities.chemical.dynamic.DynamicChemicalHandler;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.ChemicalHandlerManager;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.interfaces.ITileRadioactive;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraTileEntityPressurizedTube
extends ExtraTileEntityTransmitter
implements IComputerTile,
ITileRadioactive {
    private static final Collection<Capability<?>> CAPABILITIES = Set.of(Capabilities.GAS_HANDLER, Capabilities.INFUSION_HANDLER, Capabilities.PIGMENT_HANDLER, Capabilities.SLURRY_HANDLER);
    private final ChemicalHandlerManager.GasHandlerManager gasHandlerManager;
    private final ChemicalHandlerManager.InfusionHandlerManager infusionHandlerManager;
    private final ChemicalHandlerManager.PigmentHandlerManager pigmentHandlerManager;
    private final ChemicalHandlerManager.SlurryHandlerManager slurryHandlerManager;

    public ExtraTileEntityPressurizedTube(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        DynamicHandler.InteractPredicate canExtract = this.getExtractPredicate();
        DynamicHandler.InteractPredicate canInsert = this.getInsertPredicate();
        this.gasHandlerManager = new ChemicalHandlerManager.GasHandlerManager(this.getHolder(BoxedPressurizedTube::getGasTanks), (IGasHandler.ISidedGasHandler)new DynamicChemicalHandler.DynamicGasHandler(this::getGasTanks, canExtract, canInsert, null));
        this.addCapabilityResolver((ICapabilityResolver)this.gasHandlerManager);
        this.infusionHandlerManager = new ChemicalHandlerManager.InfusionHandlerManager(this.getHolder(BoxedPressurizedTube::getInfusionTanks), (IInfusionHandler.ISidedInfusionHandler)new DynamicChemicalHandler.DynamicInfusionHandler(this::getInfusionTanks, canExtract, canInsert, null));
        this.addCapabilityResolver((ICapabilityResolver)this.infusionHandlerManager);
        this.pigmentHandlerManager = new ChemicalHandlerManager.PigmentHandlerManager(this.getHolder(BoxedPressurizedTube::getPigmentTanks), (IPigmentHandler.ISidedPigmentHandler)new DynamicChemicalHandler.DynamicPigmentHandler(this::getPigmentTanks, canExtract, canInsert, null));
        this.addCapabilityResolver((ICapabilityResolver)this.pigmentHandlerManager);
        this.slurryHandlerManager = new ChemicalHandlerManager.SlurryHandlerManager(this.getHolder(BoxedPressurizedTube::getSlurryTanks), (ISlurryHandler.ISidedSlurryHandler)new DynamicChemicalHandler.DynamicSlurryHandler(this::getSlurryTanks, canExtract, canInsert, null));
        this.addCapabilityResolver((ICapabilityResolver)this.slurryHandlerManager);
        ComputerCapabilityHelper.addComputerCapabilities((BlockEntity)this, x$0 -> this.addCapabilityResolver((ICapabilityResolver)x$0));
    }

    protected ExtraBoxedPressurizedTube createTransmitter(IBlockProvider blockProvider) {
        return new ExtraBoxedPressurizedTube(blockProvider, this);
    }

    public ExtraBoxedPressurizedTube getTransmitter() {
        return (ExtraBoxedPressurizedTube)super.getTransmitter();
    }

    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    public TransmitterType getTransmitterType() {
        return TransmitterType.PRESSURIZED_TUBE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull AdvancedTier tier) {
        return BlockStateHelper.copyStateData((BlockState)current, switch (tier) {
            case AdvancedTier.ABSOLUTE -> ExtraBlock.ABSOLUTE_PRESSURIZED_TUBE;
            case AdvancedTier.SUPREME -> ExtraBlock.SUPREME_PRESSURIZED_TUBE;
            case AdvancedTier.COSMIC -> ExtraBlock.COSMIC_PRESSURIZED_TUBE;
            case AdvancedTier.INFINITE -> ExtraBlock.INFINITE_PRESSURIZED_TUBE;
            default -> null;
        });
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            BoxedChemicalNetwork network = (BoxedChemicalNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.m_128365_("boxedChemical", (Tag)network.lastChemical.write(new CompoundTag()));
            updateTag.m_128350_("scale", network.currentScale);
        }
        return updateTag;
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> IChemicalTankHolder<CHEMICAL, STACK, TANK> getHolder(BiFunction<ExtraBoxedPressurizedTube, Direction, List<TANK>> tankFunction) {
        return direction -> {
            ExtraBoxedPressurizedTube tube = this.getTransmitter();
            if (direction != null && tube.getConnectionTypeRaw(direction) == ConnectionType.NONE || tube.isRedstoneActivated()) {
                return Collections.emptyList();
            }
            return (List)tankFunction.apply(tube, direction);
        };
    }

    public float getRadiationScale() {
        if (IRadiationManager.INSTANCE.isRadiationEnabled()) {
            ExtraBoxedPressurizedTube tube = this.getTransmitter();
            if (this.isRemote()) {
                if (tube.hasTransmitterNetwork()) {
                    BoxedChemicalNetwork network = (BoxedChemicalNetwork)tube.getTransmitterNetwork();
                    if (!network.lastChemical.isEmpty() && !network.isTankEmpty() && network.lastChemical.getChemical().has(GasAttributes.Radiation.class)) {
                        return network.currentScale;
                    }
                }
            } else {
                IGasTank gasTank = tube.getGasTank();
                if (!gasTank.isEmpty() && ((GasStack)gasTank.getStack()).has(GasAttributes.Radiation.class)) {
                    return (float)gasTank.getStored() / (float)gasTank.getCapacity();
                }
            }
        }
        return 0.0f;
    }

    public int getRadiationParticleCount() {
        return MathUtils.clampToInt((double)(3.0f * this.getRadiationScale()));
    }

    private List<IGasTank> getGasTanks(@Nullable Direction side) {
        return this.gasHandlerManager.getContainers(side);
    }

    private List<IInfusionTank> getInfusionTanks(@Nullable Direction side) {
        return this.infusionHandlerManager.getContainers(side);
    }

    private List<IPigmentTank> getPigmentTanks(@Nullable Direction side) {
        return this.pigmentHandlerManager.getContainers(side);
    }

    private List<ISlurryTank> getSlurryTanks(@Nullable Direction side) {
        return this.slurryHandlerManager.getContainers(side);
    }

    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapabilities(CAPABILITIES, side);
            WorldUtils.notifyNeighborOfChange((Level)this.f_58857_, (Direction)side, (BlockPos)this.f_58858_);
        } else if (old == ConnectionType.NONE) {
            WorldUtils.notifyNeighborOfChange((Level)this.f_58857_, (Direction)side, (BlockPos)this.f_58858_);
        }
    }

    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilities(CAPABILITIES, EnumUtils.DIRECTIONS);
        }
    }

    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "PressurizedTube";
    }

    @ComputerMethod
    ChemicalStack<?> getBuffer() {
        return this.getTransmitter().getBufferWithFallback().getChemicalStack();
    }

    @ComputerMethod
    long getCapacity() {
        ExtraBoxedPressurizedTube tube = this.getTransmitter();
        return tube.hasTransmitterNetwork() ? ((BoxedChemicalNetwork)tube.getTransmitterNetwork()).getCapacity() : tube.getCapacity();
    }

    @ComputerMethod
    long getNeeded() {
        return this.getCapacity() - this.getBuffer().getAmount();
    }

    @ComputerMethod
    double getFilledPercentage() {
        return (double)this.getBuffer().getAmount() / (double)this.getCapacity();
    }
}

