/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.lib;

import com.jerry.mekanism_extras.lib.NBTStructureFile;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.io.IOException;
import mekanism.common.lib.math.voxel.IShape;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.IStructureValidator;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;

public class SpecificNBTStructureValidator<T extends MultiblockData>
implements IStructureValidator<T> {
    protected NBTStructureFile structureFile;
    protected Level world;
    protected MultiblockManager<T> manager;
    protected Structure structure;

    public SpecificNBTStructureValidator(String schematicFileName) throws IOException, NullPointerException {
        File schematic = new File("schematics/" + schematicFileName);
        CompoundTag structureNBT = NbtIo.m_128953_((File)schematic);
        if (schematicFileName.endsWith(".nbt")) {
            if (structureNBT != null) {
                this.structureFile = NBTStructureFile.fromNBTTag(structureNBT);
            } else {
                throw new NullPointerException();
            }
        }
    }

    public void init(Level world, MultiblockManager<T> manager, Structure structure) {
        this.world = world;
        this.manager = manager;
        this.structure = structure;
    }

    public boolean precheck() {
        return true;
    }

    public FormationProtocol.FormationResult validate(FormationProtocol<T> ctx, Long2ObjectMap<ChunkAccess> chunkMap) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < this.structureFile.size()[0]; ++x) {
            for (int y = 0; y < this.structureFile.size()[1]; ++y) {
                for (int z = 0; z < this.structureFile.size()[2]; ++z) {
                    pos.m_122178_(x, y, z);
                }
            }
        }
        return null;
    }

    public FormationProtocol.FormationResult postcheck(T structure, Long2ObjectMap<ChunkAccess> chunkMap) {
        return null;
    }

    public IShape getShape() {
        return null;
    }
}

