/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.hopper;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import owmii.powah.EnvHandler;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.hopper.EnergyHopperBlock;
import owmii.powah.config.v2.types.ChargingConfig;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;

public class EnergyHopperTile
extends AbstractEnergyStorage<ChargingConfig, EnergyHopperBlock>
implements IInventoryHolder {
    public EnergyHopperTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.ENERGY_HOPPER.get(), pos, state, variant);
    }

    public EnergyHopperTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    protected int postTick(Level world) {
        Direction side;
        BlockEntity tile;
        long extracted = 0L;
        if (!this.isRemote() && this.checkRedstone() && (tile = world.m_7702_(this.f_58858_.m_121945_(side = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)))) instanceof Container) {
            Container container = (Container)tile;
            extracted = EnvHandler.INSTANCE.chargeItemsInContainer(container, ((ChargingConfig)this.getConfig()).charging_rates.get((Tier)this.variant), this.energy.getStored());
            this.energy.consume(extracted);
        }
        return extracted > 0L ? 5 : super.postTick(world);
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return false;
    }
}

