/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.blocks;

import chanceCubes.blocks.BaseChanceBlock;
import chanceCubes.items.CCubesItems;
import chanceCubes.items.ItemChanceCube;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.tileentities.TileChanceCube;
import chanceCubes.util.GiantCubeUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.StatsRegistry;
import chanceCubes.util.Task;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class BlockChanceCube
extends BaseChanceBlock
implements EntityBlock {
    public static final EnumProperty<EnumTexture> TEXTURE = EnumProperty.m_61587_((String)"texture", EnumTexture.class);
    public static EnumTexture textureToSet = EnumTexture.DEFAULT;

    public BlockChanceCube() {
        super(BlockChanceCube.getBuilder().m_60953_(state -> ((EnumTexture)((Object)((Object)state.m_61143_(TEXTURE)))).equals((Object)EnumTexture.HALLOWEEN) ? 2 : 0));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(TEXTURE, (Comparable)((Object)EnumTexture.DEFAULT)));
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TileChanceCube(pos, state);
    }

    public void m_5707_(final @NotNull Level level, final @NotNull BlockPos pos, @NotNull BlockState state, final @NotNull Player player) {
        super.m_5707_(level, pos, state, player);
        BlockEntity be = level.m_7702_(pos);
        if (!level.m_5776_() && !(player instanceof FakePlayer) && be instanceof TileChanceCube) {
            final TileChanceCube te = (TileChanceCube)be;
            if (!player.m_150109_().m_36056_().m_41619_() && player.m_150109_().m_36056_().m_41720_().equals(CCubesItems.SILK_PENDANT.get())) {
                ItemStack stackCube = new ItemStack((ItemLike)CCubesItems.CHANCE_CUBE.get(), 1);
                ((ItemChanceCube)stackCube.m_41720_()).setChance(stackCube, te.isScanned() ? te.getChance() : -101);
                ItemEntity blockStack = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stackCube);
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                level.m_46747_(pos);
                level.m_7967_((Entity)blockStack);
                return;
            }
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            Scheduler.scheduleTask(new Task("reward_delay", 1){

                @Override
                public void callback() {
                    GlobalCCRewardRegistry.DEFAULT.triggerRandomReward((ServerLevel)level, pos, player, te.getChance());
                }
            });
            player.m_36220_(StatsRegistry.OPENED_CHANCE_CUBE);
        }
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state2, boolean p_60570_) {
        GiantCubeUtil.checkMultiBlockForm(pos, level, true);
        super.m_6807_(state, level, pos, state2, p_60570_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState iBlockState = super.m_5573_(context);
        return (BlockState)iBlockState.m_61124_(TEXTURE, (Comparable)((Object)textureToSet));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TEXTURE});
    }

    public static enum EnumTexture implements StringRepresentable
    {
        DEFAULT("default"),
        VALENTINES("valentines"),
        STPATRICKS("stpatricks"),
        HALLOWEEN("halloween"),
        HOLIDAYS("holidays"),
        EASTER("easter");

        private final String name;

        private EnumTexture(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

