/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.Icon;
import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class TabButton
extends Button
implements ITooltip {
    private Style style = Style.BOX;
    private Icon icon = null;
    private ItemStack item;
    private boolean selected;

    public TabButton(Icon ico, Component message, Button.OnPress onPress) {
        super(0, 0, 22, 22, message, onPress, Button.f_252438_);
        this.icon = ico;
    }

    public TabButton(ItemStack ico, Component message, Button.OnPress onPress) {
        super(0, 0, 22, 22, message, onPress, Button.f_252438_);
        this.item = ico;
    }

    public void m_87963_(GuiGraphics guiGraphics, int x, int y, float partial) {
        if (this.f_93624_) {
            Icon backdrop = switch (this.style) {
                default -> throw new IncompatibleClassChangeError();
                case Style.CORNER -> {
                    if (this.m_93696_()) {
                        yield Icon.TAB_BUTTON_BACKGROUND_BORDERLESS_FOCUS;
                    }
                    yield Icon.TAB_BUTTON_BACKGROUND_BORDERLESS;
                }
                case Style.BOX -> {
                    if (this.m_93696_()) {
                        yield Icon.TAB_BUTTON_BACKGROUND_FOCUS;
                    }
                    yield Icon.TAB_BUTTON_BACKGROUND;
                }
                case Style.HORIZONTAL -> this.m_93696_() ? Icon.HORIZONTAL_TAB_FOCUS : (this.selected ? Icon.HORIZONTAL_TAB_SELECTED : Icon.HORIZONTAL_TAB);
            };
            backdrop.getBlitter().dest(this.m_252754_(), this.m_252907_()).blit(guiGraphics);
            int iconX = switch (this.style) {
                default -> throw new IncompatibleClassChangeError();
                case Style.CORNER -> 4;
                case Style.BOX -> 3;
                case Style.HORIZONTAL -> 1;
            };
            int iconY = 3;
            if (this.icon != null) {
                this.icon.getBlitter().dest(this.m_252754_() + iconX, this.m_252907_() + iconY).blit(guiGraphics);
            }
            if (this.item != null) {
                PoseStack pose = guiGraphics.m_280168_();
                pose.m_85836_();
                pose.m_252880_(0.0f, 0.0f, 100.0f);
                guiGraphics.m_280480_(this.item, this.m_252754_() + iconX, this.m_252907_() + iconY);
                Font font = Minecraft.m_91087_().f_91062_;
                guiGraphics.m_280370_(font, this.item, this.m_252754_() + iconX, this.m_252907_() + iconY);
                pose.m_85849_();
            }
        }
    }

    @Override
    public List<Component> getTooltipMessage() {
        return Collections.singletonList(this.m_6035_());
    }

    @Override
    public Rect2i getTooltipArea() {
        return new Rect2i(this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.f_93624_;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public static enum Style {
        CORNER,
        BOX,
        HORIZONTAL;

    }
}

