/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.job.SpiritJobFactory;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismSpiritJobs;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public abstract class DefaultedJobEntityModel<T extends SpiritEntity>
extends DefaultedEntityGeoModel<T> {
    private final String entity_subpath;
    protected final Map<String, ModelData> jobModels;
    protected final ModelData worker;

    public DefaultedJobEntityModel(ResourceLocation assetSubpath, boolean turnsHead, String entity_subpath) {
        super(assetSubpath, turnsHead);
        this.entity_subpath = entity_subpath;
        this.jobModels = new HashMap<String, ModelData>();
        this.worker = this.buildModelData("worker");
        for (Map.Entry job : OccultismSpiritJobs.REGISTRY.get().getEntries()) {
            SpiritJobFactory factory = (SpiritJobFactory)job.getValue();
            this.jobModels.put(((ResourceKey)job.getKey()).m_135782_().toString(), this.buildModelData(factory.client().modelID(), "_"));
        }
    }

    public ModelData getModelData(T animatable) {
        String job = ((SpiritEntity)animatable).getJobID();
        ModelData model = this.jobModels.getOrDefault(job, this.worker);
        if (!GeckoLibCache.getBakedModels().containsKey(model.model())) {
            model = this.worker;
        }
        return model;
    }

    public ModelData buildModelData(String job) {
        return this.buildModelData(job, "_");
    }

    public ModelData buildModelData(ResourceLocation basePath) {
        return new ModelData(this.buildFormattedModelPath(basePath), this.buildFormattedTexturePath(basePath), this.buildFormattedAnimationPath(basePath));
    }

    public ModelData buildModelData(ResourceLocation location, String separator) {
        return this.buildModelData(new ResourceLocation(location.m_135827_(), this.entity_subpath + separator + location.m_135815_()));
    }

    public ModelData buildModelData(String job, String separator) {
        return this.buildModelData(new ResourceLocation("occultism", job), separator);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureResource(animatable));
    }

    public ResourceLocation getModelResource(T animatable) {
        return this.getModelData(animatable).model();
    }

    public ResourceLocation getTextureResource(T animatable) {
        return this.getModelData(animatable).texture();
    }

    public ResourceLocation getAnimationResource(T animatable) {
        return this.getModelData(animatable).animation();
    }

    public record ModelData(ResourceLocation model, ResourceLocation texture, ResourceLocation animation) {
    }
}

