/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit.calling;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class ExtractItemMode
extends ItemMode {
    public ExtractItemMode() {
        super("set_extract");
    }

    public boolean setSpiritExtractLocation(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent()) {
                boundSpirit.get().setExtractPosition(pos);
                boundSpirit.get().setExtractFacing(face);
                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                String blockName = world.m_8055_(pos).m_60734_().m_7705_();
                player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_extract", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), Component.m_237115_((String)blockName), face.m_7912_()}), true);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
        }
        return false;
    }

    @Override
    public boolean handle(BlockEntity blockEntity, Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        if (blockEntity != null && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, face).isPresent()) {
            return this.setSpiritExtractLocation(player, world, pos, stack, face);
        }
        return true;
    }
}

