/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe;

import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BoundBookOfBindingRecipe
extends CustomRecipe {
    public static RecipeSerializer<BoundBookOfBindingRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(BoundBookOfBindingRecipe::new);

    public BoundBookOfBindingRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer input, @NotNull Level level) {
        int i = 0;
        ItemStack dictionaryOfSpirits = ItemStack.f_41583_;
        ItemStack bookOfBinding = ItemStack.f_41583_;
        for (int j = 0; j < input.m_6643_(); ++j) {
            ItemStack inputStack = input.m_8020_(j);
            if (inputStack.m_41619_()) continue;
            if (inputStack.m_150930_((Item)OccultismItems.DICTIONARY_OF_SPIRITS.get())) {
                if (!dictionaryOfSpirits.m_41619_()) {
                    return false;
                }
                dictionaryOfSpirits = inputStack;
                continue;
            }
            if (!inputStack.m_204117_(OccultismTags.Items.BOOKS_OF_BINDING)) {
                return false;
            }
            if (!bookOfBinding.m_41619_()) {
                return false;
            }
            bookOfBinding = inputStack;
            ++i;
        }
        return !dictionaryOfSpirits.m_41619_() && !bookOfBinding.m_41619_() && i > 0;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer input, @NotNull RegistryAccess registries) {
        int i = 0;
        ItemStack dictionaryOfSpirits = ItemStack.f_41583_;
        ItemStack bookOfBinding = ItemStack.f_41583_;
        for (int j = 0; j < input.m_6643_(); ++j) {
            ItemStack inputStack = input.m_8020_(j);
            if (inputStack.m_41619_()) continue;
            if (inputStack.m_150930_((Item)OccultismItems.DICTIONARY_OF_SPIRITS.get())) {
                if (!dictionaryOfSpirits.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                dictionaryOfSpirits = inputStack;
                continue;
            }
            if (!inputStack.m_204117_(OccultismTags.Items.BOOKS_OF_BINDING)) {
                return ItemStack.f_41583_;
            }
            if (!bookOfBinding.m_41619_()) {
                return ItemStack.f_41583_;
            }
            bookOfBinding = inputStack;
            ++i;
        }
        ItemStack boundBook = BoundBookOfBindingRecipe.getBoundBookFromBook(bookOfBinding);
        if (boundBook.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (dictionaryOfSpirits.m_41788_()) {
            Component customName = dictionaryOfSpirits.m_41786_();
            ItemNBTUtil.setBoundSpiritName(boundBook, customName.getString());
        } else {
            ItemNBTUtil.generateBoundSpiritName(boundBook);
        }
        return boundBook;
    }

    public static ItemStack getBoundBookFromBook(ItemStack book) {
        if (book.m_150930_((Item)OccultismItems.BOOK_OF_BINDING_FOLIOT.get())) {
            return new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get());
        }
        if (book.m_150930_((Item)OccultismItems.BOOK_OF_BINDING_DJINNI.get())) {
            return new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get());
        }
        if (book.m_150930_((Item)OccultismItems.BOOK_OF_BINDING_AFRIT.get())) {
            return new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get());
        }
        if (book.m_150930_((Item)OccultismItems.BOOK_OF_BINDING_MARID.get())) {
            return new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get());
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)OccultismRecipes.BOOK_BINDING.get();
    }
}

