/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles;

import com.jinqinxixi.trinketsandbaubles.block.ModBlocks;
import com.jinqinxixi.trinketsandbaubles.capability.mana.ManaData;
import com.jinqinxixi.trinketsandbaubles.capability.mana.hud.ManaHudOverlay;
import com.jinqinxixi.trinketsandbaubles.capability.network.RaceCapabilityNetworking;
import com.jinqinxixi.trinketsandbaubles.client.renderer.DragonsEyeRenderer;
import com.jinqinxixi.trinketsandbaubles.compat.FirstAidCompat;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.items.ModCreativeModeTab;
import com.jinqinxixi.trinketsandbaubles.items.ModItem;
import com.jinqinxixi.trinketsandbaubles.items.baubles.ShieldofHonorItem;
import com.jinqinxixi.trinketsandbaubles.loot.LootTableHandler;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import com.jinqinxixi.trinketsandbaubles.network.handler.NetworkHandler;
import com.jinqinxixi.trinketsandbaubles.recast.AnvilRecastRegistry;
import com.jinqinxixi.trinketsandbaubles.util.ScanSystem;
import com.mojang.blaze3d.platform.Window;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import org.slf4j.Logger;

@Mod(value="trinketsandbaubles")
public class TrinketsandBaublesMod {
    public static final String MOD_ID = "trinketsandbaubles";
    public static final Logger LOGGER = LogUtils.getLogger();

    public TrinketsandBaublesMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        NetworkHandler.register();
        ModItem.register(modEventBus);
        ModCreativeModeTab.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModEffects.EFFECTS.register(modEventBus);
        modEventBus.register(ModConfig.class);
        MinecraftForge.EVENT_BUS.register(LootTableHandler.class);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register(ManaData.class);
        RaceCapabilityNetworking.init();
        this.tryRegisterFirstAidCompat();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC, "trinketsandbaubles-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)RaceAttributesConfig.SPEC, "trinketsandbaubles-races.toml");
        modEventBus.addListener(this::onConfigLoad);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(this::clientSetup);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderLevelStageEvent.class, DragonsEyeRenderer::onRenderWorld);
        }
    }

    private void tryRegisterFirstAidCompat() {
        if (FMLLoader.getLoadingModList().getModFileById("firstaid") != null) {
            try {
                Class.forName("ichttt.mods.firstaid.api.event.FirstAidLivingDamageEvent");
                MinecraftForge.EVENT_BUS.register((Object)new FirstAidCompat());
                LOGGER.info("FirstAid compatibility enabled");
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("FirstAid API classes not found, compatibility disabled");
            }
        }
    }

    private void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            ScanSystem.initializeOreGroups();
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItem.POLARIZED_STONE.get()), (ResourceLocation)new ResourceLocation(MOD_ID, "attraction_mode"), (stack, level, entity, seed) -> stack.m_41782_() && stack.m_41783_().m_128471_("AttractionMode") ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItem.POLARIZED_STONE.get()), (ResourceLocation)new ResourceLocation(MOD_ID, "deflection_mode"), (stack, level, entity, seed) -> stack.m_41782_() && stack.m_41783_().m_128471_("DeflectionMode") ? 1.0f : 0.0f);
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModConfig.loadLootConfig();
            AnvilRecastRegistry.registerAllRecipes();
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        float maxHealth;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        float currentHealth = player.m_21223_();
        if (currentHealth > (maxHealth = player.m_21233_())) {
            player.m_6469_(player.m_269291_().m_269264_(), 0.0f);
            player.m_21153_(maxHealth);
        } else if (Math.abs(currentHealth - player.m_21223_()) > 0.01f) {
            player.m_6469_(player.m_269291_().m_269264_(), 0.0f);
            player.m_21153_(currentHealth);
        }
    }

    @Mod.EventBusSubscriber(modid="trinketsandbaubles", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }

    @Mod.EventBusSubscriber(modid="trinketsandbaubles", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onMouseInput(InputEvent.MouseButton.Pre event) {
            ManaHudOverlay overlay = ManaHudOverlay.getInstance();
            if (!overlay.canDrag) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            double guiScale = window.m_85449_();
            double scaledX = minecraft.f_91067_.m_91589_() / guiScale;
            double scaledY = minecraft.f_91067_.m_91594_() / guiScale;
            if (event.getAction() == 1) {
                if (overlay.mouseClicked(scaledX, scaledY, event.getButton())) {
                    event.setCanceled(true);
                }
                if (overlay.canDrag) {
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onRenderGui(RenderGuiEvent.Post event) {
            ManaHudOverlay overlay = ManaHudOverlay.getInstance();
            if (!overlay.canDrag) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            double guiScale = window.m_85449_();
            double mouseX = minecraft.f_91067_.m_91589_() / guiScale;
            double mouseY = minecraft.f_91067_.m_91594_() / guiScale;
            overlay.mouseDragged(mouseX, mouseY);
        }
    }

    @Mod.EventBusSubscriber(modid="trinketsandbaubles")
    public static class ModEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            float newDamage = ShieldofHonorItem.onDamage(event.getEntity(), event.getSource(), event.getAmount());
            event.setAmount(newDamage);
        }
    }
}

