/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.attribute;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;

public class AttributeRegistry {
    private static final Map<String, AttributeEntry> ATTRIBUTES = new HashMap<String, AttributeEntry>();

    private static void register(String name, Attribute attribute, UUID uuid, AttributeModifier.Operation operation, boolean isPercentage, String translationKey) {
        ATTRIBUTES.put(name, new AttributeEntry(attribute, uuid, operation, isPercentage, translationKey));
    }

    public static AttributeEntry get(String name) {
        return ATTRIBUTES.get(name);
    }

    public static Map<String, AttributeEntry> getAll() {
        return ATTRIBUTES;
    }

    static {
        AttributeRegistry.register("MAX_HEALTH", Attributes.f_22276_, UUID.fromString("fff14b8c-a02c-4bd8-82e9-204088927d1f"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.max_health");
        AttributeRegistry.register("FOLLOW_RANGE", Attributes.f_22277_, UUID.fromString("fff2e342-5786-4c72-b01d-8c65525702b2"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.follow_range");
        AttributeRegistry.register("MOVEMENT_SPEED", Attributes.f_22279_, UUID.fromString("fff34065-5f43-4939-8e6a-a34f2d67c55d"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.movement_speed");
        AttributeRegistry.register("ATTACK_SPEED", Attributes.f_22283_, UUID.fromString("fff4f278-fb8f-4c75-9336-5c3ab7c6134a"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.attack_speed");
        AttributeRegistry.register("ATTACK_DAMAGE", Attributes.f_22281_, UUID.fromString("fff5ef28-51c6-4b47-8a0d-6946e841c132"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.attack_damage");
        AttributeRegistry.register("SWIM_SPEED", (Attribute)ForgeMod.SWIM_SPEED.get(), UUID.fromString("fff65a64-d1e0-4cb9-8926-dd7848482bb4"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.swim_speed");
        AttributeRegistry.register("FLYING_SPEED", Attributes.f_22280_, UUID.fromString("fff7e342-5786-4c72-b01d-8c65525702b2"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.flying_speed");
        AttributeRegistry.register("ENTITY_GRAVITY", (Attribute)ForgeMod.ENTITY_GRAVITY.get(), UUID.fromString("fff8e342-5786-4c72-b01d-8c65525702b2"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.entity_gravity");
        AttributeRegistry.register("BLOCK_REACH", (Attribute)ForgeMod.BLOCK_REACH.get(), UUID.fromString("fff93a1c-89b2-4b3e-bf8e-6d24d8c9517d"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.block_reach");
        AttributeRegistry.register("ENTITY_REACH", (Attribute)ForgeMod.ENTITY_REACH.get(), UUID.fromString("fffae342-5786-4c72-b01d-8c65525702b2"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.entity_reach");
        AttributeRegistry.register("NAMETAG_DISTANCE", (Attribute)ForgeMod.NAMETAG_DISTANCE.get(), UUID.fromString("fffb e438-8c5c-4ab2-9845-9a1e3c4a2242".replace(" ", "")), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.nametag_distance");
        AttributeRegistry.register("ARMOR", Attributes.f_22284_, UUID.fromString("fffcf246-fee1-4e67-b886-69fd380bb150"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.armor");
        AttributeRegistry.register("ARMOR_TOUGHNESS", Attributes.f_22285_, UUID.fromString("fffde73c-2cf2-4729-8128-d99f49aa37f2"), AttributeModifier.Operation.MULTIPLY_TOTAL, true, "attribute.trinketsandbaubles.armor_toughness");
        AttributeRegistry.register("KNOCKBACK_RESISTANCE", Attributes.f_22278_, UUID.fromString("95eb4f0a-dd60-4ada-98c1-2ce5c3d4374c"), AttributeModifier.Operation.ADDITION, true, "attribute.trinketsandbaubles.knockback_resistance");
        AttributeRegistry.register("ATTACK_KNOCKBACK", Attributes.f_22282_, UUID.fromString("c73e3438-8c5c-4ab2-9845-9a1e3c4a2242"), AttributeModifier.Operation.ADDITION, false, "attribute.trinketsandbaubles.attack_knockback");
        AttributeRegistry.register("LUCK", Attributes.f_22286_, UUID.fromString("4f76ff37-dd94-4dd8-95e3-3d447fafc4b1"), AttributeModifier.Operation.ADDITION, false, "attribute.trinketsandbaubles.luck");
        AttributeRegistry.register("STEP_HEIGHT", (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), UUID.fromString("e8c9a6f5-4376-4e7b-9a5c-8f2e3d91d7c4"), AttributeModifier.Operation.ADDITION, false, "attribute.trinketsandbaubles.step_height");
    }

    public static final class AttributeEntry {
        final Attribute attribute;
        final UUID uuid;
        final AttributeModifier.Operation operation;
        final boolean isPercentage;
        final String translationKey;

        public AttributeEntry(Attribute attribute, UUID uuid, AttributeModifier.Operation operation, boolean isPercentage, String translationKey) {
            this.attribute = attribute;
            this.uuid = uuid;
            this.operation = operation;
            this.isPercentage = isPercentage;
            this.translationKey = translationKey;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public AttributeModifier.Operation getOperation() {
            return this.operation;
        }

        public boolean isPercentage() {
            return this.isPercentage;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

