/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.base;

import com.jinqinxixi.trinketsandbaubles.capability.api.IBaseRaceCapability;
import com.jinqinxixi.trinketsandbaubles.capability.attribute.AttributeRegistry;
import com.jinqinxixi.trinketsandbaubles.capability.mana.ManaData;
import com.jinqinxixi.trinketsandbaubles.capability.network.RaceCapabilityNetworking;
import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.util.RaceScaleHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractRaceCapability
implements IBaseRaceCapability {
    protected boolean isActive = false;
    protected float scaleFactor = 1.0f;
    protected final Player player;
    protected int tickCounter = 0;
    protected float permanentManaDecrease = 0.0f;
    protected final Map<String, AttributeValueProvider> attributeValues = new HashMap<String, AttributeValueProvider>();

    public AbstractRaceCapability(Player player) {
        this.player = player;
    }

    protected abstract void registerAttributeValues();

    protected void registerValue(String attributeName, AttributeValueProvider provider) {
        if (attributeName == null || provider == null) {
            return;
        }
        this.attributeValues.put(attributeName, provider);
    }

    @Override
    public void applyAttributes() {
        if (!this.isActive) {
            return;
        }
        if (this.attributeValues.isEmpty()) {
            this.registerAttributeValues();
        }
        this.attributeValues.forEach((name, provider) -> {
            double value;
            AttributeRegistry.AttributeEntry entry = AttributeRegistry.get(name);
            if (entry != null && (value = provider.getValue()) != 0.0) {
                this.addAttributeModifier(this.player, entry.getAttribute(), entry.getUuid(), this.getRaceName() + " " + name, value, entry.getOperation());
            }
        });
        this.player.m_21153_(this.player.m_21223_());
    }

    @Override
    public void removeAttributes() {
        this.attributeValues.keySet().forEach(name -> {
            AttributeRegistry.AttributeEntry entry = AttributeRegistry.get(name);
            if (entry != null) {
                this.removeAttributeModifier(this.player, entry.getAttribute(), entry.getUuid());
            }
        });
        this.player.m_21153_(this.player.m_21223_());
    }

    @Override
    public void validateAndFixAttributes() {
        if (!this.isActive) {
            return;
        }
        this.attributeValues.forEach((name, provider) -> {
            double value;
            AttributeRegistry.AttributeEntry entry = AttributeRegistry.get(name);
            if (entry != null && (value = provider.getValue()) != 0.0) {
                this.validateAndFixAttribute(entry.getAttribute(), entry.getUuid(), value, this.getRaceName() + " " + name, entry.getOperation());
            }
        });
    }

    public abstract float getManaBonus();

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        if (this.isActive == active) {
            return;
        }
        if (active) {
            this.isActive = true;
            this.applyScaleFactor();
            this.applyAttributes();
            float manaBonus = this.getManaBonus();
            if (!this.player.m_9236_().f_46443_) {
                ManaData.modifyMaxMana(this.player, manaBonus);
            }
        } else {
            float manaBonus = this.getManaBonus();
            if (!this.player.m_9236_().f_46443_) {
                ManaData.modifyMaxMana(this.player, -manaBonus);
            }
            this.removeAttributes();
            this.resetScaleFactor();
            this.isActive = false;
        }
        this.sync();
    }

    public void applyEffects() {
        if (!this.isActive) {
            return;
        }
        this.applyAttributes();
        this.applyScaleFactor();
        this.sync();
    }

    @Override
    public float getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setScaleFactor(float scale) {
        this.scaleFactor = scale;
        if (this.isActive) {
            RaceScaleHelper.setSmoothModelScale((LivingEntity)this.player, scale, 20);
        }
    }

    @Override
    public float getPermanentManaDecrease() {
        return this.permanentManaDecrease;
    }

    @Override
    public void setPermanentManaDecrease(float value) {
        this.permanentManaDecrease = value;
    }

    @Override
    public void tick() {
        if (!this.isActive || this.player.m_9236_().f_46443_) {
            return;
        }
        ++this.tickCounter;
        this.onTick();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("active", this.isActive);
        tag.m_128350_("permanentManaDecrease", this.permanentManaDecrease);
        this.saveAdditional(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.isActive = tag.m_128471_("active");
        this.permanentManaDecrease = tag.m_128457_("permanentManaDecrease");
        if (tag.m_128441_("CurrentMaxMana")) {
            ManaData.setMaxMana(this.player, tag.m_128457_("CurrentMaxMana"));
        }
        this.loadAdditional(tag);
    }

    @Override
    public void sync() {
        Player player;
        if (!this.player.m_9236_().f_46443_ && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RaceCapabilityNetworking.sendToPlayer(this, serverPlayer);
        }
    }

    @Override
    public void applyPermanentManaModifier(float amount, boolean isBonus) {
        if (!this.player.m_9236_().f_46443_) {
            ManaData.modifyMaxMana(this.player, isBonus ? amount : -amount);
        }
    }

    protected abstract void onTick();

    @Override
    public void forceRemoveAllModifiers() {
        this.removeAttributes();
    }

    protected void saveAdditional(CompoundTag tag) {
        tag.m_128350_("CurrentMaxMana", ManaData.getMaxMana(this.player));
    }

    protected void loadAdditional(CompoundTag tag) {
        if (tag.m_128441_("CurrentMaxMana")) {
            ManaData.setMaxMana(this.player, tag.m_128457_("CurrentMaxMana"));
        }
    }

    public void updateStateOnly(boolean active, float scale) {
        this.isActive = active;
        this.scaleFactor = scale;
        if (this.isActive) {
            RaceScaleHelper.setSmoothModelScale((LivingEntity)this.player, scale, 20);
        }
    }

    public static void clearAllRaceAbilities(Player player) {
        StringBuilder activeRaces = new StringBuilder();
        ModCapabilities.RACE_CAPABILITIES.forEach((raceName, capability) -> player.getCapability(capability).ifPresent(cap -> {
            if (cap instanceof AbstractRaceCapability) {
                AbstractRaceCapability abstractCap = (AbstractRaceCapability)cap;
                if (abstractCap.isActive) {
                    activeRaces.append((String)raceName).append(", ");
                }
            }
        }));
        ModCapabilities.RACE_CAPABILITIES.forEach((raceName, capability) -> player.getCapability(capability).ifPresent(cap -> {
            if (cap instanceof AbstractRaceCapability) {
                AbstractRaceCapability abstractCap = (AbstractRaceCapability)cap;
                if (abstractCap.isActive) {
                    abstractCap.setActive(false);
                }
            }
        }));
    }

    protected void addAttributeModifier(Player player, Attribute attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation) {
        AttributeModifier modifier;
        AttributeInstance instance = player.m_21051_(attribute);
        if (instance != null && ((modifier = instance.m_22111_(uuid)) == null || Math.abs(modifier.m_22218_() - value) > 1.0E-4)) {
            instance.m_22120_(uuid);
            instance.m_22118_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    protected void removeAttributeModifier(Player player, Attribute attribute, UUID uuid) {
        AttributeInstance instance = player.m_21051_(attribute);
        if (instance != null && instance.m_22111_(uuid) != null) {
            instance.m_22120_(uuid);
        }
    }

    protected void validateAndFixAttribute(Attribute attribute, UUID uuid, double value, String name, AttributeModifier.Operation operation) {
        AttributeModifier modifier;
        AttributeInstance instance = this.player.m_21051_(attribute);
        if (instance != null && ((modifier = instance.m_22111_(uuid)) == null || Math.abs(modifier.m_22218_() - value) > 1.0E-4)) {
            instance.m_22120_(uuid);
            instance.m_22118_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    protected boolean hasAttributeModifier(Attribute attribute, UUID uuid) {
        AttributeInstance instance = this.player.m_21051_(attribute);
        return instance != null && instance.m_22111_(uuid) != null;
    }

    protected double getAttributeModifierValue(Attribute attribute, UUID uuid) {
        AttributeModifier modifier;
        AttributeInstance instance = this.player.m_21051_(attribute);
        if (instance != null && (modifier = instance.m_22111_(uuid)) != null) {
            return modifier.m_22218_();
        }
        return 0.0;
    }

    public void applyScaleFactor() {
        if (this.isActive) {
            RaceScaleHelper.setSmoothModelScale((LivingEntity)this.player, this.scaleFactor, 20);
        }
    }

    protected void resetScaleFactor() {
        RaceScaleHelper.setSmoothModelScale((LivingEntity)this.player, 1.0f, 20);
        float currentScale = RaceScaleHelper.getCurrentModelScale((LivingEntity)this.player);
        if (Math.abs(currentScale - 1.0f) > 0.01f) {
            RaceScaleHelper.setModelScale((LivingEntity)this.player, 1.0f);
        }
    }

    protected void handleWallClimbInternal(double climbSpeed, double horizontalDrag) {
        if (!this.player.m_20096_() && !this.player.m_20069_() && !this.player.m_20077_() && this.player.f_20902_ > 0.0f) {
            if (this.isPlayerTouchingWall()) {
                Vec3 motion = this.player.m_20184_();
                if (this.player.m_6144_()) {
                    this.player.m_20334_(motion.f_82479_, 0.0, motion.f_82481_);
                } else {
                    this.player.m_20334_(motion.f_82479_, climbSpeed, motion.f_82481_);
                }
                this.player.m_183634_();
                this.player.m_20256_(this.player.m_20184_().m_82542_(horizontalDrag, 1.0, horizontalDrag));
            }
        } else if (this.isPlayerTouchingWall() && this.player.m_6144_()) {
            this.player.m_20256_(this.player.m_20184_().m_82542_(0.7, 0.0, 0.7));
            this.player.m_183634_();
        }
    }

    protected boolean isPlayerTouchingWall() {
        AABB boundingBox = this.player.m_20191_();
        AABB checkBox = boundingBox.m_82377_(0.15, 0.0, 0.15);
        Level level = this.player.m_9236_();
        double[] checkPoints = new double[]{this.player.m_20185_() - 0.3, this.player.m_20185_() + 0.3, this.player.m_20189_() - 0.3, this.player.m_20189_() + 0.3};
        int minY = (int)Math.floor(boundingBox.f_82289_);
        int maxY = (int)Math.ceil(boundingBox.f_82292_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = minY; y <= maxY; ++y) {
            pos.m_122169_(checkPoints[0], (double)y, this.player.m_20189_());
            if (this.isValidWall(level, (BlockPos)pos)) {
                return true;
            }
            pos.m_122169_(checkPoints[1], (double)y, this.player.m_20189_());
            if (this.isValidWall(level, (BlockPos)pos)) {
                return true;
            }
            pos.m_122169_(this.player.m_20185_(), (double)y, checkPoints[2]);
            if (this.isValidWall(level, (BlockPos)pos)) {
                return true;
            }
            pos.m_122169_(this.player.m_20185_(), (double)y, checkPoints[3]);
            if (!this.isValidWall(level, (BlockPos)pos)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidWall(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        if (!blockState.m_60795_() && blockState.m_280296_() && !(blockState.m_60734_() instanceof LadderBlock) && !(blockState.m_60734_() instanceof VineBlock)) {
            VoxelShape shape = blockState.m_60812_((BlockGetter)level, pos);
            return !shape.m_83281_();
        }
        return false;
    }

    protected static interface AttributeValueProvider {
        public double getValue();
    }
}

