/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.base;

import com.jinqinxixi.trinketsandbaubles.capability.api.IBaseRaceCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BaseRaceCapabilityProvider<T extends IBaseRaceCapability>
implements ICapabilitySerializable<CompoundTag> {
    private final T capability;
    private final LazyOptional<T> optional;
    private final Capability<T> capabilityType;

    public BaseRaceCapabilityProvider(T capability, Capability<T> capabilityType) {
        this.capability = capability;
        this.capabilityType = capabilityType;
        this.optional = LazyOptional.of(() -> capability);
    }

    public <R> LazyOptional<R> getCapability(Capability<R> cap, Direction side) {
        return this.capabilityType.orEmpty(cap, this.optional);
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)this.capability.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.capability.deserializeNBT((Tag)nbt);
    }
}

