/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.event;

import com.jinqinxixi.trinketsandbaubles.capability.api.IBaseRaceCapability;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.capability.base.BaseRaceCapabilityProvider;
import com.jinqinxixi.trinketsandbaubles.capability.impl.DragonCapability;
import com.jinqinxixi.trinketsandbaubles.capability.impl.DwarvesCapability;
import com.jinqinxixi.trinketsandbaubles.capability.impl.ElvesCapability;
import com.jinqinxixi.trinketsandbaubles.capability.impl.FaelesCapability;
import com.jinqinxixi.trinketsandbaubles.capability.impl.FairyCapability;
import com.jinqinxixi.trinketsandbaubles.capability.impl.GoblinsCapability;
import com.jinqinxixi.trinketsandbaubles.capability.impl.TitanCapability;
import com.jinqinxixi.trinketsandbaubles.capability.mana.ManaData;
import com.jinqinxixi.trinketsandbaubles.capability.registry.ModCapabilities;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.util.RaceRingUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trinketsandbaubles")
public class RaceEventHandler {
    private static final String LAST_ACTIVE_RACE_KEY = "LastActiveRaceCapability";
    private static final int RESTORE_DELAY_TICKS = 20;
    private static final String DWARVES_CAP_KEY = "DwarvesCapability";
    private static final String ELVES_CAP_KEY = "ElvesCapability";
    private static final String FAELES_CAP_KEY = "FaelesCapability";
    private static final String TITAN_CAP_KEY = "TitanCapability";
    private static final String GOBLINS_CAP_KEY = "GoblinsCapability";
    private static final String FAIRY_CAP_KEY = "FairyCapability";
    private static final String DRAGON_CAP_KEY = "DragonCapability";

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            RaceEventHandler.registerRaceCapability(event, player, "dwarves", ModCapabilities.DWARVES_CAPABILITY, new DwarvesCapability(player));
            RaceEventHandler.registerRaceCapability(event, player, "elves", ModCapabilities.ELVES_CAPABILITY, new ElvesCapability(player));
            RaceEventHandler.registerRaceCapability(event, player, "faeles", ModCapabilities.FAELES_CAPABILITY, new FaelesCapability(player));
            RaceEventHandler.registerRaceCapability(event, player, "titan", ModCapabilities.TITAN_CAPABILITY, new TitanCapability(player));
            RaceEventHandler.registerRaceCapability(event, player, "goblins", ModCapabilities.GOBLINS_CAPABILITY, new GoblinsCapability(player));
            RaceEventHandler.registerRaceCapability(event, player, "fairy", ModCapabilities.FAIRY_CAPABILITY, new FairyCapability(player));
            RaceEventHandler.registerRaceCapability(event, player, "dragon", ModCapabilities.DRAGON_CAPABILITY, new DragonCapability(player));
        }
    }

    private static void restorePlayerMana(Player player) {
        ManaData.restorePlayerMana(player);
    }

    private static <T extends IBaseRaceCapability> void registerRaceCapability(AttachCapabilitiesEvent<Entity> event, Player player, String raceName, Capability<T> capability, T implementation) {
        event.addCapability(new ResourceLocation("trinketsandbaubles", raceName), new BaseRaceCapabilityProvider<T>(implementation, capability));
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            RaceEventHandler.saveRaceCapabilityState(player);
        }
    }

    private static void saveRaceCapabilityState(Player player) {
        RaceEventHandler.saveCapabilityData(player, ModCapabilities.DWARVES_CAPABILITY, DWARVES_CAP_KEY);
        RaceEventHandler.saveCapabilityData(player, ModCapabilities.ELVES_CAPABILITY, ELVES_CAP_KEY);
        RaceEventHandler.saveCapabilityData(player, ModCapabilities.FAELES_CAPABILITY, FAELES_CAP_KEY);
        RaceEventHandler.saveCapabilityData(player, ModCapabilities.TITAN_CAPABILITY, TITAN_CAP_KEY);
        RaceEventHandler.saveCapabilityData(player, ModCapabilities.GOBLINS_CAPABILITY, GOBLINS_CAP_KEY);
        RaceEventHandler.saveCapabilityData(player, ModCapabilities.FAIRY_CAPABILITY, FAIRY_CAP_KEY);
        RaceEventHandler.saveCapabilityData(player, ModCapabilities.DRAGON_CAPABILITY, DRAGON_CAP_KEY);
    }

    private static <T extends IBaseRaceCapability> void saveCapabilityData(Player player, Capability<T> capability, String key) {
        player.getCapability(capability).ifPresent(cap -> {
            if (cap.isActive()) {
                CompoundTag playerData = player.getPersistentData();
                CompoundTag capData = new CompoundTag();
                capData.m_128379_("WasActive", true);
                capData.m_128350_("CurrentMaxMana", ManaData.getMaxMana(player));
                playerData.m_128365_(key, (Tag)capData);
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player player = event.getEntity();
        if (!event.isWasDeath()) {
            RaceEventHandler.handleDimensionalClone(original, player);
        } else {
            RaceEventHandler.handleDeathClone(original, player);
        }
    }

    private static void handleDimensionalClone(Player original, Player player) {
        CompoundTag originalData = original.getPersistentData();
        CompoundTag newPlayerData = player.getPersistentData();
        if (originalData.m_128441_(LAST_ACTIVE_RACE_KEY)) {
            newPlayerData.m_128359_(LAST_ACTIVE_RACE_KEY, originalData.m_128461_(LAST_ACTIVE_RACE_KEY));
        }
        if (!player.m_9236_().m_5776_()) {
            RaceEventHandler.scheduleRaceAbilityRestore(player);
        }
    }

    private static void handleDeathClone(Player original, Player player) {
        String savedRace = original.getPersistentData().m_128461_("SavedRace");
        AbstractRaceCapability.clearAllRaceAbilities(player);
        MinecraftServer server = player.m_9236_().m_7654_();
        if (server != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            server.m_6937_((Runnable)new TickTask(server.m_129921_() + 1, () -> {
                RaceEventHandler.restoreRaceCapabilityFromKey(original, (Player)serverPlayer, DWARVES_CAP_KEY, ModCapabilities.DWARVES_CAPABILITY);
                RaceEventHandler.restoreRaceCapabilityFromKey(original, (Player)serverPlayer, ELVES_CAP_KEY, ModCapabilities.ELVES_CAPABILITY);
                RaceEventHandler.restoreRaceCapabilityFromKey(original, (Player)serverPlayer, FAELES_CAP_KEY, ModCapabilities.FAELES_CAPABILITY);
                RaceEventHandler.restoreRaceCapabilityFromKey(original, (Player)serverPlayer, TITAN_CAP_KEY, ModCapabilities.TITAN_CAPABILITY);
                RaceEventHandler.restoreRaceCapabilityFromKey(original, (Player)serverPlayer, GOBLINS_CAP_KEY, ModCapabilities.GOBLINS_CAPABILITY);
                RaceEventHandler.restoreRaceCapabilityFromKey(original, (Player)serverPlayer, FAIRY_CAP_KEY, ModCapabilities.FAIRY_CAPABILITY);
                RaceEventHandler.restoreRaceCapabilityFromKey(original, (Player)serverPlayer, DRAGON_CAP_KEY, ModCapabilities.DRAGON_CAPABILITY);
                if (!savedRace.isEmpty() && !RaceRingUtil.hasAnyRaceRing((Player)serverPlayer)) {
                    RaceRingUtil.activateRace(serverPlayer, savedRace);
                }
                RaceEventHandler.restorePlayerMana((Player)serverPlayer);
            }));
        }
    }

    private static <T extends IBaseRaceCapability> void restoreRaceCapabilityFromKey(Player original, Player player, String capabilityKey, Capability<T> capability) {
        CompoundTag originalData = original.getPersistentData();
        if (originalData.m_128441_(capabilityKey)) {
            CompoundTag capData = originalData.m_128469_(capabilityKey);
            player.getCapability(capability).ifPresent(cap -> {
                if (capData.m_128471_("WasActive")) {
                    cap.setActive(true);
                    if (capData.m_128441_("CurrentMaxMana")) {
                        ManaData.setMaxMana(player, capData.m_128457_("CurrentMaxMana"));
                    }
                }
            });
        }
    }

    private static void scheduleRaceAbilityRestore(Player player) {
        player.m_9236_().m_7654_().m_6937_((Runnable)new TickTask(20, () -> RaceEventHandler.restoreRaceAbility(player)));
    }

    private static void restoreRaceAbility(Player player) {
        CompoundTag playerData = player.getPersistentData();
        if (!playerData.m_128441_(LAST_ACTIVE_RACE_KEY)) {
            return;
        }
        AbstractRaceCapability.clearAllRaceAbilities(player);
        String raceName = playerData.m_128461_(LAST_ACTIVE_RACE_KEY);
        Capability<? extends IBaseRaceCapability> capability = ModCapabilities.RACE_CAPABILITIES.get(raceName.toLowerCase());
        if (capability != null) {
            player.getCapability(capability).ifPresent(cap -> cap.setActive(true));
            RaceEventHandler.restorePlayerMana(player);
        }
        playerData.m_128473_(LAST_ACTIVE_RACE_KEY);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            RaceEventHandler.saveActiveRaceState(player);
            AbstractRaceCapability.clearAllRaceAbilities(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTravelToDimensionCanceled(EntityTravelToDimensionEvent event) {
        Player player;
        Entity entity;
        if (event.isCanceled() && (entity = event.getEntity()) instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
            player.m_9236_().m_7654_().m_6937_((Runnable)new TickTask(1, () -> RaceEventHandler.restoreRaceAbility(player)));
        }
    }

    private static void saveActiveRaceState(Player player) {
        player.getCapability(ModCapabilities.DWARVES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                player.getPersistentData().m_128359_(LAST_ACTIVE_RACE_KEY, "dwarves");
            }
        });
        player.getCapability(ModCapabilities.ELVES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                player.getPersistentData().m_128359_(LAST_ACTIVE_RACE_KEY, "elves");
            }
        });
        player.getCapability(ModCapabilities.FAELES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                player.getPersistentData().m_128359_(LAST_ACTIVE_RACE_KEY, "faeles");
            }
        });
        player.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                player.getPersistentData().m_128359_(LAST_ACTIVE_RACE_KEY, "titan");
            }
        });
        player.getCapability(ModCapabilities.GOBLINS_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                player.getPersistentData().m_128359_(LAST_ACTIVE_RACE_KEY, "goblins");
            }
        });
        player.getCapability(ModCapabilities.FAIRY_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                player.getPersistentData().m_128359_(LAST_ACTIVE_RACE_KEY, "fairy");
            }
        });
        player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                player.getPersistentData().m_128359_(LAST_ACTIVE_RACE_KEY, "dragon");
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        RaceEventHandler.refreshRaceCapabilities(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_()) {
            RaceEventHandler.restoreRaceAbility(player);
            RaceEventHandler.syncRaceCapabilities(player);
            RaceEventHandler.restorePlayerMana(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        RaceEventHandler.syncRaceCapabilities(event.getEntity());
    }

    private static void syncRaceCapabilities(Player player) {
        player.getCapability(ModCapabilities.DWARVES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.sync();
            }
        });
        player.getCapability(ModCapabilities.ELVES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.sync();
            }
        });
        player.getCapability(ModCapabilities.FAELES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.sync();
            }
        });
        player.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.sync();
            }
        });
        player.getCapability(ModCapabilities.GOBLINS_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.sync();
            }
        });
        player.getCapability(ModCapabilities.FAIRY_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.sync();
            }
        });
        player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.sync();
            }
        });
    }

    public static void refreshRaceCapabilities(Player player) {
        ModCapabilities.RACE_CAPABILITIES.forEach((raceName, capability) -> player.getCapability(capability).ifPresent(cap -> {
            AbstractRaceCapability abstractCap;
            if (cap instanceof AbstractRaceCapability && (abstractCap = (AbstractRaceCapability)cap).isActive()) {
                abstractCap.applyEffects();
            }
        }));
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        RaceEventHandler.handleDwarvesBlockBreak(player, event);
        RaceEventHandler.handleTitanBlockBreak(player, event);
    }

    private static void handleDwarvesBlockBreak(Player player, BlockEvent.BreakEvent event) {
        player.getCapability(ModCapabilities.DWARVES_CAPABILITY).ifPresent(cap -> {
            LevelAccessor patt15923$temp;
            if (cap.isActive() && !event.getLevel().m_5776_() && (patt15923$temp = event.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt15923$temp;
                cap.onBreakBlock(event.getPos(), event.getState().m_60734_(), serverLevel);
            }
        });
    }

    private static void handleTitanBlockBreak(Player player, BlockEvent.BreakEvent event) {
        player.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
            LevelAccessor patt16374$temp;
            if (cap.isActive() && !event.getLevel().m_5776_() && (patt16374$temp = event.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt16374$temp;
                cap.onBreakBlock(event.getPos(), event.getState().m_60734_(), serverLevel);
            }
        });
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            RaceEventHandler.updateRaceCapabilities(player);
        }
    }

    private static void updateRaceCapabilities(Player player) {
        player.getCapability(ModCapabilities.DWARVES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.tick();
            }
        });
        player.getCapability(ModCapabilities.ELVES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.tick();
            }
        });
        player.getCapability(ModCapabilities.FAELES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.tick();
            }
        });
        player.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.tick();
            }
        });
        player.getCapability(ModCapabilities.GOBLINS_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.tick();
            }
        });
        player.getCapability(ModCapabilities.FAIRY_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.tick();
            }
        });
        player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                cap.tick();
            }
        });
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent event) {
        Entity entity;
        if (event.getSource().m_7640_() instanceof Arrow && (entity = event.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(ModCapabilities.ELVES_CAPABILITY).ifPresent(cap -> {
                if (cap.isActive() && player.m_6047_()) {
                    float newDamage = event.getAmount() * ((Double)RaceAttributesConfig.ELVES.ELVES_BOW_DAMAGE_BOOST.get()).floatValue();
                    event.setAmount(newDamage);
                }
            });
            player.getCapability(ModCapabilities.GOBLINS_CAPABILITY).ifPresent(cap -> {
                DamageSource source = event.getSource();
                if (source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268565_)) {
                    event.setAmount(cap.handleDamage(event.getAmount(), true));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(ModCapabilities.FAELES_CAPABILITY).ifPresent(cap -> {
                if (cap.isActive()) {
                    ((FaelesCapability)cap).onJump();
                }
            });
            player.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
                if (cap.isActive()) {
                    cap.handleJump();
                }
            });
            player.getCapability(ModCapabilities.FAIRY_CAPABILITY).ifPresent(cap -> {
                if (cap.isActive()) {
                    Vec3 motion = player.m_20184_();
                    double multiplier = 1.0 + (Double)RaceAttributesConfig.FAIRY.FAIRY_DEW_JUMP_BOOST.get();
                    player.m_20334_(motion.f_82479_, motion.f_82480_ * multiplier, motion.f_82481_);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getItem().m_41720_() == Items.f_42455_) {
                player.getCapability(ModCapabilities.FAELES_CAPABILITY).ifPresent(cap -> {
                    if (cap.isActive()) {
                        ((FaelesCapability)cap).onDrinkMilk();
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        RaceEventHandler.handleRaceWallClimb(player);
        RaceEventHandler.handleTitanWaterMovement(player);
    }

    private static void handleTitanWaterMovement(Player player) {
        player.getCapability(ModCapabilities.TITAN_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                ((TitanCapability)cap).handleWaterMovement();
            }
        });
    }

    private static void handleRaceWallClimb(Player player) {
        player.getCapability(ModCapabilities.FAELES_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive() && ((Boolean)RaceAttributesConfig.FAELES.FAELES_WALL_CLIMB.get()).booleanValue()) {
                ((FaelesCapability)cap).handleWallClimb();
            }
        });
        player.getCapability(ModCapabilities.FAIRY_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive() && ((Boolean)RaceAttributesConfig.FAIRY.FAIRY_DEW_WALL_CLIMB.get()).booleanValue()) {
                ((FairyCapability)cap).handleWallClimb();
            }
        });
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        Entity entity;
        if (event.isMounting() && (entity = event.getEntityMounting()) instanceof Player) {
            Player player = (Player)entity;
            entity = event.getEntityBeingMounted();
            if (entity instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)entity;
                player.getCapability(ModCapabilities.GOBLINS_CAPABILITY).ifPresent(cap -> {
                    if (cap.isActive()) {
                        ((GoblinsCapability)cap).handleMount(horse);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onCreeperTarget(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getNewTarget();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getEntity() instanceof Creeper) {
                player.getCapability(ModCapabilities.GOBLINS_CAPABILITY).ifPresent(cap -> {
                    if (cap.isActive()) {
                        event.setCanceled(true);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerGameModeChange(PlayerEvent.PlayerChangeGameModeEvent event) {
        Player player = event.getEntity();
        player.getCapability(ModCapabilities.DRAGON_CAPABILITY).ifPresent(cap -> {
            if (cap.isActive()) {
                ((DragonCapability)cap).handleGameModeChange(event.getNewGameMode());
            }
        });
    }
}

