/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.impl;

import com.jinqinxixi.trinketsandbaubles.TrinketsandBaublesMod;
import com.jinqinxixi.trinketsandbaubles.capability.api.IDragonCapability;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.capability.mana.ManaData;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import com.jinqinxixi.trinketsandbaubles.network.handler.NetworkHandler;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage.SyncAllDragonStatesMessage;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage.SyncDragonBreathMessage;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import vazkii.botania.api.mana.ManaItemHandler;

public class DragonCapability
extends AbstractRaceCapability
implements IDragonCapability {
    private boolean flightEnabled = true;
    public boolean dragonBreathActive = false;

    public float getCurrentMana() {
        return this.getManaSystem().getMana(this.player, BotaniaManaSystem.DUMMY_RECEIVER);
    }

    public DragonCapability(Player player) {
        super(player);
        this.scaleFactor = ((Double)RaceAttributesConfig.DRAGON.DRAGON_SCALE_FACTOR.get()).floatValue();
    }

    private ManaSystem getManaSystem() {
        if (this.shouldUseIronsSpellsMana()) {
            return new IronsSpellsManaSystem();
        }
        if (this.shouldUseBotaniaMana()) {
            return new BotaniaManaSystem();
        }
        return new InternalManaSystem();
    }

    private boolean shouldUseBotaniaMana() {
        return ModList.get().isLoaded("botania") && (Boolean)ModConfig.USE_BOTANIA_MANA.get() != false;
    }

    private boolean shouldUseIronsSpellsMana() {
        try {
            Class.forName("io.redspace.ironsspellbooks.api.magic.MagicData");
            return (Boolean)ModConfig.USE_IRONS_SPELLS_MANA.get();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    protected void registerAttributeValues() {
        this.registerValue("MAX_HEALTH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.MAX_HEALTH).get());
        this.registerValue("FOLLOW_RANGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.FOLLOW_RANGE).get());
        this.registerValue("KNOCKBACK_RESISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.KNOCKBACK_RESISTANCE).get());
        this.registerValue("MOVEMENT_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.MOVEMENT_SPEED).get());
        this.registerValue("FLYING_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.FLYING_SPEED).get());
        this.registerValue("ATTACK_DAMAGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.ATTACK_DAMAGE).get());
        this.registerValue("ATTACK_KNOCKBACK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.ATTACK_KNOCKBACK).get());
        this.registerValue("ATTACK_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.ATTACK_SPEED).get());
        this.registerValue("ARMOR", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.ARMOR).get());
        this.registerValue("ARMOR_TOUGHNESS", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.ARMOR_TOUGHNESS).get());
        this.registerValue("LUCK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.LUCK).get());
        this.registerValue("SWIM_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.SWIM_SPEED).get());
        this.registerValue("NAMETAG_DISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.NAMETAG_DISTANCE).get());
        this.registerValue("ENTITY_GRAVITY", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.ENTITY_GRAVITY).get());
        this.registerValue("STEP_HEIGHT", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.STEP_HEIGHT).get());
        this.registerValue("BLOCK_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.BLOCK_REACH).get());
        this.registerValue("ENTITY_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DRAGON.ENTITY_REACH).get());
    }

    @Override
    public String getRaceName() {
        return "Dragon";
    }

    @Override
    public String getRaceId() {
        return "dragon";
    }

    @Override
    public float getManaBonus() {
        return ((Double)RaceAttributesConfig.DRAGON.DRAGON_MANA_BONUS.get()).floatValue();
    }

    @Override
    protected void onTick() {
        if (!this.isActive) {
            return;
        }
        this.updateFlightAbility();
        this.player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.DRAGON.get(), 30, 0, false, false, false));
        if (this.flightEnabled && !this.player.m_7500_() && !this.player.m_5833_() && this.player.m_150110_().f_35935_) {
            float manaCost = ((Double)RaceAttributesConfig.DRAGON.DRAGON_FLIGHT_MANA_COST.get()).floatValue();
            ManaSystem manaSystem = this.getManaSystem();
            boolean hasSufficientMana = false;
            if (manaSystem instanceof BotaniaManaSystem) {
                if ((double)this.tickCounter % (Double)RaceAttributesConfig.DRAGON.DRAGON_MANA_CHECK_INTERVAL.get() == 0.0) {
                    if (manaSystem.hasMana(this.player, manaCost, BotaniaManaSystem.DUMMY_RECEIVER)) {
                        manaSystem.consumeMana(this.player, manaCost, BotaniaManaSystem.DUMMY_RECEIVER);
                        hasSufficientMana = true;
                    }
                } else {
                    hasSufficientMana = manaSystem.hasMana(this.player, manaCost, BotaniaManaSystem.DUMMY_RECEIVER);
                }
            } else {
                float tickCost = Math.max(1.0f, manaCost / 20.0f);
                if (manaSystem instanceof IronsSpellsManaSystem) {
                    tickCost = (float)Math.ceil(tickCost);
                }
                if (manaSystem.hasMana(this.player, tickCost, BotaniaManaSystem.DUMMY_RECEIVER)) {
                    manaSystem.consumeMana(this.player, tickCost, BotaniaManaSystem.DUMMY_RECEIVER);
                    hasSufficientMana = true;
                }
            }
            if (!hasSufficientMana) {
                this.player.m_150110_().f_35935_ = false;
                this.player.m_150110_().f_35936_ = false;
                this.player.m_6885_();
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"message.trinketsandbaubles.dragon.no_mana").m_130940_(ChatFormatting.RED), true);
                }
            }
        }
        if (this.dragonBreathActive && !this.player.m_9236_().f_46443_) {
            if (this.player.m_217043_().m_188501_() < 0.4f) {
                this.player.m_9236_().m_6269_(null, (Entity)this.player, SoundEvents.f_11705_, SoundSource.PLAYERS, 0.3f, 0.7f + this.player.m_217043_().m_188501_() * 0.3f);
            }
            if (this.player.m_217043_().m_188501_() < 0.4f) {
                this.player.m_9236_().m_6269_(null, (Entity)this.player, SoundEvents.f_11936_, SoundSource.PLAYERS, 0.2f, 0.8f + this.player.m_217043_().m_188501_() * 0.2f);
            }
        }
    }

    @Override
    public void toggleFlight() {
        Player player;
        if (!this.isActive) {
            return;
        }
        boolean bl = this.flightEnabled = !this.flightEnabled;
        if (!this.flightEnabled && !this.player.m_7500_()) {
            this.disableDragonFlight();
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.m_237115_((String)(this.flightEnabled ? "message.trinketsandbaubles.dragon.flight.enabled" : "message.trinketsandbaubles.dragon.flight.disabled")).m_130940_(this.flightEnabled ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            serverPlayer.m_5661_((Component)message, true);
        }
        this.sync();
    }

    @Override
    public void toggleDragonBreath() {
        float manaCost;
        ManaSystem manaSystem;
        boolean shouldActivate;
        TrinketsandBaublesMod.LOGGER.info("toggleDragonBreath called. Current state: {}, Using Iron's Spells: {}", (Object)this.dragonBreathActive, (Object)this.shouldUseIronsSpellsMana());
        boolean bl = shouldActivate = !this.dragonBreathActive;
        if (shouldActivate && !(manaSystem = this.getManaSystem()).hasMana(this.player, manaCost = ((Double)RaceAttributesConfig.DRAGON.DRAGON_BREATH_MANA_COST.get()).floatValue(), BotaniaManaSystem.DUMMY_RECEIVER)) {
            TrinketsandBaublesMod.LOGGER.info("Not enough mana to activate dragon breath");
            return;
        }
        this.setDragonBreathActive(shouldActivate);
    }

    public boolean setDragonBreathActive(boolean active) {
        float manaCost;
        ManaSystem manaSystem;
        if (active && !this.dragonBreathActive && !(manaSystem = this.getManaSystem()).hasMana(this.player, manaCost = ((Double)RaceAttributesConfig.DRAGON.DRAGON_BREATH_MANA_COST.get()).floatValue(), BotaniaManaSystem.DUMMY_RECEIVER)) {
            TrinketsandBaublesMod.LOGGER.info("Not enough mana to activate dragon breath");
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"message.trinketsandbaubles.dragon.no_mana_breath").m_130940_(ChatFormatting.RED), true);
            }
            return false;
        }
        if (this.dragonBreathActive != active) {
            this.dragonBreathActive = active;
            if (!this.player.m_9236_().f_46443_) {
                TrinketsandBaublesMod.LOGGER.info("Dragon breath state set to: {}", (Object)this.dragonBreathActive);
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new SyncDragonBreathMessage(this.dragonBreathActive, serverPlayer.m_19879_()));
                }
            }
        }
        return true;
    }

    @Override
    public void setActive(boolean active) {
        if (this.isActive == active) {
            return;
        }
        if (!active) {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new SyncAllDragonStatesMessage(false, false, serverPlayer.m_19879_()));
            }
            super.setActive(false);
            this.isActive = false;
            if (!this.player.m_7500_()) {
                this.player.m_150110_().f_35936_ = false;
                this.player.m_150110_().f_35935_ = false;
                this.player.m_150110_().m_35943_(0.05f);
                this.player.m_6885_();
            }
        } else {
            super.setActive(true);
            this.isActive = true;
            this.updateFlightAbility();
        }
    }

    @Override
    public void sync() {
        Player player;
        if (!this.player.m_9236_().f_46443_ && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new SyncAllDragonStatesMessage(this.flightEnabled, this.dragonBreathActive, serverPlayer.m_19879_()));
        }
        super.sync();
    }

    @Override
    public boolean isFlightEnabled() {
        return this.flightEnabled;
    }

    @Override
    public boolean isDragonBreathActive() {
        return this.dragonBreathActive;
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.m_128379_("FlightEnabled", this.flightEnabled);
        tag.m_128379_("DragonBreathActive", this.dragonBreathActive);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        super.loadAdditional(tag);
        this.flightEnabled = tag.m_128441_("FlightEnabled") ? tag.m_128471_("FlightEnabled") : true;
        this.dragonBreathActive = tag.m_128441_("DragonBreathActive") ? tag.m_128471_("DragonBreathActive") : false;
    }

    private void disableDragonFlight() {
        if (!this.player.m_7500_() && (this.player.m_150110_().f_35936_ || this.player.m_150110_().f_35935_)) {
            this.player.m_150110_().f_35936_ = false;
            this.player.m_150110_().f_35935_ = false;
            this.player.m_150110_().m_35943_(0.05f);
            this.player.m_6885_();
        }
    }

    public void handleGameModeChange(GameType newGameMode) {
        if (!this.player.m_7500_() && !this.player.m_5833_()) {
            if (newGameMode != GameType.SURVIVAL) {
                this.player.m_150110_().m_35943_(0.05f);
            } else {
                this.player.m_150110_().m_35943_(0.05f * ((Double)RaceAttributesConfig.DRAGON.DRAGON_FLIGHT_SPEED.get()).floatValue());
            }
            this.player.m_6885_();
        }
    }

    @Override
    public void updateFlightAbility() {
        if (!this.isActive || !this.flightEnabled) {
            return;
        }
        if (!this.player.m_7500_() && !this.player.m_5833_()) {
            this.player.m_150110_().f_35936_ = true;
            this.player.m_150110_().m_35943_(0.05f * ((Double)RaceAttributesConfig.DRAGON.DRAGON_FLIGHT_SPEED.get()).floatValue());
            this.player.m_6885_();
        } else if (this.flightEnabled) {
            this.player.m_150110_().f_35936_ = true;
            this.player.m_6885_();
        }
    }

    @Override
    public void onBreakBlock(BlockPos pos, Block block, ServerLevel level) {
    }

    private static interface ManaSystem {
        public float getMana(Player var1, ItemStack var2);

        public void consumeMana(Player var1, float var2, ItemStack var3);

        public boolean hasMana(Player var1, float var2, ItemStack var3);
    }

    private class BotaniaManaSystem
    implements ManaSystem {
        private static final ItemStack DUMMY_RECEIVER = new ItemStack((ItemLike)Items.f_42398_);

        private BotaniaManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            ManaItemHandler handler = ManaItemHandler.instance();
            return handler.requestMana(DUMMY_RECEIVER, player, Integer.MAX_VALUE, false);
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            ManaItemHandler handler = ManaItemHandler.instance();
            handler.requestMana(DUMMY_RECEIVER, player, (int)amount, true);
        }

        @Override
        public boolean hasMana(Player player, float amount, ItemStack stack) {
            ManaItemHandler handler = ManaItemHandler.instance();
            return (float)handler.requestMana(DUMMY_RECEIVER, player, (int)amount, false) >= amount;
        }
    }

    private class IronsSpellsManaSystem
    implements ManaSystem {
        private IronsSpellsManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return MagicData.getPlayerMagicData((LivingEntity)player).getMana();
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            float actualAmount = Math.max(1.0f, (float)Math.ceil(amount));
            MagicData.getPlayerMagicData((LivingEntity)player).addMana(-actualAmount);
        }

        @Override
        public boolean hasMana(Player player, float amount, ItemStack stack) {
            float actualAmount = Math.max(1.0f, (float)Math.ceil(amount));
            return this.getMana(player, stack) >= actualAmount;
        }
    }

    private class InternalManaSystem
    implements ManaSystem {
        private InternalManaSystem() {
        }

        @Override
        public float getMana(Player player, ItemStack stack) {
            return ManaData.getMana(player);
        }

        @Override
        public void consumeMana(Player player, float amount, ItemStack stack) {
            ManaData.consumeMana(player, amount);
        }

        @Override
        public boolean hasMana(Player player, float amount, ItemStack stack) {
            return ManaData.hasMana(player, amount);
        }
    }
}

