/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.impl;

import com.jinqinxixi.trinketsandbaubles.capability.api.IDwarvesCapability;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;

public class DwarvesCapability
extends AbstractRaceCapability
implements IDwarvesCapability {
    public DwarvesCapability(Player player) {
        super(player);
        this.scaleFactor = ((Double)RaceAttributesConfig.DWARVES.DWARVES_SCALE_FACTOR.get()).floatValue();
    }

    @Override
    protected void registerAttributeValues() {
        this.registerValue("MAX_HEALTH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.MAX_HEALTH).get());
        this.registerValue("FOLLOW_RANGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.FOLLOW_RANGE).get());
        this.registerValue("KNOCKBACK_RESISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.KNOCKBACK_RESISTANCE).get());
        this.registerValue("MOVEMENT_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.MOVEMENT_SPEED).get());
        this.registerValue("FLYING_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.FLYING_SPEED).get());
        this.registerValue("ATTACK_DAMAGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.ATTACK_DAMAGE).get());
        this.registerValue("ATTACK_KNOCKBACK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.ATTACK_KNOCKBACK).get());
        this.registerValue("ATTACK_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.ATTACK_SPEED).get());
        this.registerValue("ARMOR", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.ARMOR).get());
        this.registerValue("ARMOR_TOUGHNESS", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.ARMOR_TOUGHNESS).get());
        this.registerValue("LUCK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.LUCK).get());
        this.registerValue("SWIM_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.SWIM_SPEED).get());
        this.registerValue("NAMETAG_DISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.NAMETAG_DISTANCE).get());
        this.registerValue("ENTITY_GRAVITY", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.ENTITY_GRAVITY).get());
        this.registerValue("STEP_HEIGHT", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.STEP_HEIGHT).get());
        this.registerValue("BLOCK_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.BLOCK_REACH).get());
        this.registerValue("ENTITY_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.DWARVES.ENTITY_REACH).get());
    }

    @Override
    public float getManaBonus() {
        return ((Double)RaceAttributesConfig.DWARVES.DWARVES_MANA_BONUS.get()).floatValue();
    }

    @Override
    public String getRaceName() {
        return "Dwarves";
    }

    @Override
    public String getRaceId() {
        return "dwarves";
    }

    @Override
    protected void onTick() {
        if (!this.isActive) {
            return;
        }
        this.player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.DWARVES.get(), 30, 0, false, false, false));
    }

    @Override
    public void onBreakBlock(BlockPos pos, Block block, ServerLevel level) {
        int extraXp;
        if (!this.isActive) {
            return;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_144266_) || block.m_49966_().m_204336_(BlockTags.f_144267_) || block == Blocks.f_50259_) {
            this.spawnExperienceOrb(level, pos, 1);
        } else if (block.m_49966_().m_204336_(Tags.Blocks.ORES) && (extraXp = this.player.m_217043_().m_188503_(3)) > 0) {
            this.spawnExperienceOrb(level, pos, extraXp);
        }
    }

    private void spawnExperienceOrb(ServerLevel level, BlockPos pos, int xp) {
        level.m_7967_((Entity)new ExperienceOrb((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, xp));
    }

    @Override
    public void forceRemoveAllModifiers() {
        this.removeAttributes();
    }
}

