/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.impl;

import com.jinqinxixi.trinketsandbaubles.capability.api.IElvesCapability;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;

public class ElvesCapability
extends AbstractRaceCapability
implements IElvesCapability {
    private static final UUID FOREST_MOVEMENT_SPEED_UUID = UUID.fromString("91AEAA56-376B-4498-935B-2F7F68070635");
    private static final UUID FOREST_ATTACK_SPEED_UUID = UUID.fromString("5D6F0BA2-1186-46AC-B896-C61C5CEE99CC");

    public ElvesCapability(Player player) {
        super(player);
        this.scaleFactor = ((Double)RaceAttributesConfig.ELVES.ELVES_SCALE_FACTOR.get()).floatValue();
    }

    @Override
    protected void registerAttributeValues() {
        this.registerValue("MAX_HEALTH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.MAX_HEALTH).get());
        this.registerValue("FOLLOW_RANGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.FOLLOW_RANGE).get());
        this.registerValue("KNOCKBACK_RESISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.KNOCKBACK_RESISTANCE).get());
        this.registerValue("MOVEMENT_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.MOVEMENT_SPEED).get());
        this.registerValue("FLYING_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.FLYING_SPEED).get());
        this.registerValue("ATTACK_DAMAGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.ATTACK_DAMAGE).get());
        this.registerValue("ATTACK_KNOCKBACK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.ATTACK_KNOCKBACK).get());
        this.registerValue("ATTACK_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.ATTACK_SPEED).get());
        this.registerValue("ARMOR", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.ARMOR).get());
        this.registerValue("ARMOR_TOUGHNESS", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.ARMOR_TOUGHNESS).get());
        this.registerValue("LUCK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.LUCK).get());
        this.registerValue("SWIM_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.SWIM_SPEED).get());
        this.registerValue("NAMETAG_DISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.NAMETAG_DISTANCE).get());
        this.registerValue("ENTITY_GRAVITY", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.ENTITY_GRAVITY).get());
        this.registerValue("STEP_HEIGHT", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.STEP_HEIGHT).get());
        this.registerValue("BLOCK_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.BLOCK_REACH).get());
        this.registerValue("ENTITY_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.ELVES.ENTITY_REACH).get());
    }

    @Override
    public float getManaBonus() {
        return ((Double)RaceAttributesConfig.ELVES.ELVES_MANA_BONUS.get()).floatValue();
    }

    @Override
    public String getRaceName() {
        return "Elves";
    }

    @Override
    public String getRaceId() {
        return "elves";
    }

    @Override
    protected void onTick() {
        if (!this.isActive) {
            return;
        }
        this.player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.ELVES.get(), 30, 0, false, false, false));
        this.updateForestBonuses();
    }

    private void updateForestBonuses() {
        boolean inForest = this.isInForest();
        AttributeInstance movementSpeed = this.player.m_21051_(Attributes.f_22279_);
        AttributeInstance attackSpeed = this.player.m_21051_(Attributes.f_22283_);
        if (movementSpeed != null && attackSpeed != null) {
            boolean hasAttackBonus;
            boolean hasMovementBonus = movementSpeed.m_22111_(FOREST_MOVEMENT_SPEED_UUID) != null;
            boolean bl = hasAttackBonus = attackSpeed.m_22111_(FOREST_ATTACK_SPEED_UUID) != null;
            if (inForest && !hasMovementBonus) {
                this.addAttributeModifier(this.player, Attributes.f_22279_, FOREST_MOVEMENT_SPEED_UUID, "Forest Movement Speed Bonus", (Double)RaceAttributesConfig.ELVES.ELVES_FOREST_MOVEMENT_SPEED.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
            } else if (!inForest && hasMovementBonus) {
                this.removeAttributeModifier(this.player, Attributes.f_22279_, FOREST_MOVEMENT_SPEED_UUID);
            }
            if (inForest && !hasAttackBonus) {
                this.addAttributeModifier(this.player, Attributes.f_22283_, FOREST_ATTACK_SPEED_UUID, "Forest Attack Speed Bonus", (Double)RaceAttributesConfig.ELVES.ELVES_FOREST_ATTACK_SPEED.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
            } else if (!inForest && hasAttackBonus) {
                this.removeAttributeModifier(this.player, Attributes.f_22283_, FOREST_ATTACK_SPEED_UUID);
            }
        }
    }

    @Override
    public void validateAndFixAttributes() {
        if (!this.isActive) {
            return;
        }
        super.validateAndFixAttributes();
        this.updateForestBonuses();
    }

    @Override
    public void removeAttributes() {
        super.removeAttributes();
        this.removeAttributeModifier(this.player, Attributes.f_22279_, FOREST_MOVEMENT_SPEED_UUID);
        this.removeAttributeModifier(this.player, Attributes.f_22283_, FOREST_ATTACK_SPEED_UUID);
        this.player.m_21153_(this.player.m_21223_());
    }

    @Override
    public void forceRemoveAllModifiers() {
        this.removeAttributes();
    }

    @Override
    public boolean isInForest() {
        return this.player.m_9236_().m_204166_(this.player.m_20183_()).m_203656_(BiomeTags.f_207611_);
    }

    @Override
    public void onBreakBlock(BlockPos pos, Block block, ServerLevel level) {
    }
}

