/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.impl;

import com.jinqinxixi.trinketsandbaubles.capability.api.IFaelesCapability;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;

public class FaelesCapability
extends AbstractRaceCapability
implements IFaelesCapability {
    private static final UUID ATTACK_DAMAGE_UNARMED_UUID = UUID.fromString("b2461c37-8d2e-4a4d-95ac-d2169c49182a");

    public FaelesCapability(Player player) {
        super(player);
        this.scaleFactor = ((Double)RaceAttributesConfig.FAELES.FAELES_SCALE_FACTOR.get()).floatValue();
    }

    @Override
    protected void registerAttributeValues() {
        this.registerValue("MAX_HEALTH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.MAX_HEALTH).get());
        this.registerValue("FOLLOW_RANGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.FOLLOW_RANGE).get());
        this.registerValue("KNOCKBACK_RESISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.KNOCKBACK_RESISTANCE).get());
        this.registerValue("MOVEMENT_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.MOVEMENT_SPEED).get());
        this.registerValue("FLYING_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.FLYING_SPEED).get());
        this.registerValue("ATTACK_DAMAGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.ATTACK_DAMAGE).get());
        this.registerValue("ATTACK_KNOCKBACK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.ATTACK_KNOCKBACK).get());
        this.registerValue("ATTACK_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.ATTACK_SPEED).get());
        this.registerValue("ARMOR", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.ARMOR).get());
        this.registerValue("ARMOR_TOUGHNESS", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.ARMOR_TOUGHNESS).get());
        this.registerValue("LUCK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.LUCK).get());
        this.registerValue("SWIM_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.SWIM_SPEED).get());
        this.registerValue("NAMETAG_DISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.NAMETAG_DISTANCE).get());
        this.registerValue("ENTITY_GRAVITY", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.ENTITY_GRAVITY).get());
        this.registerValue("STEP_HEIGHT", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.STEP_HEIGHT).get());
        this.registerValue("BLOCK_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.BLOCK_REACH).get());
        this.registerValue("ENTITY_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAELES.ENTITY_REACH).get());
    }

    @Override
    public float getManaBonus() {
        return ((Double)RaceAttributesConfig.FAELES.FAELES_MANA_BONUS.get()).floatValue();
    }

    @Override
    public String getRaceName() {
        return "Faeles";
    }

    @Override
    public String getRaceId() {
        return "faeles";
    }

    @Override
    protected void onTick() {
        if (!this.isActive) {
            return;
        }
        this.player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FAELES.get(), 30, 0, false, false, false));
        this.updateArmorPenalties();
        this.updateUnarmedDamage();
    }

    private void updateUnarmedDamage() {
        boolean isUnarmed = this.player.m_21205_().m_41619_() && this.player.m_21206_().m_41619_();
        AttributeInstance attackDamage = this.player.m_21051_(Attributes.f_22281_);
        if (attackDamage != null) {
            boolean hasUnarmedModifier;
            boolean bl = hasUnarmedModifier = attackDamage.m_22111_(ATTACK_DAMAGE_UNARMED_UUID) != null;
            if (isUnarmed && !hasUnarmedModifier) {
                this.addAttributeModifier(this.player, Attributes.f_22281_, ATTACK_DAMAGE_UNARMED_UUID, "Faeles Unarmed Damage", (Double)RaceAttributesConfig.FAELES.FAELES_UNARMED_DAMAGE.get(), AttributeModifier.Operation.ADDITION);
            } else if (!isUnarmed && hasUnarmedModifier) {
                this.removeAttributeModifier(this.player, Attributes.f_22281_, ATTACK_DAMAGE_UNARMED_UUID);
            }
        }
    }

    private void updateArmorPenalties() {
        int nonLeatherArmorCount = 0;
        for (ItemStack armorItem : this.player.m_6168_()) {
            ArmorItem armor;
            Item item;
            if (armorItem.m_41619_() || !((item = armorItem.m_41720_()) instanceof ArmorItem) || (armor = (ArmorItem)item).m_40401_() == ArmorMaterials.LEATHER) continue;
            ++nonLeatherArmorCount;
        }
        AttributeInstance movementSpeed = this.player.m_21051_(Attributes.f_22279_);
        if (movementSpeed != null) {
            UUID armorPenaltyUUID;
            int i;
            for (i = 0; i < 4; ++i) {
                armorPenaltyUUID = UUID.fromString("a5923e8d-1c7f-4b6a-b5e9-9d3c7f4a8d2" + i);
                movementSpeed.m_22120_(armorPenaltyUUID);
            }
            if (nonLeatherArmorCount > 0) {
                for (i = 0; i < nonLeatherArmorCount; ++i) {
                    armorPenaltyUUID = UUID.fromString("a5923e8d-1c7f-4b6a-b5e9-9d3c7f4a8d2" + i);
                    this.addAttributeModifier(this.player, Attributes.f_22279_, armorPenaltyUUID, "Armor Speed Penalty " + (i + 1), (Double)RaceAttributesConfig.FAELES.FAELES_ARMOR_SPEED_PENALTY.get(), AttributeModifier.Operation.MULTIPLY_TOTAL);
                }
            }
        }
    }

    @Override
    public void removeAttributes() {
        super.removeAttributes();
        Attribute[] attributes = new Attribute[]{Attributes.f_22281_};
        UUID[] uuids = new UUID[]{ATTACK_DAMAGE_UNARMED_UUID};
        for (int i = 0; i < attributes.length; ++i) {
            this.removeAttributeModifier(this.player, attributes[i], uuids[i]);
        }
        AttributeInstance movementSpeed = this.player.m_21051_(Attributes.f_22279_);
        if (movementSpeed != null) {
            for (int i = 0; i < 4; ++i) {
                UUID armorPenaltyUUID = UUID.fromString("a5923e8d-1c7f-4b6a-b5e9-9d3c7f4a8d2" + i);
                movementSpeed.m_22120_(armorPenaltyUUID);
            }
        }
        this.player.m_21153_(this.player.m_21223_());
    }

    @Override
    public void forceRemoveAllModifiers() {
        this.removeAttributes();
    }

    @Override
    public void handleWallClimb() {
        this.handleWallClimbInternal((Double)RaceAttributesConfig.FAELES.FAELES_CLIMB_SPEED.get(), (Double)RaceAttributesConfig.FAELES.FAELES_CLIMB_HORIZONTAL_DRAG.get());
    }

    @Override
    public void onBreakBlock(BlockPos pos, Block block, ServerLevel level) {
    }

    @Override
    public void onJump() {
        if (!this.isActive) {
            return;
        }
        Vec3 motion = this.player.m_20184_();
        double multiplier = 1.0 + (Double)RaceAttributesConfig.FAELES.FAELES_JUMP_BOOST.get();
        this.player.m_20334_(motion.f_82479_, motion.f_82480_ * multiplier, motion.f_82481_);
    }

    @Override
    public void onDrinkMilk() {
        if (!this.isActive) {
            return;
        }
        this.player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 3600, 0));
        this.player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 3600, 0));
        this.player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 3600, 0));
    }

    @Override
    public void validateAndFixAttributes() {
        if (!this.isActive) {
            return;
        }
        this.validateAndFixAttribute(Attributes.f_22281_, ATTACK_DAMAGE_UNARMED_UUID, (Double)RaceAttributesConfig.FAELES.FAELES_UNARMED_DAMAGE.get(), "Faeles Unarmed Damage", AttributeModifier.Operation.ADDITION);
        this.updateArmorPenalties();
    }
}

