/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.impl;

import com.jinqinxixi.trinketsandbaubles.capability.api.IFairyCapability;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import com.jinqinxixi.trinketsandbaubles.network.handler.NetworkHandler;
import com.jinqinxixi.trinketsandbaubles.network.message.DragonRingMessage.SyncAllDragonStatesMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.PacketDistributor;

public class FairyCapability
extends AbstractRaceCapability
implements IFairyCapability {
    private boolean flightEnabled = true;

    public FairyCapability(Player player) {
        super(player);
        this.scaleFactor = ((Double)RaceAttributesConfig.FAIRY.FAIRY_DEW_SCALE_FACTOR.get()).floatValue();
    }

    @Override
    protected void registerAttributeValues() {
        this.registerValue("MAX_HEALTH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.MAX_HEALTH).get());
        this.registerValue("FOLLOW_RANGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.FOLLOW_RANGE).get());
        this.registerValue("KNOCKBACK_RESISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.KNOCKBACK_RESISTANCE).get());
        this.registerValue("MOVEMENT_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.MOVEMENT_SPEED).get());
        this.registerValue("FLYING_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.FLYING_SPEED).get());
        this.registerValue("ATTACK_DAMAGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.ATTACK_DAMAGE).get());
        this.registerValue("ATTACK_KNOCKBACK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.ATTACK_KNOCKBACK).get());
        this.registerValue("ATTACK_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.ATTACK_SPEED).get());
        this.registerValue("ARMOR", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.ARMOR).get());
        this.registerValue("ARMOR_TOUGHNESS", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.ARMOR_TOUGHNESS).get());
        this.registerValue("LUCK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.LUCK).get());
        this.registerValue("SWIM_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.SWIM_SPEED).get());
        this.registerValue("NAMETAG_DISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.NAMETAG_DISTANCE).get());
        this.registerValue("ENTITY_GRAVITY", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.ENTITY_GRAVITY).get());
        this.registerValue("STEP_HEIGHT", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.STEP_HEIGHT).get());
        this.registerValue("BLOCK_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.BLOCK_REACH).get());
        this.registerValue("ENTITY_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.FAIRY.ENTITY_REACH).get());
    }

    @Override
    public String getRaceName() {
        return "FAIRY";
    }

    @Override
    public String getRaceId() {
        return "fairy";
    }

    @Override
    public float getManaBonus() {
        return ((Double)RaceAttributesConfig.FAIRY.FAIRY_DEW_MANA_BONUS.get()).floatValue();
    }

    @Override
    protected void onTick() {
        if (!this.isActive) {
            return;
        }
        this.player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FAIRY_DEW.get(), 30, 0, false, false, false));
        this.updateFlightAbility();
    }

    @Override
    public void setActive(boolean active) {
        if (this.isActive == active) {
            return;
        }
        if (!active) {
            if (!this.player.m_7500_() && !this.player.m_5833_()) {
                this.disableFairyFlight();
            }
        } else {
            this.updateFlightAbility();
        }
        super.setActive(active);
    }

    @Override
    public void handleWallClimb() {
        if (!this.isActive) {
            return;
        }
        double climbSpeed = (Double)RaceAttributesConfig.FAIRY.FAIRY_DEW_CLIMB_SPEED.get();
        double horizontalDrag = (Double)RaceAttributesConfig.FAIRY.FAIRY_DEW_CLIMB_HORIZONTAL_DRAG.get();
        this.handleWallClimbInternal(climbSpeed, horizontalDrag);
    }

    @Override
    public void updateFlightAbility() {
        if (!this.isActive || !this.flightEnabled) {
            return;
        }
        if (!this.player.m_7500_() && !this.player.m_5833_()) {
            this.player.m_150110_().f_35936_ = true;
            this.player.m_150110_().m_35943_(0.05f * ((Double)RaceAttributesConfig.FAIRY.FAIRY_DEW_FLIGHT_SPEED.get()).floatValue());
            this.player.m_6885_();
        } else if (this.flightEnabled) {
            this.player.m_150110_().f_35936_ = true;
            this.player.m_150110_().m_35943_(0.05f);
            this.player.m_6885_();
        }
    }

    @Override
    public boolean isFlightEnabled() {
        return this.flightEnabled;
    }

    @Override
    public void toggleFlight() {
        Player player;
        if (!this.isActive) {
            return;
        }
        boolean bl = this.flightEnabled = !this.flightEnabled;
        if (!this.flightEnabled) {
            if (!this.player.m_7500_() && !this.player.m_5833_()) {
                this.disableFairyFlight();
            }
        } else {
            this.updateFlightAbility();
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.m_237115_((String)(this.flightEnabled ? "message.trinketsandbaubles.dragon.flight.enabled" : "message.trinketsandbaubles.dragon.flight.disabled")).m_130940_(this.flightEnabled ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            serverPlayer.m_5661_((Component)message, true);
        }
        this.sync();
    }

    private void disableFairyFlight() {
        if (!this.player.m_7500_() && !this.player.m_5833_() && (this.player.m_150110_().f_35936_ || this.player.m_150110_().f_35935_)) {
            this.player.m_150110_().f_35936_ = false;
            this.player.m_150110_().f_35935_ = false;
            this.player.m_150110_().m_35943_(0.05f);
            this.player.m_6885_();
        }
    }

    @Override
    public void onBreakBlock(BlockPos pos, Block block, ServerLevel level) {
    }

    @Override
    public void sync() {
        Player player;
        if (!this.player.m_9236_().f_46443_ && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayer), (Object)new SyncAllDragonStatesMessage(this.flightEnabled, false, serverPlayer.m_19879_()));
        }
        super.sync();
    }

    @Override
    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.m_128379_("FlightEnabled", this.flightEnabled);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        super.loadAdditional(tag);
        this.flightEnabled = tag.m_128441_("FlightEnabled") ? tag.m_128471_("FlightEnabled") : true;
    }
}

