/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.impl;

import com.jinqinxixi.trinketsandbaubles.capability.api.IGoblinsCapability;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;

public class GoblinsCapability
extends AbstractRaceCapability
implements IGoblinsCapability {
    public GoblinsCapability(Player player) {
        super(player);
        this.scaleFactor = ((Double)RaceAttributesConfig.GOBLINS.GOBLIN_SCALE_FACTOR.get()).floatValue();
    }

    @Override
    protected void registerAttributeValues() {
        this.registerValue("MAX_HEALTH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.MAX_HEALTH).get());
        this.registerValue("FOLLOW_RANGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.FOLLOW_RANGE).get());
        this.registerValue("KNOCKBACK_RESISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.KNOCKBACK_RESISTANCE).get());
        this.registerValue("MOVEMENT_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.MOVEMENT_SPEED).get());
        this.registerValue("FLYING_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.FLYING_SPEED).get());
        this.registerValue("ATTACK_DAMAGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.ATTACK_DAMAGE).get());
        this.registerValue("ATTACK_KNOCKBACK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.ATTACK_KNOCKBACK).get());
        this.registerValue("ATTACK_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.ATTACK_SPEED).get());
        this.registerValue("ARMOR", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.ARMOR).get());
        this.registerValue("ARMOR_TOUGHNESS", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.ARMOR_TOUGHNESS).get());
        this.registerValue("LUCK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.LUCK).get());
        this.registerValue("SWIM_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.SWIM_SPEED).get());
        this.registerValue("NAMETAG_DISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.NAMETAG_DISTANCE).get());
        this.registerValue("ENTITY_GRAVITY", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.ENTITY_GRAVITY).get());
        this.registerValue("STEP_HEIGHT", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.STEP_HEIGHT).get());
        this.registerValue("BLOCK_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.BLOCK_REACH).get());
        this.registerValue("ENTITY_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.GOBLINS.ENTITY_REACH).get());
    }

    @Override
    public String getRaceName() {
        return "GOBLINS";
    }

    @Override
    public String getRaceId() {
        return "goblins";
    }

    @Override
    public float getManaBonus() {
        return ((Double)RaceAttributesConfig.GOBLINS.GOBLIN_MANA_PENALTY.get()).floatValue();
    }

    @Override
    protected void onTick() {
        if (!this.isActive) {
            return;
        }
        this.player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.GOBLINS.get(), 30, 0, false, false, false));
        Entity entity = this.player.m_20202_();
        if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 60, 1, false, false));
            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 0, false, false));
            if (horse.m_6084_() && !horse.m_21023_(MobEffects.f_19605_)) {
                horse.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 1, false, false));
            }
        }
    }

    @Override
    public void handleMount(AbstractHorse horse) {
        if (this.isActive && !horse.m_9236_().m_5776_()) {
            horse.m_5853_(SoundSource.NEUTRAL);
            horse.m_30651_(true);
            horse.m_30586_(this.player.m_20148_());
        }
    }

    @Override
    public float handleDamage(float damage, boolean isFireOrExplosion) {
        if (this.isActive && isFireOrExplosion) {
            return damage * ((Double)RaceAttributesConfig.GOBLINS.GOBLIN_DAMAGE_REDUCTION.get()).floatValue();
        }
        return damage;
    }

    @Override
    public void onBreakBlock(BlockPos pos, Block block, ServerLevel level) {
    }
}

