/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.impl;

import com.jinqinxixi.trinketsandbaubles.capability.api.ITitanCapability;
import com.jinqinxixi.trinketsandbaubles.capability.base.AbstractRaceCapability;
import com.jinqinxixi.trinketsandbaubles.config.RaceAttributesConfig;
import com.jinqinxixi.trinketsandbaubles.modeffects.ModEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;

public class TitanCapability
extends AbstractRaceCapability
implements ITitanCapability {
    public TitanCapability(Player player) {
        super(player);
        this.scaleFactor = ((Double)RaceAttributesConfig.TITAN.TITAN_SCALE_FACTOR.get()).floatValue();
    }

    @Override
    protected void registerAttributeValues() {
        this.registerValue("MAX_HEALTH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.MAX_HEALTH).get());
        this.registerValue("FOLLOW_RANGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.FOLLOW_RANGE).get());
        this.registerValue("KNOCKBACK_RESISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.KNOCKBACK_RESISTANCE).get());
        this.registerValue("MOVEMENT_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.MOVEMENT_SPEED).get());
        this.registerValue("FLYING_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.FLYING_SPEED).get());
        this.registerValue("ATTACK_DAMAGE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.ATTACK_DAMAGE).get());
        this.registerValue("ATTACK_KNOCKBACK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.ATTACK_KNOCKBACK).get());
        this.registerValue("ATTACK_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.ATTACK_SPEED).get());
        this.registerValue("ARMOR", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.ARMOR).get());
        this.registerValue("ARMOR_TOUGHNESS", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.ARMOR_TOUGHNESS).get());
        this.registerValue("LUCK", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.LUCK).get());
        this.registerValue("SWIM_SPEED", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.SWIM_SPEED).get());
        this.registerValue("NAMETAG_DISTANCE", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.NAMETAG_DISTANCE).get());
        this.registerValue("ENTITY_GRAVITY", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.ENTITY_GRAVITY).get());
        this.registerValue("STEP_HEIGHT", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.STEP_HEIGHT).get());
        this.registerValue("BLOCK_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.BLOCK_REACH).get());
        this.registerValue("ENTITY_REACH", () -> ((ForgeConfigSpec.DoubleValue)RaceAttributesConfig.TITAN.ENTITY_REACH).get());
    }

    @Override
    public String getRaceId() {
        return "titan";
    }

    @Override
    public String getRaceName() {
        return "TITAN";
    }

    @Override
    public float getManaBonus() {
        return ((Double)RaceAttributesConfig.TITAN.TITAN_MANA_MODIFIER.get()).floatValue();
    }

    @Override
    protected void onTick() {
        if (!this.isActive) {
            return;
        }
        this.player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.TITAN.get(), 30, 0, false, false, false));
        if (!this.player.m_9236_().f_46443_) {
            this.handlePlantBreaking();
        }
    }

    @Override
    public void handleJump() {
        if (this.isActive) {
            Vec3 motion = this.player.m_20184_();
            double multiplier = 1.0 + (Double)RaceAttributesConfig.TITAN.TITAN_JUMP_BOOST.get();
            this.player.m_20334_(motion.f_82479_, motion.f_82480_ * multiplier, motion.f_82481_);
        }
    }

    @Override
    public void onBreakBlock(BlockPos pos, Block block, ServerLevel level) {
        if (this.isActive && !level.m_5776_()) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockState state;
                        BlockPos checkPos = pos.m_7918_(x, y, z);
                        if (checkPos.equals((Object)pos) || (state = level.m_8055_(checkPos)).m_60734_() != block || !this.player.m_36298_(state)) continue;
                        level.m_46961_(checkPos, true);
                    }
                }
            }
        }
    }

    @Override
    public void handleWaterMovement() {
        if (this.player.m_20069_()) {
            this.player.m_20256_(this.player.m_20184_().m_82520_(0.0, -((Double)RaceAttributesConfig.TITAN.TITAN_WATER_SINK_SPEED.get()).doubleValue(), 0.0));
        }
    }

    @Override
    public void handlePlantBreaking() {
        double width = this.player.m_20205_();
        double height = this.player.m_20206_();
        BlockPos playerPos = this.player.m_20183_();
        int x = (int)(-width - 1.0);
        while ((double)x <= width + 1.0) {
            for (int y = -1; y <= (int)height; ++y) {
                int z = (int)(-width - 1.0);
                while ((double)z <= width + 1.0) {
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    this.handlePlantAtPosition(checkPos);
                    ++z;
                }
            }
            ++x;
        }
    }

    private void handlePlantAtPosition(BlockPos pos) {
        Level level = this.player.m_9236_();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (this.isBreakablePlant(block)) {
            if (block == Blocks.f_50093_) {
                level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 3);
            } else {
                level.m_46961_(pos, true);
            }
        }
    }

    private boolean isBreakablePlant(Block block) {
        return block instanceof CropBlock || block == Blocks.f_50034_ || block == Blocks.f_50359_ || block == Blocks.f_50035_ || block == Blocks.f_50360_ || block == Blocks.f_50111_ || block == Blocks.f_50112_ || block == Blocks.f_50113_ || block == Blocks.f_50114_ || block == Blocks.f_50115_ || block == Blocks.f_50116_ || block == Blocks.f_50117_ || block == Blocks.f_50118_ || block == Blocks.f_50119_ || block == Blocks.f_50120_ || block == Blocks.f_50121_ || block == Blocks.f_50071_ || block == Blocks.f_50092_ || block == Blocks.f_50249_ || block == Blocks.f_50250_ || block == Blocks.f_50444_ || block == Blocks.f_50093_ || block == Blocks.f_50130_ || block == Blocks.f_50571_ || block == Blocks.f_50570_ || block == Blocks.f_50685_ || block == Blocks.f_152538_ || block == Blocks.f_152539_ || block == Blocks.f_152475_ || block == Blocks.f_50191_ || block == Blocks.f_50575_ || block == Blocks.f_50576_ || block == Blocks.f_50037_ || block == Blocks.f_50038_ || block == Blocks.f_50746_ || block == Blocks.f_50747_ || block == Blocks.f_50748_ || block == Blocks.f_50749_ || block == Blocks.f_50750_ || block == Blocks.f_50751_ || block == Blocks.f_220831_;
    }
}

