/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.trinketsandbaubles.capability.mana;

import com.jinqinxixi.trinketsandbaubles.capability.event.RaceEventHandler;
import com.jinqinxixi.trinketsandbaubles.config.ModConfig;
import com.jinqinxixi.trinketsandbaubles.network.handler.ManaNetworkHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trinketsandbaubles")
public class ManaData {
    private static final String MOD_ID = "trinketsandbaubles";
    private static final String MANA_KEY = "trinketsandbaubles_mana";
    private static final String MAX_MANA_KEY = "trinketsandbaubles_maxMana";
    private static final String LAST_MANA_REGEN_TIME_KEY = "trinketsandbaubles_lastManaRegenTime";
    private static final String LAST_MANA_CHANGE_TIME_KEY = "trinketsandbaubles_lastManaChangeTime";

    public static float getMana(Player player) {
        CompoundTag data = player.getPersistentData();
        return data.m_128457_(MANA_KEY);
    }

    public static void setMana(Player player, float mana) {
        if (player == null) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        float maxMana = ManaData.getMaxMana(player);
        float newMana = Math.max(0.0f, Math.min(mana, maxMana));
        data.m_128350_(MANA_KEY, newMana);
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_8906_ != null && !serverPlayer.m_213877_()) {
                ManaData.syncManaToClient(serverPlayer);
            }
        }
    }

    public static float getMaxMana(Player player) {
        CompoundTag data = player.getPersistentData();
        float mana = data.m_128441_(MAX_MANA_KEY) ? data.m_128457_(MAX_MANA_KEY) : ((Integer)ModConfig.DEFAULT_MAX_MANA.get()).floatValue();
        return mana;
    }

    public static void setMaxMana(Player player, float maxMana) {
        if (player == null) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        maxMana = Math.max(0.0f, maxMana);
        data.m_128350_(MAX_MANA_KEY, maxMana);
        ManaData.validateMana(player);
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_8906_ != null && !serverPlayer.m_213877_()) {
                ManaData.syncManaToClient(serverPlayer);
            }
        }
    }

    public static void modifyMaxMana(Player player, float amount) {
        if (player == null) {
            return;
        }
        float currentMaxMana = ManaData.getMaxMana(player);
        float newMaxMana = Math.max(0.0f, currentMaxMana + amount);
        CompoundTag data = player.getPersistentData();
        data.m_128350_(MAX_MANA_KEY, newMaxMana);
        ManaData.validateMana(player);
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.f_8906_ != null && !serverPlayer.m_213877_()) {
                ManaData.syncManaToClient(serverPlayer);
            }
        }
    }

    public static void consumeMana(Player player, float amount) {
        if (!player.m_9236_().f_46443_) {
            CompoundTag data = player.getPersistentData();
            data.m_128356_(LAST_MANA_CHANGE_TIME_KEY, player.m_9236_().m_46467_());
            ManaData.setMana(player, ManaData.getMana(player) - amount);
        }
    }

    public static void addMana(Player player, float amount) {
        if (!player.m_9236_().f_46443_) {
            ManaData.setMana(player, ManaData.getMana(player) + amount);
        }
    }

    public static boolean hasMana(Player player, float amount) {
        return ManaData.getMana(player) >= amount;
    }

    private static void syncManaToClient(ServerPlayer player) {
        if (player == null || player.f_8906_ == null || player.m_213877_()) {
            return;
        }
        if (!player.m_9236_().m_5776_()) {
            try {
                ManaNetworkHandler.syncManaToClient(player, ManaData.getMana((Player)player), ManaData.getMaxMana((Player)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void validateMana(Player player) {
        float max;
        float current = ManaData.getMana(player);
        if (current > (max = ManaData.getMaxMana(player))) {
            ManaData.setMana(player, max);
        } else if (current < 0.0f) {
            ManaData.setMana(player, 0.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        float newConfigValue = ((Integer)ModConfig.DEFAULT_MAX_MANA.get()).floatValue();
        if (!data.m_128441_(MAX_MANA_KEY)) {
            data.m_128350_(MAX_MANA_KEY, newConfigValue);
            data.m_128350_(MANA_KEY, newConfigValue);
        } else {
            float currentMaxMana = data.m_128457_(MAX_MANA_KEY);
            float oldConfigValue = data.m_128441_("config_mana") ? data.m_128457_("config_mana") : newConfigValue;
            float itemBonus = currentMaxMana - oldConfigValue;
            float newMaxMana = newConfigValue + itemBonus;
            data.m_128350_(MAX_MANA_KEY, newMaxMana);
        }
        data.m_128350_("config_mana", newConfigValue);
        ManaData.handleLegacyData(data);
        ManaData.validateMana(player);
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_9236_().m_7654_().m_6937_((Runnable)new TickTask(serverPlayer.m_9236_().m_7654_().m_129921_() + 2, () -> {
                if (serverPlayer.f_8906_ != null && !serverPlayer.m_213877_()) {
                    ManaData.syncManaToClient(serverPlayer);
                    RaceEventHandler.refreshRaceCapabilities(player);
                    ManaData.restorePlayerMana(player);
                }
            }));
        }
    }

    public static void restorePlayerMana(Player player) {
        if (!player.m_9236_().f_46443_) {
            float maxMana = ManaData.getMaxMana(player);
            ManaData.setMana(player, maxMana);
        }
    }

    private static void handleLegacyData(CompoundTag data) {
        if (data.m_128441_(MANA_KEY) && data.m_128441_(MAX_MANA_KEY)) {
            if (data.m_128425_(MANA_KEY, 3)) {
                float oldMana = data.m_128451_(MANA_KEY);
                data.m_128350_(MANA_KEY, oldMana);
            }
            if (data.m_128425_(MAX_MANA_KEY, 3)) {
                float oldMaxMana = data.m_128451_(MAX_MANA_KEY);
                data.m_128350_(MAX_MANA_KEY, oldMaxMana);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ManaData.setMana(player, ManaData.getMaxMana(player));
            ManaData.syncManaToClient(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && !(player = event.player).m_9236_().m_5776_()) {
            CompoundTag data = player.getPersistentData();
            long currentTime = player.m_9236_().m_46467_();
            long lastRegenTime = data.m_128454_(LAST_MANA_REGEN_TIME_KEY);
            long lastManaChangeTime = data.m_128454_(LAST_MANA_CHANGE_TIME_KEY);
            if (player.m_7500_()) {
                float maxMana;
                float currentMana = ManaData.getMana(player);
                if (currentMana < (maxMana = ManaData.getMaxMana(player))) {
                    float newMana = Math.min(currentMana + ((Integer)ModConfig.CREATIVE_REGEN_RATE.get()).floatValue(), maxMana);
                    ManaData.setMana(player, newMana);
                }
            } else if (currentTime - lastRegenTime >= (long)((Integer)ModConfig.MANA_REGEN_INTERVAL.get()).intValue() && currentTime - lastManaChangeTime >= (long)((Integer)ModConfig.MANA_REGEN_COOLDOWN.get()).intValue()) {
                float maxMana;
                float currentMana = ManaData.getMana(player);
                if (currentMana < (maxMana = ManaData.getMaxMana(player))) {
                    float newMana = Math.min(currentMana + ((Integer)ModConfig.MANA_REGEN_RATE.get()).floatValue(), maxMana);
                    ManaData.setMana(player, newMana);
                }
                data.m_128356_(LAST_MANA_REGEN_TIME_KEY, currentTime);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player player = event.getEntity();
        CompoundTag originalData = original.getPersistentData();
        CompoundTag newData = player.getPersistentData();
        if (originalData.m_128441_(MAX_MANA_KEY)) {
            newData.m_128350_(MAX_MANA_KEY, originalData.m_128457_(MAX_MANA_KEY));
        }
        if (!event.isWasDeath()) {
            if (originalData.m_128441_(MANA_KEY)) {
                newData.m_128350_(MANA_KEY, originalData.m_128457_(MANA_KEY));
            }
        } else {
            newData.m_128350_(MANA_KEY, ManaData.getMaxMana(player));
        }
        newData.m_128356_(LAST_MANA_REGEN_TIME_KEY, player.m_9236_().m_46467_());
        newData.m_128356_(LAST_MANA_CHANGE_TIME_KEY, player.m_9236_().m_46467_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ManaData.syncManaToClient(serverPlayer);
        }
    }
}

